/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class IntFile {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Pattern SECTION = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    private static final Pattern KEY_VALUE = Pattern.compile("\\s*([^=]*)=(.*)");
    private static final Pattern MAP_VALUE = Pattern.compile("\\s*\\((.*)\\)");
    private static final Pattern MAP_SUB = Pattern.compile(".*?([\\s]*?,?([^=]*)=\\(([^)]*)\\).*?).*?");
    private static final String MAP_VALUE_SPLIT = ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
    private final List<Section> sections = new ArrayList<Section>();

    public IntFile(Path intFile) throws IOException {
        this(FileChannel.open(intFile, StandardOpenOption.READ), false, DEFAULT_CHARSET);
    }

    public IntFile(Path intFile, boolean syntheticRoot) throws IOException {
        this(FileChannel.open(intFile, StandardOpenOption.READ), syntheticRoot, DEFAULT_CHARSET);
    }

    public IntFile(SeekableByteChannel channel) throws IOException {
        this(channel, false, DEFAULT_CHARSET);
    }

    public IntFile(SeekableByteChannel channel, boolean syntheticRoot, Charset encoding) throws IOException {
        try (BufferedReader reader = new BufferedReader(Channels.newReader((ReadableByteChannel)channel, encoding));){
            String r;
            Section section = null;
            if (syntheticRoot) {
                section = new Section("root", new HashMap<String, Value>());
                this.sections.add(section);
            }
            while ((r = reader.readLine()) != null) {
                Record value;
                Matcher m = SECTION.matcher(r);
                if (m.matches()) {
                    section = new Section(m.group(1).trim(), new HashMap<String, Value>());
                    this.sections.add(section);
                    continue;
                }
                if (section == null || !(m = KEY_VALUE.matcher(r)).matches()) continue;
                String k = m.group(1).trim();
                String v = m.group(2).trim();
                if ((m = MAP_VALUE.matcher(v)).matches()) {
                    HashMap<String, String> vals = new HashMap<String, String>();
                    for (String s : m.group(1).trim().split(MAP_VALUE_SPLIT, -1)) {
                        m = KEY_VALUE.matcher(s);
                        if (!m.matches()) continue;
                        vals.put(m.group(1).trim(), m.group(2).trim().replaceAll("\"", ""));
                    }
                    value = new MapValue(vals);
                } else {
                    value = new SimpleValue(v);
                }
                Value current = section.values.get(k);
                if (current instanceof ListValue) {
                    ((ListValue)current).values.add((Value)((Object)value));
                    continue;
                }
                if (current != null) {
                    section.values.put(k, new ListValue(new ArrayList<Value>(Arrays.asList(current, value))));
                    continue;
                }
                section.values.put(k, (Value)((Object)value));
            }
        }
    }

    public Section section(String section) {
        return this.sections.stream().filter(s -> s.name.equalsIgnoreCase(section)).findFirst().orElse(null);
    }

    public Collection<String> sections() {
        return this.sections.stream().map(s -> s.name).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("IntFile [sections=%s]", this.sections);
    }

    public static class Section {
        public final String name;
        private final Map<String, Value> values;

        public Section(String name, Map<String, Value> values) {
            this.name = name;
            this.values = values;
        }

        public Value value(String key) {
            return this.values.get(key);
        }

        public Collection<String> keys() {
            return this.values.keySet();
        }

        public ListValue asList(String key) {
            Value val = this.value(key);
            if (val instanceof ListValue) {
                return (ListValue)val;
            }
            if (val != null) {
                return new ListValue(Collections.singletonList(val));
            }
            return new ListValue(Collections.emptyList());
        }

        public String toString() {
            return String.format("Section [name=%s, values=%s]", this.name, this.values);
        }
    }

    public record MapValue(Map<String, String> value) implements Value
    {
        public String get(String key) {
            return this.value.get(key);
        }

        public String getOrDefault(String key, String defaultValue) {
            return this.value.getOrDefault(key, defaultValue);
        }

        public boolean containsKey(String key) {
            return this.value.containsKey(key);
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }

    public record SimpleValue(String value) implements Value
    {
        @Override
        public String toString() {
            return this.value;
        }
    }

    public static interface Value {
    }

    public record ListValue(List<Value> values) implements Value
    {
        public Value get(int index) {
            return this.values.get(index);
        }

        @Override
        public String toString() {
            return this.values.toString();
        }
    }
}

