/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.compression.CompressedChunk;
import net.shrimpworks.unreal.packages.compression.CompressionFormat;
import net.shrimpworks.unreal.packages.entities.Export;
import net.shrimpworks.unreal.packages.entities.ExportedEntry;
import net.shrimpworks.unreal.packages.entities.ExportedField;
import net.shrimpworks.unreal.packages.entities.ExportedObject;
import net.shrimpworks.unreal.packages.entities.FieldTypes;
import net.shrimpworks.unreal.packages.entities.Import;
import net.shrimpworks.unreal.packages.entities.Name;
import net.shrimpworks.unreal.packages.entities.NameNumber;
import net.shrimpworks.unreal.packages.entities.Named;
import net.shrimpworks.unreal.packages.entities.ObjectFlag;
import net.shrimpworks.unreal.packages.entities.ObjectReference;
import net.shrimpworks.unreal.packages.entities.objects.Object;
import net.shrimpworks.unreal.packages.entities.objects.ObjectFactory;
import net.shrimpworks.unreal.packages.entities.objects.ObjectHeader;
import net.shrimpworks.unreal.packages.entities.properties.ArrayProperty;
import net.shrimpworks.unreal.packages.entities.properties.BooleanProperty;
import net.shrimpworks.unreal.packages.entities.properties.ByteProperty;
import net.shrimpworks.unreal.packages.entities.properties.EnumProperty;
import net.shrimpworks.unreal.packages.entities.properties.FixedArrayProperty;
import net.shrimpworks.unreal.packages.entities.properties.FloatProperty;
import net.shrimpworks.unreal.packages.entities.properties.IntegerProperty;
import net.shrimpworks.unreal.packages.entities.properties.NameProperty;
import net.shrimpworks.unreal.packages.entities.properties.ObjectProperty;
import net.shrimpworks.unreal.packages.entities.properties.Property;
import net.shrimpworks.unreal.packages.entities.properties.PropertyType;
import net.shrimpworks.unreal.packages.entities.properties.StringProperty;
import net.shrimpworks.unreal.packages.entities.properties.StructProperty;
import net.shrimpworks.unreal.packages.entities.properties.UnknownArrayProperty;

public class Package
implements Closeable {
    static final int PKG_SIGNATURE = -1641380927;
    private static final int MAX_PROPERTIES = 256;
    private static final String SHA1 = "SHA-1";
    private static final int[] PROPERTY_SIZE_MAP = new int[]{1, 2, 4, 12, 16};
    private final PackageReader reader;
    public final int version;
    public final int license;
    public final int engineVersion;
    public final CompressionFormat compressionFormat;
    public final int compressedChunkCount;
    public final int flags;
    public final Name[] names;
    public final Export[] exports;
    public final Import[] imports;
    public final ExportedObject[] objects;
    public final ExportedField[] fields;
    private final WeakHashMap<Integer, Object> loadedObjects;
    private final WeakHashMap<Integer, ObjectReference> objectReferences;

    public Package(Path packageFile) throws IOException {
        this(new PackageReader(packageFile));
    }

    public Package(PackageReader reader) {
        int i;
        this.reader = reader;
        reader.moveTo(0L);
        if (reader.readInt() != -1641380927) {
            throw new IllegalArgumentException("Package does not seem to be an Unreal package");
        }
        this.loadedObjects = new WeakHashMap();
        this.objectReferences = new WeakHashMap();
        reader.version = this.version = (int)reader.readShort();
        this.license = reader.readShort();
        if (this.version >= 249) {
            reader.readInt();
        }
        if (this.version >= 269) {
            reader.readString();
        }
        this.flags = reader.readInt();
        int nameCount = reader.readInt();
        int namePos = reader.readInt();
        int exportCount = reader.readInt();
        int exportPos = reader.readInt();
        int importCount = reader.readInt();
        int importPos = reader.readInt();
        if (this.version >= 415) {
            reader.readInt();
        }
        if (this.version >= 584) {
            reader.moveRelative(16);
        }
        if (this.version < 68) {
            reader.readInt();
            reader.readInt();
        } else {
            reader.moveRelative(16);
            int generationCount = reader.readInt();
            for (i = 0; i < generationCount; ++i) {
                reader.readInt();
                reader.readInt();
                if (this.version <= 322) continue;
                reader.readInt();
            }
        }
        int n = this.engineVersion = this.version >= 245 ? reader.readInt() : this.version;
        if (this.version >= 277) {
            reader.readInt();
        }
        this.compressionFormat = this.version >= 334 ? CompressionFormat.fromFlag(reader.readInt()) : CompressionFormat.NONE;
        int n2 = this.compressedChunkCount = this.version >= 334 ? reader.readInt() : 0;
        if (this.compressionFormat != CompressionFormat.NONE) {
            CompressedChunk[] chunks = new CompressedChunk[this.compressedChunkCount];
            for (i = 0; i < this.compressedChunkCount; ++i) {
                chunks[i] = new CompressedChunk(this.compressionFormat, reader.readInt(), reader.readInt(), reader.readInt(), reader.readInt());
            }
            reader.setChunks(chunks);
        }
        this.names = this.names(nameCount, namePos);
        this.exports = this.exports(exportCount, exportPos);
        this.imports = this.imports(importCount, importPos);
        this.objects = new ExportedObject[this.exports.length];
        this.fields = new ExportedField[this.exports.length];
        for (int i2 = 0; i2 < this.exports.length; ++i2) {
            ExportedEntry e = (ExportedEntry)this.exports[i2];
            if (FieldTypes.isField(e.classIndex)) {
                this.fields[i2] = e.asField();
                continue;
            }
            this.objects[i2] = e.asObject();
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public String sha1Hash() {
        return this.reader.hash(SHA1);
    }

    public Set<PackageFlag> flags() {
        return PackageFlag.fromFlags(this.flags);
    }

    public Collection<Import> packageImports() {
        ArrayList<Import> packages = new ArrayList<Import>();
        for (Import i : this.imports) {
            if (i.packageIndex.index != 0) continue;
            packages.add(i);
        }
        return packages;
    }

    public Collection<Export> rootExports() {
        ArrayList<Export> roots = new ArrayList<Export>();
        for (Export e : this.exports) {
            if (e.groupIndex.index != 0) continue;
            roots.add(e);
        }
        return roots;
    }

    public Collection<Export> exportsByClassName(String className) {
        HashSet<Export> exports = new HashSet<Export>();
        for (Export ex : this.exports) {
            Named type = ex.classIndex.get();
            if (!(type instanceof Import) || !((Import)type).name.name.equals(className)) continue;
            exports.add(ex);
        }
        return exports;
    }

    public Collection<ExportedObject> objectsByClassName(String className) {
        HashSet<ExportedObject> exports = new HashSet<ExportedObject>();
        for (ExportedObject ex : this.objects) {
            Named type;
            if (ex == null || !((type = ex.classIndex.get()) instanceof Import) || !((Import)type).name.name.equals(className)) continue;
            exports.add(ex);
        }
        return exports;
    }

    public ExportedObject objectByRef(ObjectReference ref) {
        Named resolved = ref.get();
        if (!(resolved instanceof Export)) {
            throw new IllegalArgumentException("No exported object found for reference " + String.valueOf(ref));
        }
        ExportedObject exportedObject = this.objects[((Export)resolved).index];
        if (exportedObject == null) {
            throw new IllegalArgumentException("Found export is not an object " + String.valueOf(ref));
        }
        return exportedObject;
    }

    public ExportedObject objectByName(Name name) {
        for (ExportedObject object : this.objects) {
            if (object == null || !object.name.name.equalsIgnoreCase(name.name)) continue;
            return object;
        }
        return null;
    }

    public ExportedObject objectByExport(Export export) {
        ExportedObject exportedObject = this.objects[export.index];
        if (exportedObject == null) {
            throw new IllegalArgumentException("Found export is not an object " + String.valueOf(export));
        }
        return exportedObject;
    }

    private Name[] names(int count, int pos) {
        Name[] names = new Name[count];
        this.reader.moveTo(pos);
        for (int i = 0; i < count; ++i) {
            this.reader.ensureRemaining(256);
            names[i] = new Name(this.reader.readString(), 0, this.version >= 141 ? this.reader.readLong() : (long)this.reader.readInt());
        }
        return names;
    }

    private Export[] exports(int count, int pos) {
        assert (this.names != null && this.names.length > 0);
        Export[] exports = new Export[count];
        this.reader.moveTo(pos);
        for (int i = 0; i < count; ++i) {
            this.reader.ensureRemaining(128);
            exports[i] = this.readExport(i);
        }
        return exports;
    }

    private Import[] imports(int count, int pos) {
        assert (this.names != null && this.names.length > 0);
        Import[] imports = new Import[count];
        this.reader.moveTo(pos);
        for (int i = 0; i < count; ++i) {
            this.reader.ensureRemaining(40);
            imports[i] = this.readImport(i);
        }
        return imports;
    }

    private ObjectReference objectReference(int index) {
        if (index == 0) {
            return ObjectReference.NULL;
        }
        return this.objectReferences.computeIfAbsent(index, i -> new ObjectReference(this, (int)i));
    }

    private Name name(int index) {
        return this.names[index];
    }

    private Name name(NameNumber name) {
        return new Name(this.names[name.name].name, name.number, this.names[name.name].flags);
    }

    private Export readExport(int index) {
        int i;
        ObjectReference classIndex = this.objectReference(this.reader.readIndex());
        ObjectReference superClassIndex = this.objectReference(this.reader.readIndex());
        ObjectReference groupIndex = this.objectReference(this.reader.readInt());
        Name name = this.name(this.reader.readNameIndex());
        if (this.version >= 220) {
            this.reader.readInt();
        }
        long flags = this.version >= 195 ? this.reader.readLong() : (long)this.reader.readInt();
        int size = this.reader.readIndex();
        int pos = size > 0 || this.version >= 249 ? this.reader.readIndex() : 0;
        Map<Name, ObjectReference> components = Map.of();
        if (this.version >= 220 && this.version < 543) {
            int componentCount = this.reader.readInt();
            components = new HashMap();
            if (componentCount > 0) {
                this.reader.ensureRemaining(componentCount * 12 + 28);
            }
            for (i = 0; i < componentCount; ++i) {
                components.put(this.name(this.reader.readNameIndex()), this.objectReference(this.reader.readInt()));
            }
        }
        if (this.version >= 220) {
            this.reader.readInt();
        }
        int netObjectCount = 0;
        if (this.version >= 322) {
            netObjectCount = this.reader.readInt();
        }
        if (this.version >= 220) {
            this.reader.moveRelative(16);
        }
        if (this.version >= 487) {
            this.reader.readInt();
        }
        if (netObjectCount > 0) {
            for (i = 0; i < netObjectCount; ++i) {
                this.reader.readIndex();
            }
        }
        return new ExportedEntry(this, index, classIndex, superClassIndex, groupIndex, name, flags, size, pos, components);
    }

    private Import readImport(int index) {
        Name classPackage = this.name(this.reader.readNameIndex());
        Name className = this.name(this.reader.readNameIndex());
        ObjectReference packageIndex = this.objectReference(this.reader.readInt());
        Name name = this.name(this.reader.readNameIndex());
        return new Import(this, index, classPackage, className, packageIndex, name);
    }

    public Object object(ExportedObject export) {
        Object existing = this.loadedObjects.get(export.pos);
        if (existing != null) {
            return existing;
        }
        if (export.size <= 0) {
            throw new IllegalStateException(String.format("Export %s has no associated object data!", export.name));
        }
        if (export.classIndex.index == 0) {
            return null;
        }
        this.reader.moveTo(export.pos);
        ObjectHeader header = null;
        if (export.flags().contains((java.lang.Object)ObjectFlag.HasStack)) {
            int node = this.reader.readIndex();
            header = new ObjectHeader(node, this.reader.readIndex(), this.reader.readLong(), this.reader.readInt(), node != 0 ? this.reader.readIndex() : 0);
        }
        if (this.version >= 322) {
            this.reader.readIndex();
        }
        List<Property> properties = this.readProperties();
        int postPropsPosition = this.reader.currentPosition();
        Object newObject = ObjectFactory.newInstance(this, this.reader, export, header, properties, postPropsPosition);
        this.loadedObjects.put(export.pos, newObject);
        return newObject;
    }

    private List<Property> readProperties() {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (int i = 0; i < 256; ++i) {
            Property p = this.readProperty();
            if (p.name.equals(Name.NONE)) break;
            if (p instanceof ArrayProperty.ArrayItem && !properties.isEmpty()) {
                Property lastProperty = (Property)properties.getLast();
                if (lastProperty instanceof ArrayProperty) {
                    properties.remove(lastProperty);
                    properties.add(((ArrayProperty)lastProperty).add((ArrayProperty.ArrayItem)p));
                    continue;
                }
                if (lastProperty.name.equals(p.name)) {
                    properties.remove(lastProperty);
                    properties.add(new ArrayProperty(((ArrayProperty.ArrayItem)p).property));
                    continue;
                }
                properties.add(((ArrayProperty.ArrayItem)p).property);
                continue;
            }
            properties.add(p);
        }
        return properties;
    }

    private Property readProperty() {
        Name name = this.name(this.reader.readNameIndex());
        if (name.equals(Name.NONE)) {
            return new NameProperty(this, name, name);
        }
        if (this.version > 220) {
            return this.readPropertyUE3(name);
        }
        byte propInfo = this.reader.readByte();
        byte type = (byte)(propInfo & 0xF);
        int size = (propInfo & 0x70) >> 4;
        boolean boolOrArrayFlag = (propInfo & 0x80) != 0;
        PropertyType propType = PropertyType.get(type);
        if (propType == null) {
            throw new IllegalStateException(String.format("Unknown property type index %d for property %s", type, name.name));
        }
        StructProperty.StructType structType = null;
        if (propType == PropertyType.StructProperty) {
            int structIdx = this.reader.readIndex();
            StructProperty.StructType structType2 = structType = structIdx >= 0 ? StructProperty.StructType.get(this.name(structIdx)) : null;
            if (structType == null) {
                throw new IllegalStateException(String.format("Unknown struct type index %d for property %s", structIdx, name.name));
            }
        }
        size = switch (size) {
            case 0, 1, 2, 3, 4 -> PROPERTY_SIZE_MAP[size];
            case 5 -> this.reader.readByte() & 0xFF;
            case 6 -> this.reader.readShort();
            case 7 -> this.reader.readInt();
            default -> throw new IllegalArgumentException(String.format("Unknown property field size %d", size));
        };
        byte arrayIndex = 0;
        if (boolOrArrayFlag && propType != PropertyType.BoolProperty) {
            arrayIndex = this.reader.readByte();
        }
        Property property = this.createProperty(name, propType, structType, size, boolOrArrayFlag);
        if (boolOrArrayFlag && propType != PropertyType.BoolProperty) {
            return new ArrayProperty.ArrayItem(property, arrayIndex);
        }
        return property;
    }

    private Property readPropertyUE3(Name name) {
        Name typeName = this.name(this.reader.readNameIndex());
        PropertyType propType = PropertyType.get(typeName);
        if (propType == null) {
            throw new IllegalStateException(String.format("Unknown property type named %s for property %s", typeName.name, name.name));
        }
        if (propType == PropertyType.ByteProperty) {
            propType = PropertyType.EnumProperty;
        }
        int size = this.reader.readInt();
        int arrayIndex = this.reader.readInt();
        StructProperty.StructType structType = propType == PropertyType.StructProperty ? StructProperty.StructType.get(this.name(this.reader.readNameIndex())) : null;
        boolean booleanFlag = propType == PropertyType.BoolProperty && this.reader.readInt() > 0;
        Property property = this.createProperty(name, propType, structType, size, booleanFlag);
        if (propType == PropertyType.ArrayProperty && !(property instanceof ArrayProperty)) {
            return new ArrayProperty.ArrayItem(property, arrayIndex);
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Property createProperty(Name name, PropertyType type, StructProperty.StructType structType, int size, boolean arrayFlag) {
        int startPos = this.reader.position();
        try {
            Property property = switch (type) {
                case PropertyType.BoolProperty -> new BooleanProperty(this, name, arrayFlag);
                case PropertyType.ByteProperty -> new ByteProperty(this, name, this.reader.readByte());
                case PropertyType.EnumProperty -> new EnumProperty(this, name, this.name(this.reader.readNameIndex()));
                case PropertyType.IntProperty -> new IntegerProperty(this, name, this.reader.readInt());
                case PropertyType.FloatProperty -> new FloatProperty(this, name, this.reader.readFloat());
                case PropertyType.StrProperty, PropertyType.StringProperty -> new StringProperty(this, name, this.reader.readString(size));
                case PropertyType.NameProperty -> new NameProperty(this, name, name.equals(Name.NONE) ? Name.NONE : this.name(this.reader.readNameIndex()));
                case PropertyType.ObjectProperty -> new ObjectProperty(this, name, this.objectReference(this.reader.readIndex()));
                case PropertyType.StructProperty -> {
                    switch (structType) {
                        case PointRegion: {
                            yield new StructProperty.PointRegionProperty(this, name, this.objectReference(this.reader.readIndex()), this.reader.readInt(), this.reader.readByte());
                        }
                        case Scale: {
                            yield new StructProperty.ScaleProperty(this, name, this.reader.readFloat(), this.reader.readFloat(), this.reader.readFloat(), this.reader.readFloat(), this.reader.readByte());
                        }
                        case Rotator: {
                            yield new StructProperty.RotatorProperty(this, name, this.reader.readInt(), this.reader.readInt(), this.reader.readInt());
                        }
                        case Color: {
                            yield new StructProperty.ColorProperty(this, name, this.reader.readByte(), this.reader.readByte(), this.reader.readByte(), this.reader.readByte());
                        }
                        case Sphere: {
                            yield new StructProperty.SphereProperty(this, name, this.reader.readFloat(), this.reader.readFloat(), this.reader.readFloat(), this.reader.readFloat());
                        }
                    }
                    if (size == 12) {
                        yield new StructProperty.VectorProperty(this, name, this.reader.readFloat(), this.reader.readFloat(), this.reader.readFloat());
                    }
                    yield new StructProperty.UnknownStructProperty(this, name);
                }
                case PropertyType.RotatorProperty -> new StructProperty.RotatorProperty(this, name, this.reader.readInt(), this.reader.readInt(), this.reader.readInt());
                case PropertyType.VectorProperty -> new StructProperty.VectorProperty(this, name, this.reader.readFloat(), this.reader.readFloat(), this.reader.readFloat());
                case PropertyType.ArrayProperty -> {
                    int arraySize = this.reader.readIndex();
                    if (name.name.equalsIgnoreCase("ReferencedTextures")) {
                        List items = IntStream.range(0, arraySize).mapToObj(i -> new ObjectProperty(this, name, this.objectReference(this.reader.readIndex()))).collect(Collectors.toList());
                        yield new ArrayProperty(this, name, items);
                    }
                    yield new UnknownArrayProperty(this, name, arraySize);
                }
                case PropertyType.FixedArrayProperty -> new FixedArrayProperty(this, name, this.objectReference(this.reader.readIndex()), this.reader.readIndex());
                default -> throw new IllegalArgumentException("Cannot read unsupported property type " + type.name());
            };
            return property;
        }
        finally {
            if (this.reader.position() - startPos < size) {
                this.reader.moveRelative(size - (this.reader.position() - startPos));
            }
        }
    }

    public static enum PackageFlag {
        AllowDownload(1),
        ClientOptional(2),
        ServerSideOnly(4),
        BrokenLinks(8),
        Unsecure(16),
        Need(32768);

        private final int flag;

        private PackageFlag(int flag) {
            this.flag = flag;
        }

        public static Set<PackageFlag> fromFlags(int flags) {
            EnumSet<PackageFlag> objectFlags = EnumSet.noneOf(PackageFlag.class);
            objectFlags.addAll(Arrays.stream(PackageFlag.values()).filter(f -> (flags & f.flag) == f.flag).collect(Collectors.toSet()));
            return objectFlags;
        }
    }
}

