/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import net.shrimpworks.unreal.packages.IntFile;
import net.shrimpworks.unreal.packages.PackageReader;

public class Umod
implements Closeable {
    private static final int UMOD_SIGNATURE = -1612462685;
    private static final String SHA1 = "SHA-1";
    private final PackageReader reader;
    public final int version;
    public final int size;
    public final UmodFile[] files;
    public final IntFile manifestIni;
    public final IntFile manifestInt;

    public Umod(Path umodFile) throws IOException {
        this(new PackageReader(umodFile));
    }

    public Umod(PackageReader reader) {
        this.reader = reader;
        reader.moveTo(reader.size() - 20L);
        if (reader.readInt() != -1612462685) {
            throw new IllegalArgumentException("Package does not seem to be a UMOD package");
        }
        long filesOffset = reader.readInt();
        this.size = reader.readInt();
        reader.version = this.version = reader.readInt();
        long checksum = reader.readInt();
        reader.moveTo(filesOffset);
        int fileCount = reader.readIndex();
        this.files = new UmodFile[fileCount];
        for (int i = 0; i < fileCount; ++i) {
            UmodFile file;
            reader.ensureRemaining(270);
            this.files[i] = file = this.readFile();
        }
        this.manifestIni = Arrays.stream(this.files).filter(f -> f.name.toLowerCase().endsWith("manifest.ini")).findFirst().map(u -> {
            try {
                return new IntFile(u.read());
            }
            catch (IOException e) {
                return null;
            }
        }).orElse(null);
        this.manifestInt = Arrays.stream(this.files).filter(f -> f.name.toLowerCase().endsWith("manifest.int")).findFirst().map(u -> {
            try {
                return new IntFile(u.read());
            }
            catch (IOException e) {
                return null;
            }
        }).orElse(null);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private UmodFile readFile() {
        int nameSize = this.reader.readIndex();
        byte[] val = new byte[nameSize];
        this.reader.readBytes(val, 0, nameSize);
        String name = new String(val, StandardCharsets.US_ASCII).trim();
        int offset = this.reader.readInt();
        int size = this.reader.readInt();
        int flags = this.reader.readInt();
        return new UmodFile(name, size, offset, flags);
    }

    public class UmodFile {
        public final String name;
        public final int size;
        private final int offset;
        private final int flags;

        private UmodFile(String name, int size, int offset, int flags) {
            this.name = name;
            this.size = size;
            this.offset = offset;
            this.flags = flags;
        }

        public SeekableByteChannel read() {
            return new UmodFileChannel(Umod.this.reader, this.offset, this.size);
        }

        public String sha1() throws IOException {
            try (PackageReader reader = new PackageReader(this.read());){
                String string = reader.hash(Umod.SHA1);
                return string;
            }
        }

        public String toString() {
            return String.format("UmodFile [name=%s]", this.name);
        }
    }

    private static class UmodFileChannel
    implements SeekableByteChannel {
        private final PackageReader reader;
        private final long offset;
        private final long size;

        private UmodFileChannel(PackageReader reader, int offset, int size) {
            this.reader = reader;
            this.offset = offset;
            this.size = size;
            reader.moveTo(offset);
        }

        @Override
        public int read(ByteBuffer dst) {
            if (this.position() == this.size) {
                return -1;
            }
            int cnt = dst.position();
            int remain = (int)(this.size - this.position());
            byte[] buff = new byte[Math.min(dst.remaining(), remain)];
            this.reader.ensureRemaining(buff.length);
            int read = this.reader.readBytes(buff, 0, buff.length);
            dst.put(buff, 0, read);
            return dst.position() - cnt;
        }

        @Override
        public long position() {
            return (long)this.reader.currentPosition() - this.offset;
        }

        @Override
        public SeekableByteChannel position(long newPosition) {
            if (newPosition > this.size) {
                throw new IllegalArgumentException("Cannot seek beyond size " + this.size);
            }
            this.reader.moveTo(this.offset + newPosition);
            return this;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public SeekableByteChannel truncate(long size) {
            throw new UnsupportedOperationException("Truncate not supported");
        }

        @Override
        public int write(ByteBuffer src) {
            throw new UnsupportedOperationException("Write not supported");
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() {
        }
    }
}

