/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.compression;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.compression.CompressedChunk;
import net.shrimpworks.unreal.packages.compression.CompressionFormat;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoConstraint;
import org.anarres.lzo.LzoDecompressor;
import org.anarres.lzo.LzoLibrary;
import org.anarres.lzo.lzo_uintp;

public class ChunkChannel
implements SeekableByteChannel {
    public final CompressedChunk chunk;
    private final PackageReader reader;
    private final int[] blockSizes;
    private final byte[] data;
    private final AtomicBoolean closed = new AtomicBoolean();
    private int position;
    private int size;

    public ChunkChannel(PackageReader reader, CompressedChunk chunk, int[] blockSizes, byte[] data) {
        this.chunk = chunk;
        this.reader = reader;
        this.blockSizes = blockSizes;
        this.data = data;
        this.size = data.length;
        this.open();
    }

    public ChunkChannel(PackageReader reader, CompressedChunk chunk, int size, int[] blockSizes) {
        this(reader, chunk, blockSizes, new byte[size]);
    }

    private void open() {
        if (this.chunk.compressionFormat != CompressionFormat.LZO) {
            throw new IllegalArgumentException("Unsupported compression format " + this.chunk.compressionFormat.name());
        }
        LzoDecompressor dec = LzoLibrary.getInstance().newDecompressor(LzoAlgorithm.LZO1X, LzoConstraint.SAFETY);
        try {
            for (int i = 0; i < this.blockSizes.length; i += 2) {
                byte[] in = new byte[this.blockSizes[i]];
                byte[] out = new byte[this.blockSizes[i + 1]];
                this.reader.readBytes(in, 0, in.length);
                int lzoRes = dec.decompress(in, 0, in.length, out, 0, new lzo_uintp(out.length));
                if (lzoRes != 0) {
                    throw new IllegalStateException("LZO read error: " + lzoRes);
                }
                this.write(ByteBuffer.wrap(out));
            }
            this.position(0L);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to construct decompressed data channel", ex);
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.ensureOpen();
        if (newPosition < 0L || newPosition > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position has to be in range 0.. 2147483647");
        }
        this.position = (int)newPosition;
        return this;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public SeekableByteChannel truncate(long newSize) {
        if (newSize < 0L || newSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size has to be in range 0.. 2147483647");
        }
        if ((long)this.size > newSize) {
            this.size = (int)newSize;
        }
        if ((long)this.position > newSize) {
            this.position = (int)newSize;
        }
        return this;
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        this.ensureOpen();
        int wanted = buf.remaining();
        int possible = this.size - this.position;
        if (possible <= 0) {
            return -1;
        }
        if (wanted > possible) {
            wanted = possible;
        }
        buf.put(this.data, this.position, wanted);
        this.position += wanted;
        return wanted;
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public int write(ByteBuffer b) throws IOException {
        this.ensureOpen();
        int wanted = b.remaining();
        int possibleWithoutResize = this.size - this.position;
        if (wanted > possibleWithoutResize) {
            throw new BufferOverflowException();
        }
        b.get(this.data, this.position, wanted);
        this.position += wanted;
        if (this.size < this.position) {
            this.size = this.position;
        }
        return wanted;
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

