/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.entities.Name;
import net.shrimpworks.unreal.packages.entities.Named;
import net.shrimpworks.unreal.packages.entities.ObjectFlag;
import net.shrimpworks.unreal.packages.entities.ObjectReference;

public abstract class Export
implements Named {
    protected final Package pkg;
    public final int index;
    public final ObjectReference classIndex;
    public final ObjectReference classSuperIndex;
    public final ObjectReference groupIndex;
    public final Name name;
    public final long flags;
    public final int size;
    public final int pos;
    public final Map<Name, ObjectReference> components;
    private Set<Export> children;

    Export(Package pkg, int index, ObjectReference classIndex, ObjectReference classSuperIndex, ObjectReference groupIndex, Name name, long flags, int size, int pos, Map<Name, ObjectReference> components) {
        this.pkg = pkg;
        this.index = index;
        this.classIndex = classIndex;
        this.classSuperIndex = classSuperIndex;
        this.groupIndex = groupIndex;
        this.name = name;
        this.flags = flags;
        this.size = size;
        this.pos = pos;
        this.components = components;
    }

    @Override
    public Name name() {
        return this.name;
    }

    public Set<ObjectFlag> flags() {
        return ObjectFlag.fromFlags(this.flags);
    }

    public Name groupName() {
        return this.groupIndex.get().name();
    }

    public Set<Export> children() {
        if (this.children == null) {
            this.children = Arrays.stream(this.pkg.exports).filter(e -> e.groupIndex.get(true) == this).collect(Collectors.toSet());
        }
        return this.children;
    }

    public String toString() {
        return String.format("%s [index=%s, classIndex=%s, classSuperIndex=%s, groupIndex=%s, name=%s, flags=%s, size=%s, pos=%s, components=%s]", this.getClass().getSimpleName(), this.index, this.classIndex, this.classSuperIndex, this.groupIndex, this.name, this.flags(), this.size, this.pos, this.components);
    }
}

