/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.entities.Name;
import net.shrimpworks.unreal.packages.entities.Named;
import net.shrimpworks.unreal.packages.entities.ObjectReference;

public class Import
implements Named {
    private final Package pkg;
    private final int index;
    public final Name classPackage;
    public final Name className;
    public final ObjectReference packageIndex;
    public final Name name;
    private Set<Import> children;

    public Import(Package pkg, int index, Name classPackage, Name className, ObjectReference packageIndex, Name name) {
        this.pkg = pkg;
        this.index = index;
        this.classPackage = classPackage;
        this.className = className;
        this.packageIndex = packageIndex;
        this.name = name;
    }

    @Override
    public Name name() {
        return this.name;
    }

    public Set<Import> children() {
        if (this.children == null) {
            this.children = Arrays.stream(this.pkg.imports).filter(i -> i.packageIndex.get() == this).collect(Collectors.toSet());
        }
        return this.children;
    }

    public String toString() {
        return String.format("Import [classPackage=%s, className=%s, packageName=%s, name=%s]", this.classPackage, this.className, this.packageIndex, this.name);
    }
}

