/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum ObjectFlag {
    Transactional(0x100000000L),
    Unreachable(0x200000000L),
    Public(0x400000000L),
    TagImp(0x800000000L),
    TagExp(0x1000000000L),
    SourceModified(0x2000000000L),
    TagGarbage(0x4000000000L),
    NeedLoad(0x20000000000L),
    HighlightedName(0x40000000000L),
    EliminateObject(0x40000000000L),
    InSingularFunc(0x80000000000L),
    RemappedName(0x80000000000L),
    Suppress(0x100000000000L),
    StateChanged(0x100000000000L),
    InEndState(0x200000000000L),
    Transient(0x400000000000L),
    PreLoading(0x800000000000L),
    LoadForClient(0x1000000000000L),
    LoadForServer(0x2000000000000L),
    LoadForEdit(0x4000000000000L),
    Standalone(0x8000000000000L),
    NotForClient(0x10000000000000L),
    NotForServer(0x20000000000000L),
    NotForEdit(0x40000000000000L),
    Destroyed(0x80000000000000L),
    NeedPostLoad(0x100000000000000L),
    HasStack(0x200000000000000L),
    Native(0x400000000000000L),
    Marked(0x800000000000000L),
    ErrorShutdown(0x1000000000000000L),
    DebugPostLoad(0x2000000000000000L),
    DebugSerialize(0x4000000000000000L),
    DebugDestroy(Long.MIN_VALUE);

    private final long flag;

    private ObjectFlag(long flag) {
        this.flag = flag;
    }

    public static Set<ObjectFlag> fromFlags(long flags) {
        EnumSet<ObjectFlag> objectFlags = EnumSet.noneOf(ObjectFlag.class);
        objectFlags.addAll(Arrays.stream(ObjectFlag.values()).filter(f -> (flags & f.flag) == f.flag).collect(Collectors.toSet()));
        objectFlags.addAll(Arrays.stream(ObjectFlag.values()).filter(f -> (flags << 32 & f.flag) == f.flag).collect(Collectors.toSet()));
        return objectFlags;
    }
}

