/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.Export;
import net.shrimpworks.unreal.packages.entities.ObjectReference;
import net.shrimpworks.unreal.packages.entities.objects.Object;
import net.shrimpworks.unreal.packages.entities.objects.ObjectHeader;
import net.shrimpworks.unreal.packages.entities.objects.geometry.Bound;
import net.shrimpworks.unreal.packages.entities.objects.geometry.Leaf;
import net.shrimpworks.unreal.packages.entities.objects.geometry.LightMap;
import net.shrimpworks.unreal.packages.entities.objects.geometry.Node;
import net.shrimpworks.unreal.packages.entities.objects.geometry.Sphere;
import net.shrimpworks.unreal.packages.entities.objects.geometry.Surface;
import net.shrimpworks.unreal.packages.entities.objects.geometry.Vector;
import net.shrimpworks.unreal.packages.entities.objects.geometry.Vert;
import net.shrimpworks.unreal.packages.entities.objects.geometry.Zone;
import net.shrimpworks.unreal.packages.entities.properties.Property;

public class Model
extends Object {
    public final Bound boundingBox;
    public final Sphere boundingSphere;
    public final List<Vector> vectors;
    public final List<Vector> points;
    public final List<Node> nodes;
    public final List<Surface> surfaces;
    public final List<Vert> verts;
    public final int numSharedSides;
    public final List<Zone> zones;
    public final ObjectReference polys;
    public final List<LightMap> lightMaps;
    public final List<Byte> lightBits;
    public final List<Bound> bounds;
    public final List<Integer> leafHulls;
    public final List<Leaf> leaves;
    public final List<ObjectReference> lights;
    public final int rootOutside;
    public final int linked;

    public Model(Package pkg, PackageReader reader, Export export, ObjectHeader header, Collection<Property> properties, int dataStart) {
        super(pkg, reader, export, header, properties, dataStart);
        reader.moveTo(dataStart);
        reader.ensureRemaining(64);
        this.boundingBox = new Bound(reader);
        this.boundingSphere = new Sphere(reader);
        int vectorCount = reader.readIndex();
        this.vectors = new ArrayList<Vector>(vectorCount);
        for (int i = 0; i < vectorCount; ++i) {
            reader.ensureRemaining(16);
            this.vectors.add(new Vector(reader));
        }
        int pointCount = reader.readIndex();
        this.points = new ArrayList<Vector>(pointCount);
        for (int i = 0; i < pointCount; ++i) {
            reader.ensureRemaining(16);
            this.points.add(new Vector(reader));
        }
        int nodeCount = reader.readIndex();
        this.nodes = new ArrayList<Node>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            reader.ensureRemaining(64);
            if (pkg.version >= 117) continue;
            this.nodes.add(new Node(reader));
        }
        int surfCount = reader.readIndex();
        this.surfaces = new ArrayList<Surface>(surfCount);
        for (int i = 0; i < surfCount; ++i) {
            reader.ensureRemaining(32);
            if (pkg.version >= 117) continue;
            this.surfaces.add(new Surface(pkg, reader));
        }
        int vertCount = reader.readIndex();
        this.verts = new ArrayList<Vert>(vertCount);
        for (int i = 0; i < vertCount; ++i) {
            reader.ensureRemaining(8);
            this.verts.add(new Vert(reader));
        }
        this.numSharedSides = reader.readInt();
        int zoneCount = reader.readInt();
        this.zones = new ArrayList<Zone>(zoneCount);
        for (int i = 0; i < zoneCount; ++i) {
            reader.ensureRemaining(32);
            this.zones.add(new Zone(pkg, reader));
            if (pkg.version < 63) {
                reader.readFloat();
            }
            if (pkg.version < 117) continue;
            reader.readInt();
        }
        this.polys = new ObjectReference(pkg, reader.readIndex());
        int lightMapCount = reader.readIndex();
        this.lightMaps = new ArrayList<LightMap>(lightMapCount);
        for (int i = 0; i < lightMapCount; ++i) {
            reader.ensureRemaining(32);
            this.lightMaps.add(new LightMap(pkg, reader));
        }
        int lightBitCount = reader.readIndex();
        this.lightBits = new ArrayList<Byte>(lightBitCount);
        for (int i = 0; i < lightBitCount; ++i) {
            reader.ensureRemaining(1);
            this.lightBits.add(reader.readByte());
        }
        int boundCount = reader.readIndex();
        this.bounds = new ArrayList<Bound>(boundCount);
        for (int i = 0; i < boundCount; ++i) {
            reader.ensureRemaining(25);
            this.bounds.add(new Bound(reader));
        }
        int leafHullsCount = reader.readIndex();
        this.leafHulls = new ArrayList<Integer>(leafHullsCount);
        for (int i = 0; i < leafHullsCount; ++i) {
            reader.ensureRemaining(4);
            this.leafHulls.add(reader.readInt());
        }
        int leavesCount = reader.readIndex();
        this.leaves = new ArrayList<Leaf>(leavesCount);
        for (int i = 0; i < leavesCount; ++i) {
            reader.ensureRemaining(32);
            this.leaves.add(new Leaf(pkg, reader));
        }
        int lightsCount = reader.readIndex();
        this.lights = new ArrayList<ObjectReference>(lightsCount);
        for (int i = 0; i < lightsCount; ++i) {
            reader.ensureRemaining(2);
            this.lights.add(new ObjectReference(pkg, reader.readIndex()));
        }
        reader.ensureRemaining(8);
        this.rootOutside = reader.readInt();
        this.linked = reader.readInt();
    }

    @Override
    public String toString() {
        return String.format("Model [boundingBox=%s, boundingSphere=%s, vectors=%s, points=%s, nodes=%s, surfaces=%s, export=%s, properties=%s]", this.boundingBox, this.boundingSphere, this.vectors, this.points, this.nodes, this.surfaces, this.export, this.properties);
    }
}

