/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.objects;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.Export;
import net.shrimpworks.unreal.packages.entities.Named;
import net.shrimpworks.unreal.packages.entities.objects.Model;
import net.shrimpworks.unreal.packages.entities.objects.Object;
import net.shrimpworks.unreal.packages.entities.objects.ObjectHeader;
import net.shrimpworks.unreal.packages.entities.objects.Palette;
import net.shrimpworks.unreal.packages.entities.objects.Polys;
import net.shrimpworks.unreal.packages.entities.objects.Sound;
import net.shrimpworks.unreal.packages.entities.objects.Texture;
import net.shrimpworks.unreal.packages.entities.objects.Texture2D;
import net.shrimpworks.unreal.packages.entities.properties.Property;

public enum ObjectFactory {
    Texture(Texture.class),
    Texture2D(Texture2D.class),
    Sound(Sound.class),
    Palette(Palette.class),
    Model(Model.class),
    Polys(Polys.class);

    private final Class<? extends Object> clazz;

    private ObjectFactory(Class<? extends Object> clazz) {
        this.clazz = clazz;
    }

    public static Object newInstance(Package pkg, PackageReader reader, Export export, ObjectHeader header, Collection<Property> properties, int dataStart) {
        Named type = export.classIndex.get();
        try {
            ObjectFactory objectFactory = ObjectFactory.valueOf(type.name().name);
            Constructor<? extends Object> constructor = objectFactory.clazz.getConstructor(Package.class, PackageReader.class, Export.class, ObjectHeader.class, Collection.class, Integer.TYPE);
            return constructor.newInstance(pkg, reader, export, header, properties, dataStart);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return new Object(pkg, reader, export, header, properties, dataStart);
        }
    }
}

