/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.objects;

import java.util.Arrays;
import java.util.Collection;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.Export;
import net.shrimpworks.unreal.packages.entities.objects.Object;
import net.shrimpworks.unreal.packages.entities.objects.ObjectHeader;
import net.shrimpworks.unreal.packages.entities.properties.Property;

public class Sound
extends Object {
    public Sound(Package pkg, PackageReader reader, Export export, ObjectHeader header, Collection<Property> properties, int dataStart) {
        super(pkg, reader, export, header, properties, dataStart);
    }

    public SoundData readSound() {
        this.reader.moveTo(this.dataStart);
        String format = this.pkg.names[this.reader.readIndex()].name;
        int size = this.reader.readIndex();
        byte[] data = new byte[size];
        for (int pos = 0; pos < size; pos += this.reader.readBytes(data, pos, size - pos)) {
            this.reader.fillBuffer();
        }
        return new SoundData(this.export.name.name, format, data);
    }

    public static class SoundData {
        public final String name;
        public final String format;
        public final byte[] data;

        public SoundData(String name, String format, byte[] data) {
            this.name = name;
            this.format = format;
            this.data = data;
        }

        public String toString() {
            return String.format("SoundData [name=%s, format=%s, data=%s]", this.name, this.format, Arrays.toString(this.data));
        }
    }
}

