/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.objects;

import java.util.Collection;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.Export;
import net.shrimpworks.unreal.packages.entities.objects.ObjectHeader;
import net.shrimpworks.unreal.packages.entities.objects.TextureBase;
import net.shrimpworks.unreal.packages.entities.properties.Property;

public class Texture
extends TextureBase<MipMap> {
    public Texture(Package pkg, PackageReader reader, Export export, ObjectHeader header, Collection<Property> properties, int dataStart) {
        super(pkg, reader, export, header, properties, dataStart);
    }

    public MipMap[] mipMaps() {
        this.reader.moveTo(this.dataStart);
        int mipCount = this.pkg.version >= 178 ? this.reader.readInt() : (int)this.reader.readByte();
        MipMap[] mips = new MipMap[mipCount];
        for (int i = 0; i < mipCount; ++i) {
            int widthOffset = 0;
            if (this.pkg.version >= 63) {
                widthOffset = this.reader.readInt();
            }
            int size = this.reader.readIndex();
            if (this.pkg.version < 63) {
                widthOffset = this.reader.currentPosition() + size;
            }
            this.reader.moveRelative(size);
            int width = this.reader.readInt();
            int height = this.reader.readInt();
            byte bitWidth = this.reader.readByte();
            byte bitHeight = this.reader.readByte();
            mips[i] = new MipMap(this, widthOffset, size, width, height, bitWidth, bitHeight);
        }
        return mips;
    }

    @Override
    protected byte[] readImage(MipMap mip) {
        if (mip == null) {
            throw new IllegalArgumentException("MipMap must be non-null must be provided");
        }
        if (mip.size <= 0) {
            throw new IllegalArgumentException("MipMap size must be greater than zero");
        }
        if (mip.widthOffset <= 0) {
            throw new IllegalArgumentException("MipMap offset must be greater than zero");
        }
        if (mip.width <= 0 || mip.height <= 0) {
            throw new IllegalArgumentException("MipMap must have a width and height");
        }
        this.reader.moveTo(mip.widthOffset - mip.size);
        byte[] data = new byte[mip.size];
        for (int pos = 0; pos < mip.size; pos += this.reader.readBytes(data, pos, mip.size - pos)) {
            this.reader.fillBuffer();
        }
        return data;
    }

    public class MipMap
    extends TextureBase.MipMapBase {
        public final int widthOffset;
        public final int size;
        private final byte bitsWidth;
        private final byte bitsHeight;

        private MipMap(Texture this$0, int widthOffset, int size, int width, int height, byte bitsWidth, byte bitsHeight) {
            super(this$0, width, height);
            this.widthOffset = widthOffset;
            this.size = size;
            this.bitsWidth = bitsWidth;
            this.bitsHeight = bitsHeight;
        }

        public String toString() {
            return String.format("MipMap [size=%s, width=%s, height=%s, bitsWidth=%s, bitsHeight=%s]", this.size, this.width, this.height, this.bitsWidth, this.bitsHeight);
        }
    }
}

