/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.compression.ChunkChannel;
import net.shrimpworks.unreal.packages.compression.CompressedChunk;
import net.shrimpworks.unreal.packages.compression.CompressionFormat;
import net.shrimpworks.unreal.packages.entities.Export;
import net.shrimpworks.unreal.packages.entities.objects.ObjectHeader;
import net.shrimpworks.unreal.packages.entities.objects.TextureBase;
import net.shrimpworks.unreal.packages.entities.properties.Property;

public class Texture2D
extends TextureBase<MipMap> {
    public Texture2D(Package pkg, PackageReader reader, Export export, ObjectHeader header, Collection<Property> properties, int dataStart) {
        super(pkg, reader, export, header, properties, dataStart);
    }

    public MipMap[] mipMaps() {
        this.reader.moveTo(this.dataStart);
        this.reader.moveRelative(12);
        int absOffset = this.reader.readInt();
        int mipCount = this.reader.readInt();
        MipMap[] mips = new MipMap[mipCount];
        for (int i = 0; i < mipCount; ++i) {
            int bulkDataFlags = this.reader.readInt();
            int fullDataSize = this.reader.readInt();
            int savedBulkDataSizeOnDisk = this.reader.readInt();
            int savedBulkDataOffsetInFile = this.reader.readInt();
            this.reader.moveTo(savedBulkDataOffsetInFile + savedBulkDataSizeOnDisk);
            int width = this.reader.readInt();
            int height = this.reader.readInt();
            mips[i] = new MipMap(this, BulkDataFlags.fromFlags(bulkDataFlags), savedBulkDataOffsetInFile, savedBulkDataSizeOnDisk, fullDataSize, width, height);
        }
        return mips;
    }

    @Override
    protected byte[] readImage(MipMap mip) {
        boolean lzo = mip.bulkDataFlags.contains((Object)BulkDataFlags.CompressedLzo);
        if (lzo) {
            CompressedChunk chunk = new CompressedChunk(CompressionFormat.LZO, 0, mip.dataSize, mip.offset, mip.size);
            ChunkChannel chunkChannel = this.reader.loadChunk(chunk);
            byte[] data = new byte[mip.dataSize];
            ByteBuffer buf = ByteBuffer.allocate(mip.dataSize);
            try {
                chunkChannel.read(buf);
                buf.flip();
                buf.get(data);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read compressed image data", e);
            }
            return data;
        }
        byte[] data = new byte[mip.size];
        this.reader.moveTo(mip.offset);
        for (int pos = 0; pos < mip.size; pos += this.reader.readBytes(data, pos, mip.size - pos)) {
            this.reader.fillBuffer();
        }
        return data;
    }

    public class MipMap
    extends TextureBase.MipMapBase {
        public final Set<BulkDataFlags> bulkDataFlags;
        public final int offset;
        public final int size;
        public final int dataSize;

        private MipMap(Texture2D this$0, Set<BulkDataFlags> bulkDataFlags, int offset, int size, int dataSize, int width, int height) {
            super(this$0, width, height);
            this.bulkDataFlags = bulkDataFlags;
            this.offset = offset;
            this.size = size;
            this.dataSize = dataSize;
        }

        public String toString() {
            return String.format("Texture2D.MipMap [size=%s, dataSize=%s, width=%s, height=%s]", this.size, this.dataSize, this.width, this.height);
        }
    }

    public static enum BulkDataFlags {
        StoredInSeparateFile(1),
        StoredAsSeparateData(64),
        EmptyData(32),
        CompressedZlib(2),
        CompressedLzo(16),
        CompressedLzx(128);

        private final int flag;

        private BulkDataFlags(int flag) {
            this.flag = flag;
        }

        static Set<BulkDataFlags> fromFlags(long flags) {
            EnumSet<BulkDataFlags> dataFlags = EnumSet.noneOf(BulkDataFlags.class);
            dataFlags.addAll(Arrays.stream(BulkDataFlags.values()).filter(f -> (flags & (long)f.flag) == (long)f.flag).collect(Collectors.toSet()));
            return dataFlags;
        }
    }
}

