/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.objects;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.Export;
import net.shrimpworks.unreal.packages.entities.ExportedObject;
import net.shrimpworks.unreal.packages.entities.Named;
import net.shrimpworks.unreal.packages.entities.objects.Object;
import net.shrimpworks.unreal.packages.entities.objects.ObjectHeader;
import net.shrimpworks.unreal.packages.entities.objects.Palette;
import net.shrimpworks.unreal.packages.entities.objects.dxt.DXT1Decompressor;
import net.shrimpworks.unreal.packages.entities.objects.dxt.DXT3Decompressor;
import net.shrimpworks.unreal.packages.entities.objects.dxt.DXT5Decompressor;
import net.shrimpworks.unreal.packages.entities.properties.ByteProperty;
import net.shrimpworks.unreal.packages.entities.properties.EnumProperty;
import net.shrimpworks.unreal.packages.entities.properties.ObjectProperty;
import net.shrimpworks.unreal.packages.entities.properties.Property;

public abstract class TextureBase<T extends MipMapBase>
extends Object {
    public TextureBase(Package pkg, PackageReader reader, Export export, ObjectHeader header, Collection<Property> properties, int dataStart) {
        super(pkg, reader, export, header, properties, dataStart);
    }

    public Format format() {
        Property prop = this.property("Format");
        if (prop instanceof ByteProperty) {
            return Format.values()[((ByteProperty)prop).value];
        }
        if (prop instanceof EnumProperty) {
            return Format.forFormatName(((EnumProperty)prop).value.name);
        }
        return Format.PALETTE_8_BIT;
    }

    public Palette palette() {
        Object pallete;
        Named exp;
        Property prop = this.property("Palette");
        if (prop instanceof ObjectProperty && (exp = ((ObjectProperty)prop).value.get()) instanceof ExportedObject && (pallete = ((ExportedObject)exp).object()) instanceof Palette) {
            return (Palette)pallete;
        }
        return null;
    }

    protected abstract byte[] readImage(T var1);

    public static enum Format {
        PALETTE_8_BIT("PF_Unsupported"),
        RGBA7("PF_Unsupported"),
        RGB16("PF_Unsupported"),
        DXT1("PF_DXT1"),
        RBG8("PF_G8"),
        RGBA8("PF_R8G8B8A8"),
        UNKNOWN("PF_Unknown"),
        DXT3("PF_DXT3"),
        DXT5("PF_DXT5"),
        L8("PF_L8"),
        G16("PF_G16");

        private final String ue3Name;

        private Format(String ue3Name) {
            this.ue3Name = ue3Name;
        }

        public static Format forFormatName(String name) {
            for (Format value : Format.values()) {
                if (!value.ue3Name.equalsIgnoreCase(name)) continue;
                return value;
            }
            return UNKNOWN;
        }
    }

    protected abstract class MipMapBase {
        public final int width;
        public final int height;

        protected MipMapBase(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public BufferedImage get() {
            byte[] data = TextureBase.this.readImage(this);
            switch (TextureBase.this.format().ordinal()) {
                case 0: {
                    Palette palette = TextureBase.this.palette();
                    if (palette == null) {
                        throw new IllegalStateException("Could not find palette for texture");
                    }
                    BufferedImage p8Img = new BufferedImage(this.width, this.height, 13, palette.colorModel());
                    System.arraycopy(data, 0, ((DataBufferByte)p8Img.getRaster().getDataBuffer()).getData(), 0, data.length);
                    return p8Img;
                }
                case 10: {
                    short[] shortData = new short[data.length / 2];
                    ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shortData);
                    BufferedImage g16 = new BufferedImage(this.width, this.height, 11);
                    System.arraycopy(shortData, 0, ((DataBufferUShort)g16.getRaster().getDataBuffer()).getData(), 0, shortData.length);
                    return g16;
                }
                case 4: 
                case 5: {
                    BufferedImage rgbImg = new BufferedImage(this.width, this.height, 6);
                    for (int i = 0; i < data.length; i += 4) {
                        byte[] dest = ((DataBufferByte)rgbImg.getRaster().getDataBuffer()).getData();
                        dest[i + 0] = -1;
                        dest[i + 1] = data[i + 0];
                        dest[i + 2] = data[i + 1];
                        dest[i + 3] = data[i + 2];
                    }
                    return rgbImg;
                }
                case 3: {
                    return DXT1Decompressor.decompress(data, this.width, this.height);
                }
                case 7: {
                    return DXT3Decompressor.decompress(data, this.width, this.height);
                }
                case 8: {
                    return DXT5Decompressor.decompress(data, this.width, this.height);
                }
            }
            throw new UnsupportedOperationException("Reading texture " + TextureBase.this.export.name.name + " in format " + String.valueOf((java.lang.Object)TextureBase.this.format()) + " not supported");
        }
    }
}

