/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.objects.dxt;

class Color24 {
    private int r;
    private int g;
    private int b;

    public Color24() {
        this.b = 0;
        this.g = 0;
        this.r = 0;
    }

    public Color24(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public int getPixel888() {
        return this.r << 16 | this.g << 8 | this.b;
    }

    public static Color24 fromPixel565(int pixel) {
        Color24 color = new Color24();
        color.r = (int)((long)pixel & 0xF800L) >>> 8;
        color.g = (int)((long)pixel & 0x7E0L) >>> 3;
        color.b = (int)((long)pixel & 0x1FL) << 3;
        return color;
    }

    public static Color24 multiplyAlpha(Color24 color, int alpha) {
        Color24 result = new Color24();
        double alphaF = (double)alpha / 256.0;
        result.r = (int)((double)color.r * alphaF);
        result.g = (int)((double)color.g * alphaF);
        result.b = (int)((double)color.b * alphaF);
        return result;
    }

    public static Color24[] expandLookupTable(short minColor, short maxColor) {
        Color24 colorMin = Color24.fromPixel565(minColor);
        Color24 colorMax = Color24.fromPixel565(maxColor);
        Color24 color3 = new Color24();
        Color24 color4 = new Color24();
        color3.r = (2 * colorMin.r + colorMax.r + 1) / 3;
        color3.g = (2 * colorMin.g + colorMax.g + 1) / 3;
        color3.b = (2 * colorMin.b + colorMax.b + 1) / 3;
        color4.r = (colorMin.r + 2 * colorMax.r + 1) / 3;
        color4.g = (colorMin.g + 2 * colorMax.g + 1) / 3;
        color4.b = (colorMin.b + 2 * colorMax.b + 1) / 3;
        return new Color24[]{colorMin, colorMax, color3, color4};
    }
}

