/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.objects.dxt;

import java.awt.image.BufferedImage;
import net.shrimpworks.unreal.packages.entities.objects.dxt.Color24;
import net.shrimpworks.unreal.packages.entities.objects.dxt.DXTParams;

public class DXT3Decompressor {
    private static final int BLOCK_SIZE = 4;

    public static BufferedImage decompress(byte[] data, int width, int height) {
        DXTParams params = new DXTParams(data, width, height, 3, 4);
        for (int row = 0; row < params.numTilesHigh; ++row) {
            for (int col = 0; col < params.numTilesWide; ++col) {
                long alphaData = params.buffer.getLong();
                short minColor = params.buffer.getShort();
                short maxColor = params.buffer.getShort();
                int colorIndexMask = params.buffer.getInt();
                Color24[] lookupTable = Color24.expandLookupTable(minColor, maxColor);
                for (int k = 15; k >= 0; --k) {
                    int alpha = (int)(alphaData >>> k * 4) & 0xF;
                    int colorIndex = colorIndexMask >>> k * 2 & 3;
                    Color24 color = lookupTable[colorIndex];
                    int pixel8888 = (alpha <<= 4) << 24 | color.getPixel888();
                    int h = k / 4;
                    int w = k % 4;
                    int pixelIndex = h * width + (col * 4 + w);
                    params.pixels[pixelIndex] = pixel8888;
                }
            }
            params.image.setRGB(0, row * 4, width, 4, params.pixels, 0, width);
        }
        return params.image;
    }
}

