/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.objects.dxt;

import java.awt.image.BufferedImage;
import net.shrimpworks.unreal.packages.entities.objects.dxt.Color24;
import net.shrimpworks.unreal.packages.entities.objects.dxt.DXTParams;

public class DXT5Decompressor {
    private static final int BLOCK_SIZE = 4;

    public static BufferedImage decompress(byte[] data, int width, int height) {
        DXTParams params = new DXTParams(data, width, height, 3, 4);
        for (int row = 0; row < params.numTilesHigh; ++row) {
            for (int col = 0; col < params.numTilesWide; ++col) {
                short alpha0 = (short)(params.buffer.get() & 0xFF);
                short alpha1 = (short)(params.buffer.get() & 0xFF);
                byte[] alphaCodes = new byte[6];
                params.buffer.get(alphaCodes, 0, 6);
                short minColor = params.buffer.getShort();
                short maxColor = params.buffer.getShort();
                int colorIndexMask = params.buffer.getInt();
                Color24[] lookupTable = Color24.expandLookupTable(minColor, maxColor);
                byte[] alphaTable = new byte[]{(byte)(7 & alphaCodes[0]), (byte)(7 & alphaCodes[0] >>> 3), (byte)(7 & ((1 & alphaCodes[1]) << 2) + (alphaCodes[0] >>> 6)), (byte)(7 & alphaCodes[1] >>> 1), (byte)(7 & alphaCodes[1] >>> 4), (byte)(7 & ((3 & alphaCodes[2]) << 1) + (alphaCodes[1] >>> 7)), (byte)(7 & alphaCodes[2] >>> 2), (byte)(7 & alphaCodes[2] >>> 5), (byte)(7 & alphaCodes[3]), (byte)(7 & alphaCodes[3] >>> 3), (byte)(7 & ((1 & alphaCodes[4]) << 2) + (alphaCodes[3] >>> 6)), (byte)(7 & alphaCodes[4] >>> 1), (byte)(7 & alphaCodes[4] >>> 4), (byte)(7 & ((3 & alphaCodes[5]) << 1) + (alphaCodes[4] >>> 7)), (byte)(7 & alphaCodes[5] >>> 2), (byte)(7 & alphaCodes[5] >>> 5)};
                for (int k = 15; k >= 0; --k) {
                    byte alpha = DXT5Decompressor.a2Value(alphaTable[k], alpha0, alpha1);
                    int colorIndex = colorIndexMask >>> k * 2 & 3;
                    Color24 color = lookupTable[colorIndex];
                    int pixel8888 = alpha << 24 | color.getPixel888();
                    int h = k / 4;
                    int w = k % 4;
                    int pixelIndex = h * width + (col * 4 + w);
                    params.pixels[pixelIndex] = pixel8888;
                }
            }
            params.image.setRGB(0, row * 4, width, 4, params.pixels, 0, width);
        }
        return params.image;
    }

    private static byte a2Value(byte code, short a0, short a1) {
        if (a0 > a1) {
            return switch (code) {
                case 1 -> (byte)a1;
                case 2 -> (byte)((6 * a0 + 1 * a1) / 7);
                case 3 -> (byte)((5 * a0 + 2 * a1) / 7);
                case 4 -> (byte)((4 * a0 + 3 * a1) / 7);
                case 5 -> (byte)((3 * a0 + 4 * a1) / 7);
                case 6 -> (byte)((2 * a0 + 5 * a1) / 7);
                case 7 -> (byte)((1 * a0 + 6 * a1) / 7);
                default -> (byte)a0;
            };
        }
        return switch (code) {
            case 1 -> (byte)a1;
            case 2 -> (byte)((4 * a0 + 1 * a1) / 5);
            case 3 -> (byte)((3 * a0 + 2 * a1) / 5);
            case 4 -> (byte)((2 * a0 + 3 * a1) / 5);
            case 5 -> (byte)((1 * a0 + 4 * a1) / 5);
            case 6 -> 0;
            case 7 -> -1;
            default -> (byte)a0;
        };
    }
}

