/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.objects.geometry;

import java.util.ArrayList;
import java.util.List;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.Name;
import net.shrimpworks.unreal.packages.entities.ObjectReference;
import net.shrimpworks.unreal.packages.entities.objects.geometry.Vector;

public class Polygon {
    public final Vector base;
    public final Vector normal;
    public final Vector textureU;
    public final Vector textureV;
    public final List<Vector> vertices;
    public final int polyFlags;
    public final ObjectReference actor;
    public final ObjectReference texture;
    public final Name itemName;
    public final int link;
    public final int brushPoly;
    public final short panU;
    public final short panV;

    public Polygon(Package pkg, PackageReader reader) {
        int vertCount = reader.readIndex();
        reader.ensureRemaining(48);
        this.base = new Vector(reader);
        this.normal = new Vector(reader);
        this.textureU = new Vector(reader);
        this.textureV = new Vector(reader);
        this.vertices = new ArrayList<Vector>(vertCount);
        for (int i = 0; i < vertCount; ++i) {
            reader.ensureRemaining(12);
            this.vertices.add(new Vector(reader));
        }
        reader.ensureRemaining(20);
        this.polyFlags = reader.readInt();
        this.actor = new ObjectReference(pkg, reader.readIndex());
        this.texture = new ObjectReference(pkg, reader.readIndex());
        this.itemName = pkg.names[reader.readIndex()];
        this.link = reader.readIndex();
        this.brushPoly = reader.readIndex();
        this.panU = reader.readShort();
        this.panV = reader.readShort();
    }

    public String toString() {
        return String.format("[base=%s, normal=%s, textureU=%s, textureV=%s, vertices=%s, polyFlags=%s, actor=%s, texture=%s, itemName=%s, link=%s, brushPoly=%s, panU=%s, panV=%s]", this.base, this.normal, this.textureU, this.textureV, this.vertices, this.polyFlags, this.actor, this.texture, this.itemName, this.link, this.brushPoly, this.panU, this.panV);
    }
}

