/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.entities.Name;
import net.shrimpworks.unreal.packages.entities.properties.Property;

public class ArrayProperty
extends Property {
    public final List<Property> values;

    public ArrayProperty(Property initialValue) {
        this(initialValue.pkg, initialValue.name, List.of(initialValue));
    }

    public ArrayProperty(Package pkg, Name name, List<? extends Property> values) {
        super(pkg, name);
        this.values = Collections.unmodifiableList(values);
    }

    public ArrayProperty add(ArrayItem value) {
        ArrayList<Property> nextValues = new ArrayList<Property>(this.values);
        nextValues.add(Math.min(value.index, nextValues.size()), value.property);
        return new ArrayProperty(this.pkg, this.name, nextValues);
    }

    @Override
    public String toString() {
        return String.format("ArrayProperty [name=%s, values=%s]", this.name, this.values);
    }

    public static class ArrayItem
    extends Property {
        public final Property property;
        public final int index;

        public ArrayItem(Property property, int index) {
            super(property.pkg, property.name);
            this.property = property;
            this.index = index;
        }

        @Override
        public String toString() {
            return String.format("ArrayItem [index=%s, property=%s]", this.index, this.property);
        }
    }
}

