/*
 * Decompiled with CFR 0.152.
 */
package net.shrimpworks.unreal.packages.entities.properties;

import net.shrimpworks.unreal.packages.entities.Name;

public enum PropertyType {
    ByteProperty(1),
    IntProperty(2),
    BoolProperty(3),
    FloatProperty(4),
    ObjectProperty(5),
    NameProperty(6),
    StringProperty(7),
    ClassProperty(8),
    ArrayProperty(9),
    StructProperty(10),
    VectorProperty(11),
    RotatorProperty(12),
    StrProperty(13),
    MapProperty(14),
    FixedArrayProperty(15),
    EnumProperty(-1),
    InterfaceProperty(-1),
    ComponentProperty(-1);

    private final byte type;

    private PropertyType(byte type) {
        this.type = type;
    }

    public static PropertyType get(byte type) {
        for (PropertyType p : PropertyType.values()) {
            if (p.type != type) continue;
            return p;
        }
        return null;
    }

    public static PropertyType get(Name name) {
        for (PropertyType p : PropertyType.values()) {
            if (!p.name().equalsIgnoreCase(name.name)) continue;
            return p;
        }
        return null;
    }
}

