/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.unrealarchive.common.Util;

public class Author
implements Comparable<Author> {
    private transient String slug;
    public String name;
    public Set<String> aliases = new HashSet<String>();
    public Map<String, String> links = new HashMap<String, String>();
    public String iconImage;
    public String coverImage;
    public String profileImage;
    public String bgImage;
    public String about;
    public boolean showAliases = false;
    public boolean deleted = false;

    public Author() {
    }

    public Author(String name, String ... aliases) {
        this.name = name;
        this.aliases.addAll(Arrays.asList(aliases));
    }

    public Path pagePath(Path root) {
        return root.resolve("authors").resolve(this.slug());
    }

    public String toString() {
        return String.format("Author [slug=%s, name=%s, aliases=%s, links=%s, iconImage=%s, profileImage=%s, bgImage=%s, about=%s, deleted=%s]", this.slug(), this.name, this.aliases, this.links, this.iconImage, this.profileImage, this.bgImage, this.about, this.deleted);
    }

    public String slug() {
        if (this.slug == null) {
            this.slug = Util.authorSlug((String)this.name);
        }
        return this.slug;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Author)) {
            return false;
        }
        Author author = (Author)o;
        return Objects.equals(this.slug(), author.slug());
    }

    public int hashCode() {
        return Objects.hash(this.slug());
    }

    @Override
    public int compareTo(Author author) {
        return Util.normalised((String)this.name).compareTo(Util.normalised((String)author.name));
    }
}

