/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.Author;
import org.unrealarchive.content.AuthorRepository;
import org.unrealarchive.content.ContentEntity;
import org.unrealarchive.content.Contributors;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.content.managed.ManagedContentRepository;

public class Authors {
    private static final Map<String, Author> LOOKUP_CACHE = new ConcurrentHashMap<String, Author>();
    private static final Set<String> NON_AUTO_ALIASES = ConcurrentHashMap.newKeySet();
    private static AuthorRepository repository = null;
    private static final Pattern EMAIL = Pattern.compile("((e)?mail(to)?\\s?:)?(-? ?)?\\(?<?([A-Za-z0-9_.-]+@[A-Za-z0-9]+\\.[A-Za-z0-9.]+)>?\\)?", 2);
    private static final Pattern URL = Pattern.compile("(-? ?)?\\(?((https?://)?(www\\.)?[-a-zA-Z0-9@:%._+~#=]{2,256}\\.[a-zA-Z0-9()]{2,6}\\b([-a-zA-Z0-9()!@:%_+.~#?&/=]*))\\)?", 2);
    private static final Pattern DATE = Pattern.compile("\\d{1,4}[/-]\\d{1,2}[/-]\\d{1,4}");
    private static final Pattern BY = Pattern.compile("^((made|created|done).+)?\\s?(by\\s?:?\\s)", 66);
    private static final Pattern SOMETHING_BY = Pattern.compile("(\\s+([-*( ]+)?([A-Z0-9\\s]+)?conv(^\\s+)\\sby:?\\s+)", 66);
    private static final Pattern CONVERTED = Pattern.compile("(([-A-Za-z(]+?|, )conv[^\\s]+)(\\s)?(by:?\\s?)?", 66);
    private static final Pattern IMPORTED = Pattern.compile("\\s(\\*)?imported.*(\\*)?", 66);
    private static final Pattern MODIFIED = Pattern.compile("((port|mod)([^\\s]+)?)\\s(by:?\\s?)?", 66);
    private static final Pattern EDITED = Pattern.compile("((edit|fix)([^\\s]+)?)\\s(by:?\\s)?", 66);
    private static final Pattern ORIGINAL = Pattern.compile("(origina([^\\s]+)?)\\s(made\\s)?(by:?\\s)?", 66);
    private static final Pattern START_END = Pattern.compile("^[`'\"](.*)[`'\"]$");
    static final Pattern AKA = Pattern.compile("(.*)\\s+a\\.?k\\.?a\\.?:?\\s+?(.*)", 2);
    static final Pattern HANDLE = Pattern.compile("(.*)\\s+([`'(\"]([^`^'^)^\"]+)[`')\"])\\s+?(.*)", 2);
    static final Pattern HANDLE_AFTER = Pattern.compile("^(.*)\\s+([`'(\"]([^`^'^)^\"]+)[`')\"])$", 2);

    private Authors() {
    }

    public static void setRepository(AuthorRepository repo, Path authorsPath) {
        if (repo == null) {
            throw new IllegalArgumentException("Author repository cannot be null");
        }
        repository = repo;
        Path exclude = authorsPath.resolve("no-auto-alias.txt");
        if (Files.exists(exclude, new LinkOption[0])) {
            try {
                NON_AUTO_ALIASES.addAll(Files.readAllLines(exclude).stream().filter(name -> !name.isBlank() && !name.trim().startsWith("#")).map(Util::normalised).map(String::toLowerCase).collect(Collectors.toSet()));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load non-alias names from file " + String.valueOf(exclude), e);
            }
        }
    }

    public static Author byName(String name) {
        if (name == null || name.isBlank() || name.equalsIgnoreCase(AuthorRepository.UNKNOWN.name)) {
            return AuthorRepository.UNKNOWN;
        }
        if (name.equalsIgnoreCase(AuthorRepository.VARIOUS.name)) {
            return AuthorRepository.VARIOUS;
        }
        return LOOKUP_CACHE.computeIfAbsent(AuthorRepository.authorKey(name), n -> {
            Author maybe;
            if (repository != null && (maybe = repository.byName(name)) != null) {
                return maybe;
            }
            String cleanName = Authors.cleanName(name);
            return repository.byName(cleanName);
        });
    }

    public static Contributors contributors(String name) {
        if (name == null || name.isBlank() || name.equalsIgnoreCase(AuthorRepository.UNKNOWN.name)) {
            return null;
        }
        if (name.equalsIgnoreCase(AuthorRepository.VARIOUS.name)) {
            return null;
        }
        if (Authors.noAlias(name)) {
            return null;
        }
        Contributors contributors = new Contributors(name);
        if (contributors.modifiedBy.isEmpty() && contributors.contributors.isEmpty()) {
            return null;
        }
        return contributors;
    }

    public static boolean isSomeone(Author author) {
        return author != null && author != AuthorRepository.UNKNOWN && author != AuthorRepository.VARIOUS;
    }

    public static boolean isSomeone(String name) {
        return name != null && !name.isBlank() && !name.equalsIgnoreCase(AuthorRepository.UNKNOWN.name) && !name.equalsIgnoreCase(AuthorRepository.VARIOUS.name);
    }

    public static boolean noAlias(String name) {
        return NON_AUTO_ALIASES.contains(Util.normalised((String)name).toLowerCase());
    }

    public static void autoPopRepository(AuthorRepository authorRepo, SimpleAddonRepository content, GameTypeRepository gameTypes, ManagedContentRepository managed) {
        Stream.concat(Stream.concat(content.all(false).stream(), gameTypes.all().stream()), managed.all().stream()).map(ContentEntity::author).filter(Objects::nonNull).filter(Authors::isSomeone).distinct().sorted().sorted(Comparator.comparingInt(String::length).reversed()).flatMap(name -> Contributors.names(name).stream()).distinct().forEach(a -> Authors.addToRepository(a, authorRepo));
    }

    public static void addToRepository(String name, AuthorRepository repo) {
        Author putAuthor;
        if (name == null || name.isBlank()) {
            return;
        }
        if (name.equalsIgnoreCase(AuthorRepository.VARIOUS.slug())) {
            return;
        }
        if (Authors.byName(name) != null) {
            return;
        }
        String normalised = Util.normalised((String)name).replaceAll("\\s+?", " ").strip();
        if (MODIFIED.matcher(normalised).find()) {
            return;
        }
        if (EDITED.matcher(normalised).find()) {
            return;
        }
        if (ORIGINAL.matcher(normalised).find()) {
            return;
        }
        if (IMPORTED.matcher(normalised).find()) {
            return;
        }
        if (CONVERTED.matcher(normalised).find()) {
            return;
        }
        if (SOMETHING_BY.matcher(normalised).find()) {
            return;
        }
        if (normalised.contains(",") || normalised.contains("&") || normalised.contains(" + ") || normalised.toLowerCase().contains(" and ")) {
            return;
        }
        if (Authors.noAlias(normalised)) {
            return;
        }
        Matcher aka = AKA.matcher(name);
        Matcher handle = HANDLE.matcher(name);
        Matcher handleAfter = HANDLE_AFTER.matcher(name);
        if (aka.matches()) {
            String aliased = aka.group(1).strip();
            String realname = aka.group(2).strip();
            if (Authors.noAlias(aliased)) {
                return;
            }
            if (Authors.noAlias(realname)) {
                return;
            }
            if (Authors.byName(aliased) != null) {
                return;
            }
            Author maybeAuthor = Authors.byName(realname);
            if (maybeAuthor != null) {
                maybeAuthor.aliases.addAll(Set.of(aliased, realname, name.strip()));
                Author putAuthor2 = maybeAuthor;
            } else {
                Author putAuthor3 = new Author(Authors.cleanName(name), aliased, realname, name.strip());
            }
            return;
        }
        if (handle.matches()) {
            aliased = handle.group(3).strip();
            String realname = handle.group(1).strip() + " " + handle.group(4).strip();
            if (Authors.noAlias(aliased)) {
                return;
            }
            if (Authors.noAlias(realname)) {
                return;
            }
            if (Authors.byName(aliased) != null) {
                return;
            }
            Author maybeAuthor = Authors.byName(realname);
            if (maybeAuthor != null) {
                maybeAuthor.aliases.addAll(Set.of(aliased, realname, name.strip()));
                putAuthor = maybeAuthor;
            } else {
                putAuthor = new Author(Authors.cleanName(name), aliased, realname, name.strip());
            }
        } else if (handleAfter.matches()) {
            aliased = handleAfter.group(3).strip();
            String realname = handleAfter.group(1).strip();
            if (Authors.noAlias(aliased)) {
                return;
            }
            if (Authors.noAlias(realname)) {
                return;
            }
            if (Authors.byName(aliased) != null) {
                return;
            }
            Author maybeAuthor = Authors.byName(realname);
            if (maybeAuthor != null) {
                maybeAuthor.aliases.addAll(Set.of(aliased, realname, name.strip()));
                putAuthor = maybeAuthor;
            } else {
                putAuthor = new Author(Authors.cleanName(name), aliased, realname, name.strip());
            }
        } else {
            String cleanName = Authors.cleanName(name);
            if (cleanName.isBlank() || !cleanName.matches(".*[a-zA-Z].*")) {
                return;
            }
            putAuthor = new Author(cleanName, new String[0]);
            if (!cleanName.equalsIgnoreCase(name.strip())) {
                putAuthor.aliases.add(name.strip());
            }
        }
        try {
            repo.put(putAuthor, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to add author to repository: " + name, e);
        }
    }

    private static String cleanName(String author) {
        String noEditBy;
        String noMadeBy;
        String noModified;
        String noImport;
        String noConverted;
        String noUrl;
        String noEmail;
        String noDate;
        if (author.isBlank()) {
            return "Unknown";
        }
        String noFullstop = author.replaceAll("(\\.)$", "");
        String noQuote = noDate = DATE.matcher(noFullstop).replaceAll("");
        if (START_END.matcher(noDate).find()) {
            noQuote = START_END.matcher(noDate).replaceFirst("$1");
        }
        if ((noEmail = EMAIL.matcher(noQuote).replaceAll("")).isBlank() || noEmail.length() < 3) {
            noEmail = noQuote.indexOf(64) > 0 && noQuote.length() > 3 ? noQuote.substring(0, noQuote.indexOf(64)) : noQuote;
        }
        if ((noUrl = URL.matcher(noEmail).replaceAll("")).isBlank() || noUrl.length() < 3) {
            noUrl = noEmail;
        }
        if ((noConverted = CONVERTED.matcher(noUrl).replaceAll("")).isBlank()) {
            noConverted = noUrl;
        }
        if ((noImport = IMPORTED.matcher(noConverted).replaceAll("")).isBlank()) {
            noImport = noConverted;
        }
        if ((noModified = MODIFIED.matcher(noImport).replaceAll("")).isBlank()) {
            noModified = noImport;
        }
        if ((noMadeBy = BY.matcher(noModified).replaceAll("")).isBlank()) {
            noMadeBy = noModified;
        }
        if ((noEditBy = EDITED.matcher(noMadeBy).replaceAll("")).isBlank()) {
            noEditBy = noMadeBy;
        }
        return noEditBy.strip().replaceAll("[.,]+$", "").strip();
    }
}

