/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content;

import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import org.unrealarchive.content.AuthorInfo;
import org.unrealarchive.content.addons.HasAuthors;

public interface ContentEntity<T extends ContentEntity<T>>
extends Comparable<ContentEntity<?>>,
HasAuthors {
    public String id();

    public Path contentPath(Path var1);

    public Path slugPath(Path var1);

    public Path pagePath(Path var1);

    public String game();

    public String name();

    public String author();

    @Override
    public AuthorInfo authorInfo();

    public String releaseDate();

    public String autoDescription();

    public Set<String> autoTags();

    public LocalDateTime addedDate();

    public String contentType();

    public String friendlyType();

    public String leadImage();

    public Map<String, String> links();

    public Map<String, String> problemLinks();

    public boolean deleted();

    public boolean isVariation();

    @Override
    default public int compareTo(ContentEntity<?> o) {
        return this.name().compareToIgnoreCase(o.name());
    }
}

