/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content;

import java.beans.ConstructorProperties;
import java.util.Objects;

public class Download
implements Comparable<Download> {
    public String url;
    public boolean direct;
    public DownloadState state;

    @ConstructorProperties(value={"url", "direct", "state"})
    public Download(String url, boolean direct, DownloadState state) {
        this.url = url;
        this.direct = direct;
        this.state = state == null ? DownloadState.OK : state;
    }

    public Download(String url) {
        this.url = url;
        this.direct = false;
        this.state = DownloadState.OK;
    }

    @Override
    public int compareTo(Download o) {
        return this.direct ? -1 : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Download)) {
            return false;
        }
        Download that = (Download)o;
        return this.state == that.state && this.direct == that.direct && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.direct, this.state});
    }

    public String toString() {
        return String.format("Download [url=%s, direct=%s, state=%s]", new Object[]{this.url, this.direct, this.state});
    }

    public static enum DownloadState {
        OK,
        MISSING;

    }
}

