/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.addons;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.unrealarchive.common.Platform;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.AuthorInfo;
import org.unrealarchive.content.ContentEntity;
import org.unrealarchive.content.Download;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.NameDescription;
import org.unrealarchive.content.addons.Addon;

public class GameType
implements ContentEntity<GameType> {
    private static final String PATH_STRING = "%s/%s/%s/%s/";
    public String contentType = "GameType";
    public LocalDate addedDate;
    public String game = "Unknown";
    public String name;
    public String author = "Unknown";
    public String description = "None";
    public String titleImage = "title.png";
    public String bannerImage = "banner.png";
    public List<String> altNames = new ArrayList<String>();
    public Map<String, String> links = new HashMap<String, String>();
    public Map<String, String> problemLinks = new HashMap<String, String>();
    public Map<String, List<String>> credits = new HashMap<String, List<String>>();
    public List<NameDescription> gameTypes = new ArrayList<NameDescription>();
    public List<NameDescription> mutators = new ArrayList<NameDescription>();
    public List<GameTypeMap> maps = new ArrayList<GameTypeMap>();
    public List<Release> releases = new ArrayList<Release>();
    public boolean deleted = false;
    public transient boolean variation = false;
    private transient AuthorInfo authorInfo;

    @Override
    public String id() {
        return String.format("%s_%s", Util.slug((String)this.game), Util.slug((String)this.name));
    }

    @Override
    public Path contentPath(Path root) {
        String namePrefix = this.subGrouping();
        return root.resolve(String.format(PATH_STRING, this.game, "GameTypes", namePrefix, Util.slug((String)this.name)));
    }

    @Override
    public Path slugPath(Path root) {
        String game = Util.slug((String)this.game);
        String type = Util.slug((String)(this.contentType.toLowerCase().replaceAll("_", "") + "s"));
        String name = Util.slug((String)this.name);
        return root.resolve(game).resolve(type).resolve(this.subGrouping()).resolve(name);
    }

    @Override
    public Path pagePath(Path root) {
        return this.slugPath(root).resolve("index.html");
    }

    public String subGrouping() {
        int first = this.name.toUpperCase().replaceAll("[^A-Z0-9]", "").charAt(0);
        if (Character.isDigit((char)first)) {
            first = 48;
        }
        return Character.toString((char)first);
    }

    @Override
    public String game() {
        return this.game;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String author() {
        return this.author;
    }

    @Override
    public AuthorInfo authorInfo() {
        if (this.authorInfo == null) {
            this.authorInfo = new AuthorInfo(this.author);
        }
        return this.authorInfo;
    }

    @Override
    public String releaseDate() {
        return this.releases.stream().map(r -> r.releaseDate).sorted().findFirst().orElse("Unknown");
    }

    @Override
    public String autoDescription() {
        return this.description;
    }

    @Override
    public Set<String> autoTags() {
        HashSet<String> tags = new HashSet<String>();
        tags.add(this.contentType.toLowerCase().replaceAll("_", " "));
        tags.addAll(Games.byName((String)this.game).tags);
        tags.addAll(this.altNames);
        tags.addAll(this.gameTypes.stream().map(n -> n.name).toList());
        return tags;
    }

    @Override
    public LocalDateTime addedDate() {
        return this.addedDate.atStartOfDay();
    }

    @Override
    public String contentType() {
        return "GameType";
    }

    @Override
    public String friendlyType() {
        return "Game Type";
    }

    @Override
    public String leadImage() {
        String maybe;
        String string = maybe = this.titleImage == null || this.titleImage.isBlank() ? this.bannerImage : this.titleImage;
        if (maybe == null || maybe.isBlank()) {
            return "";
        }
        return this.slugPath(Paths.get("", new String[0])).resolve(maybe).toString();
    }

    @Override
    public Map<String, String> links() {
        return this.links;
    }

    @Override
    public Map<String, String> problemLinks() {
        return this.problemLinks;
    }

    @Override
    public boolean deleted() {
        return this.deleted;
    }

    @Override
    @JsonIgnore
    public boolean isVariation() {
        return this.variation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GameType)) {
            return false;
        }
        GameType other = (GameType)o;
        return this.deleted == other.deleted && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.addedDate, other.addedDate) && Objects.equals(this.game, other.game) && Objects.equals(this.name, other.name) && Objects.equals(this.author, other.author) && Objects.equals(this.description, other.description) && Objects.equals(this.titleImage, other.titleImage) && Objects.equals(this.bannerImage, other.bannerImage) && Objects.equals(this.links, other.links) && Objects.equals(this.problemLinks, other.problemLinks) && Objects.equals(this.credits, other.credits) && Objects.equals(this.releases, other.releases);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.addedDate, this.game, this.name, this.author, this.description, this.titleImage, this.bannerImage, this.links, this.problemLinks, this.credits, this.releases, this.deleted);
    }

    public static class Release
    implements Comparable<Release> {
        public String title;
        public String version;
        public String releaseDate = "Unknown";
        public String description = "";
        public List<ReleaseFile> files = new ArrayList<ReleaseFile>();
        public boolean deleted = false;

        @Override
        public int compareTo(Release o) {
            return o.releaseDate.compareTo(this.releaseDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Release)) {
                return false;
            }
            Release other = (Release)o;
            return this.deleted == other.deleted && Objects.equals(this.title, other.title) && Objects.equals(this.version, other.version) && Objects.equals(this.releaseDate, other.releaseDate) && Objects.equals(this.description, other.description);
        }

        public int hashCode() {
            return Objects.hash(this.title, this.version, this.releaseDate, this.description, this.deleted);
        }

        public String toString() {
            return String.format("Release [title=%s, version=%s, releaseDate=%s, description=%s, files=%s, deleted=%s]", this.title, this.version, this.releaseDate, this.description, this.files, this.deleted);
        }
    }

    public static class GameTypeMap {
        public final String name;
        public final String title;
        public final String author;
        public final Addon.Attachment screenshot;

        @ConstructorProperties(value={"name", "title", "author", "screenshot"})
        public GameTypeMap(String name, String title, String author, Addon.Attachment screenshot) {
            this.name = name;
            this.title = title;
            this.author = author;
            this.screenshot = screenshot;
        }
    }

    public static class ReleaseFile {
        public String title;
        public String localFile;
        public Platform platform = Platform.ANY;
        public List<Download> downloads = new ArrayList<Download>();
        public String originalFilename;
        public String hash;
        public long fileSize = 0L;
        public boolean synced = false;
        public boolean deleted = false;
        public List<Addon.ContentFile> files = new ArrayList<Addon.ContentFile>();
        public int otherFiles;
        public Map<String, List<Addon.Dependency>> dependencies = new HashMap<String, List<Addon.Dependency>>();

        public Download directDownload() {
            return this.downloads.stream().filter(d -> d.direct).findAny().orElse(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReleaseFile)) {
                return false;
            }
            ReleaseFile other = (ReleaseFile)o;
            return this.fileSize == other.fileSize && this.synced == other.synced && this.deleted == other.deleted && this.otherFiles == other.otherFiles && Objects.equals(this.title, other.title) && Objects.equals(this.localFile, other.localFile) && Objects.equals(this.downloads, other.downloads) && Objects.equals(this.originalFilename, other.originalFilename) && Objects.equals(this.hash, other.hash) && this.platform == other.platform && Objects.equals(this.files, other.files) && Objects.equals(this.dependencies, other.dependencies);
        }

        public int hashCode() {
            return Objects.hash(this.title, this.localFile, this.downloads, this.originalFilename, this.hash, this.fileSize, this.platform, this.synced, this.deleted, this.files, this.otherFiles, this.dependencies);
        }

        public String toString() {
            return String.format("ReleaseFile [title=%s, localFile=%s, platform=%s, downloads=%s, originalFilename=%s, hash=%s, fileSize=%s, synced=%s, deleted=%s, files=%s, otherFiles=%s, dependencies=%s]", this.title, this.localFile, this.platform, this.downloads, this.originalFilename, this.hash, this.fileSize, this.synced, this.deleted, this.files, this.otherFiles, this.dependencies);
        }
    }
}

