/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.addons;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unrealarchive.common.Util;
import org.unrealarchive.common.YAML;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.GameType;

public interface GameTypeRepository {
    public int size();

    public Set<GameType> all();

    public Set<GameType> variations(GameType var1);

    public void create(Games var1, String var2, Consumer<GameType> var3);

    public void put(GameType var1) throws IOException;

    public ReadableByteChannel document(GameType var1) throws IOException;

    public void writeContent(GameType var1, Path var2) throws IOException;

    public GameType findGametype(Games var1, String var2);

    public static class FileRepository
    implements GameTypeRepository {
        private static final String DOCUMENT_FILE = "gametype.md";
        private static final String DOCUMENT_TEMPLATE_FILE = "gametype-template.md";
        private final Path path;
        private final Set<GameTypeHolder> gameTypes;
        private final Map<String, Collection<GameType>> contentFileMap;

        public FileRepository(Path path) throws IOException {
            this.path = path;
            this.gameTypes = ConcurrentHashMap.newKeySet();
            this.contentFileMap = new ConcurrentHashMap<String, Collection<GameType>>();
            this.scanPath(path, null);
        }

        private void scanPath(Path root, GameTypeHolder parent) throws IOException {
            try (Stream files = (Stream)Files.find(root, 3, (file, attr) -> file.toString().endsWith(".yml"), new FileVisitOption[0]).parallel();){
                files.forEach(file -> {
                    try {
                        GameType g = (GameType)YAML.fromFile((Path)file, GameType.class);
                        g.variation = parent != null;
                        GameTypeHolder holder = new GameTypeHolder((Path)file, g, parent);
                        this.gameTypes.add(holder);
                        g.releases.stream().flatMap(r -> r.files.stream()).flatMap(f -> f.files.stream()).forEach(f -> {
                            Collection fileSet = this.contentFileMap.computeIfAbsent(f.hash, h -> ConcurrentHashMap.newKeySet());
                            fileSet.add(g);
                        });
                        Path variations = file.resolveSibling("variations");
                        if (Files.isDirectory(variations, new LinkOption[0])) {
                            this.scanPath(variations, holder);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }

        @Override
        public int size() {
            return this.gameTypes.size();
        }

        @Override
        public Set<GameType> all() {
            return this.gameTypes.stream().filter(g -> !g.gametype.deleted()).map(g -> g.gametype).collect(Collectors.toSet());
        }

        @Override
        public Set<GameType> variations(GameType gameType) {
            return this.gameTypes.stream().filter(g -> !g.gametype.deleted()).filter(g -> g.variationOf != null && g.variationOf.gametype.equals(gameType)).map(g -> g.gametype).collect(Collectors.toSet());
        }

        @Override
        public void create(Games game, String gameType, Consumer<GameType> completed) {
            block10: {
                if (this.findGametype(game, gameType) != null) {
                    throw new IllegalStateException("Gametype already exists!");
                }
                try {
                    System.err.println("Initialising gametype in directory:");
                    System.err.printf("  - %s%n", this.gameTypePath(game, gameType).toAbsolutePath());
                    System.err.println("\nPopulate the appropriate files, add images, etc.");
                    System.err.println("To upload gametype files, execute the `sync` command.");
                    String neatName = Util.capitalWords((String)gameType);
                    GameType gt = new GameType();
                    gt.addedDate = LocalDate.now();
                    gt.game = game.name;
                    gt.name = neatName;
                    gt.author = neatName + " Team";
                    gt.description = "Short description about " + neatName;
                    gt.titleImage = "title.png";
                    gt.links.put("Homepage", "https://" + Util.slug((String)gameType) + ".com");
                    gt.credits.putAll(Map.of("Programming", List.of("Joe 'Programmer' Soap"), "Maps", List.of("MapGuy")));
                    GameType.Release release = new GameType.Release();
                    release.title = neatName + " Release";
                    release.version = "1.0";
                    GameType.ReleaseFile file = new GameType.ReleaseFile();
                    file.title = "Release Package";
                    file.localFile = "/path/to/release.zip";
                    release.files.add(file);
                    gt.releases.add(release);
                    completed.accept(gt);
                    this.put(gt);
                    Path docPath = Files.createDirectories(this.gameTypePath(game, gameType), new FileAttribute[0]);
                    Path md = Util.safeFileName((Path)docPath.resolve(DOCUMENT_FILE));
                    if (Files.exists(md, new LinkOption[0])) break block10;
                    try (InputStream is = this.getClass().getResourceAsStream(DOCUMENT_TEMPLATE_FILE);){
                        assert (is != null);
                        Files.copy(is, md, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Gametype creation failed", e);
                }
            }
        }

        @Override
        public void put(GameType gameType) throws IOException {
            GameTypeHolder parent;
            Path path = this.gameTypePath(Games.byName(gameType.game), gameType.name);
            if (gameType.isVariation() && (parent = (GameTypeHolder)this.gameTypes.stream().filter(g -> !g.gametype.deleted()).filter(g -> g.gametype.game().equals(gameType.game()) && g.gametype.name().equalsIgnoreCase(gameType.name())).findFirst().map(g -> g.variationOf).orElse(null)) != null) {
                path = parent.path.getParent().resolve("variations").resolve(Util.slug((String)gameType.name));
            }
            path = Files.createDirectories(path, new FileAttribute[0]);
            Path yml = Util.safeFileName((Path)path.resolve("gametype.yml"));
            Files.writeString(yml, (CharSequence)YAML.toString((Object)gameType), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.gameTypes.removeIf(gh -> gh.gametype.game.equalsIgnoreCase(gameType.game) && gh.gametype.name.equalsIgnoreCase(gameType.name));
            this.gameTypes.add(new GameTypeHolder(yml, gameType));
        }

        @Override
        public ReadableByteChannel document(GameType gameType) throws IOException {
            GameTypeHolder holder = this.getGameType(gameType);
            if (holder == null) {
                return null;
            }
            Path docPath = holder.path.resolveSibling(DOCUMENT_FILE);
            if (!Files.exists(docPath, new LinkOption[0])) {
                return null;
            }
            return Files.newByteChannel(docPath, StandardOpenOption.READ);
        }

        @Override
        public void writeContent(GameType gameType, Path outPath) throws IOException {
            Path sourcePath = this.path(gameType);
            if (sourcePath == null) {
                return;
            }
            Util.copyTree((Path)sourcePath.getParent(), (Path)outPath);
        }

        @Override
        public GameType findGametype(Games game, String gameType) {
            return this.gameTypes.stream().filter(g -> !g.gametype.deleted()).filter(g -> g.gametype.game().equals(game.name)).filter(g -> {
                if (g.gametype.name().equalsIgnoreCase(gameType)) {
                    return true;
                }
                if (g.gametype.altNames == null || g.gametype.altNames.isEmpty()) {
                    return false;
                }
                return g.gametype.altNames.contains(gameType);
            }).findFirst().map(h -> h.gametype).orElse(null);
        }

        private GameTypeHolder getGameType(GameType gameType) {
            return this.gameTypes.stream().filter(g -> gameType.equals(g.gametype)).findFirst().orElseThrow(() -> new IllegalArgumentException("GameType was not found: " + gameType.name()));
        }

        private Path gameTypePath(Games game, String gameType) {
            return this.path.resolve(game.name).resolve(Util.slug((String)gameType));
        }

        private Path path(GameType gameType) {
            return this.gameTypes.stream().filter(g -> gameType.equals(g.gametype)).findFirst().map(h -> h.path).orElse(null);
        }

        private static class GameTypeHolder {
            private final Path path;
            private final GameType gametype;
            private final GameTypeHolder variationOf;

            public GameTypeHolder(Path path, GameType gametype) {
                this(path, gametype, null);
            }

            public GameTypeHolder(Path path, GameType gametype, GameTypeHolder variationOf) {
                this.path = path;
                this.gametype = gametype;
                this.variationOf = variationOf;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                GameTypeHolder that = (GameTypeHolder)o;
                return Objects.equals(this.gametype, that.gametype);
            }

            public int hashCode() {
                return Objects.hash(this.gametype);
            }
        }
    }
}

