/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.addons;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.MapGameTypes;

public class Map
extends Addon {
    private static final String PATH_STRING = "%s/%s/%s/%s/%s/";
    public String gametype = "Unknown";
    public String title = "Unknown";
    public String playerCount = "Unknown";
    public java.util.Map<String, Double> themes = new HashMap<String, Double>();
    public boolean bots = false;

    @Override
    public String subGrouping() {
        MapGameTypes.MapGameType gt = MapGameTypes.byName(this.gametype);
        if (gt != null) {
            String s = this.name.toLowerCase().trim();
            for (String prefix : gt.mapPrefixes()) {
                if (!s.startsWith(prefix.toLowerCase())) continue;
                int first = s.substring(prefix.length()).trim().toUpperCase().replaceAll("[^A-Z0-9]", "").charAt(0);
                if (Character.isDigit((char)first)) {
                    first = 48;
                }
                return Character.toString((char)first);
            }
        }
        return super.subGrouping();
    }

    @Override
    public Path contentPath(Path root) {
        String namePrefix = this.subGrouping();
        return root.resolve(String.format(PATH_STRING, this.game, "Maps", this.gametype, namePrefix, this.hashPath()));
    }

    @Override
    public Path slugPath(Path root) {
        String game = Util.slug((String)this.game);
        String type = Util.slug((String)(this.contentType.toLowerCase().replaceAll("_", "") + "s"));
        String gameType = Util.slug((String)this.gametype);
        String name = Util.slug((String)(this.name + "_" + this.hash.substring(0, 8)));
        return root.resolve(game).resolve(type).resolve(gameType).resolve(this.subGrouping()).resolve(name);
    }

    @Override
    public String autoDescription() {
        String playerString = this.playerCount.equalsIgnoreCase("unknown") ? "" : String.format(" %s player", this.playerCount);
        String authorString = this.authorName().equalsIgnoreCase("unknown") ? "" : String.format(", created by %s", this.authorName());
        return String.format("%s, a%s %s map for %s%s", this.title, playerString, this.gametype, Games.byName((String)this.game).bigName, authorString);
    }

    @Override
    public Set<String> autoTags() {
        HashSet<String> tags = new HashSet<String>(super.autoTags());
        tags.add(this.gametype.toLowerCase());
        if (this.name.contains("-")) {
            tags.add(this.name.split("-")[0].toLowerCase());
            tags.add(this.name.split("-")[1].toLowerCase());
        }
        tags.addAll(this.themes.keySet().stream().map(String::toLowerCase).toList());
        return tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map map = (Map)o;
        return Objects.equals(this.gametype, map.gametype) && Objects.equals(this.title, map.title) && Objects.equals(this.playerCount, map.playerCount) && Objects.equals(this.themes, map.themes) && Objects.equals(this.bots, map.bots);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.gametype, this.title, this.playerCount, this.themes, this.bots);
    }
}

