/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.addons;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.AuthorInfo;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.HasAuthors;

public class MapPack
extends Addon {
    private static final String PATH_STRING = "%s/%s/%s/%s/";
    public List<PackMap> maps = new ArrayList<PackMap>();
    public String gametype = "Mixed";
    public Map<String, Double> themes = new HashMap<String, Double>();

    @Override
    public Path contentPath(Path root) {
        String namePrefix = this.subGrouping();
        return root.resolve(String.format(PATH_STRING, this.game, "MapPacks", namePrefix, this.hashPath()));
    }

    @Override
    public Path slugPath(Path root) {
        String game = Util.slug((String)this.game);
        String type = Util.slug((String)(this.contentType.toLowerCase().replaceAll("_", "") + "s"));
        String gameType = Util.slug((String)this.gametype);
        String name = Util.slug((String)(this.name + "_" + this.hash.substring(0, 8)));
        return root.resolve(game).resolve(type).resolve(gameType).resolve(this.subGrouping()).resolve(name);
    }

    @Override
    public String autoDescription() {
        return String.format("%s, a %s map pack for %s containing %d maps, created by %s", this.name, this.gametype, Games.byName((String)this.game).bigName, this.maps.size(), this.authorName());
    }

    @Override
    public Set<String> autoTags() {
        HashSet<String> tags = new HashSet<String>(super.autoTags());
        tags.add(this.gametype.toLowerCase());
        tags.addAll(this.maps.stream().filter(m -> m.name.contains("-")).map(m -> m.name.split("-")[0].toLowerCase()).distinct().toList());
        tags.addAll(this.maps.stream().filter(m -> m.name.contains("-")).map(m -> m.name.split("-")[1].toLowerCase()).distinct().toList());
        tags.addAll(this.themes.keySet().stream().map(String::toLowerCase).toList());
        return tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapPack mapPack = (MapPack)o;
        return Objects.equals(this.maps, mapPack.maps) && Objects.equals(this.gametype, mapPack.gametype) && Objects.equals(this.themes, mapPack.themes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maps, this.gametype, this.themes);
    }

    public static class PackMap
    implements Comparable<PackMap>,
    HasAuthors {
        public String name;
        public String title;
        public String author = "Unknown";
        private transient AuthorInfo authorInfo;

        public PackMap() {
        }

        public PackMap(String name, String title, String author) {
            this.name = name;
            this.title = title;
            this.author = author;
        }

        @Override
        public AuthorInfo authorInfo() {
            if (this.authorInfo == null) {
                this.authorInfo = new AuthorInfo(this.author);
            }
            return this.authorInfo;
        }

        @Override
        public int compareTo(PackMap o) {
            return this.name.compareToIgnoreCase(o.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackMap packMap = (PackMap)o;
            return Objects.equals(this.name, packMap.name) && Objects.equals(this.title, packMap.title) && Objects.equals(this.author, packMap.author);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.title, this.author);
        }
    }
}

