/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.addons;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unrealarchive.common.Reflect;
import org.unrealarchive.common.Util;
import org.unrealarchive.common.YAML;
import org.unrealarchive.content.addons.Addon;

public interface SimpleAddonRepository {
    public void syncWith(SimpleAddonRepository var1) throws IOException;

    public Path path();

    public int size();

    public long fileSize();

    default public Map<Class<? extends Addon>, Long> countByType() {
        return this.countByType(null);
    }

    default public Map<Class<? extends Addon>, Long> countByType(String game) {
        return this.all(false).stream().filter((? super T c) -> game == null || c.game.equals(game)).collect(Collectors.groupingBy(Object::getClass, Collectors.counting()));
    }

    default public Map<String, Long> countByGame() {
        return this.all(false).stream().collect(Collectors.groupingBy(c -> c.game, Collectors.counting()));
    }

    public Collection<Addon> search(String var1, String var2, String var3, String var4);

    default public Collection<Addon> filter(String ... keysValues) {
        if (keysValues.length == 0) {
            return this.all(false);
        }
        if (keysValues.length % 2 != 0) {
            throw new IllegalArgumentException("Keys with values expected in filter argument " + String.join((CharSequence)",", keysValues));
        }
        HashMap<String, String> filters = new HashMap<String, String>(keysValues.length / 2);
        for (int i = 0; i < keysValues.length; ++i) {
            filters.put(keysValues[i].toLowerCase(), keysValues[++i]);
        }
        return this.all(false).stream().filter((? super T a) -> {
            Map fields = Reflect.classLowercaseFields((Object)a);
            boolean found = false;
            try {
                for (String f : filters.keySet()) {
                    Field field = (Field)fields.get(f);
                    if (field == null) {
                        return false;
                    }
                    Object val = field.get(a);
                    if (val == null) {
                        return false;
                    }
                    String strVal = val.toString();
                    if (strVal == null) {
                        return false;
                    }
                    String match = (String)filters.get(f);
                    if (match.contains("*")) {
                        if (strVal.matches(match.replace("*", ".*"))) {
                            found = true;
                            continue;
                        }
                        return false;
                    }
                    if (strVal.equalsIgnoreCase(match)) {
                        found = true;
                        continue;
                    }
                    return false;
                }
            }
            catch (ClassCastException | IllegalAccessException e) {
                return false;
            }
            return found;
        }).collect(Collectors.toSet());
    }

    public Collection<Addon> all();

    public Collection<Addon> all(boolean var1);

    public Collection<Addon> forName(String var1);

    public Addon forHash(String var1);

    public <T extends Addon> Collection<T> get(Class<T> var1);

    public <T extends Addon> Collection<T> get(Class<T> var1, boolean var2, boolean var3);

    public int containingFileCount(String var1);

    public Collection<Addon> containingFile(String var1);

    public Collection<Addon> variationsOf(String var1);

    public void put(Addon var1) throws IOException;

    public int gc();

    default public String summary() {
        StringBuilder result = new StringBuilder();
        Map<Class<? extends Addon>, Long> byType = this.countByType();
        if (!byType.isEmpty()) {
            result.append("Current content by Type:").append(System.lineSeparator());
            byType.forEach((type, count) -> result.append(String.format(" > %s: %d%n", type.getSimpleName(), count)));
            result.append("Current content by Game:").append(System.lineSeparator());
            this.countByGame().forEach((game, count) -> {
                result.append(String.format(" > %s: %d%n", game, count));
                this.countByType((String)game).forEach((type, typeCount) -> result.append(String.format("   > %s: %d%n", type.getSimpleName(), typeCount)));
            });
        } else {
            result.append("Content repository is empty!").append(System.lineSeparator());
        }
        return result.toString();
    }

    public static class FileRepository
    implements SimpleAddonRepository {
        private static final int CONTENT_INITIAL_SIZE = 60000;
        private static final int FILES_INITIAL_SIZE = 180000;
        private static final int VARIATION_INITIAL_SIZE = 6000;
        private final Path path;
        private final Map<String, ContentHolder> content;
        private final Map<String, Collection<ContentHolder>> contentFileMap;
        private final Map<String, Collection<ContentHolder>> variationsMap;

        public FileRepository(Path path) throws IOException {
            this.path = path;
            this.content = new ConcurrentHashMap<String, ContentHolder>(60000);
            this.contentFileMap = new ConcurrentHashMap<String, Collection<ContentHolder>>(180000);
            this.variationsMap = new ConcurrentHashMap<String, Collection<ContentHolder>>(6000);
            try (Stream<Path> files = Files.find(path, 20, (file, attr) -> file.toString().endsWith(".yml"), new FileVisitOption[0]);){
                ((Stream)files.parallel()).forEach(file -> {
                    try {
                        Addon c = (Addon)YAML.fromFile((Path)file, Addon.class);
                        ContentHolder holder = new ContentHolder((Path)file, c);
                        this.content.put(c.hash, holder);
                        for (Addon.ContentFile contentFile : c.files) {
                            Collection fileSet = this.contentFileMap.computeIfAbsent(contentFile.hash, h -> ConcurrentHashMap.newKeySet());
                            fileSet.add(holder);
                        }
                        if (c.variationOf != null) {
                            Collection variations = this.variationsMap.computeIfAbsent(c.variationOf, h -> ConcurrentHashMap.newKeySet());
                            variations.add(holder);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }

        @Override
        public void syncWith(SimpleAddonRepository other) {
            throw new UnsupportedOperationException("Sync with repository not supported");
        }

        @Override
        public Path path() {
            return this.path;
        }

        @Override
        public int size() {
            return this.content.size();
        }

        @Override
        public long fileSize() {
            return this.content.values().parallelStream().mapToLong(c -> c.fileSize).sum();
        }

        @Override
        public Collection<Addon> search(String game, String type, String name, String author) {
            return this.content.values().parallelStream().map(ContentHolder::content).filter(Objects::nonNull).filter((? super T c) -> {
                boolean match = game == null || c.game.equalsIgnoreCase(game);
                match = match && (type == null || c.contentType.equalsIgnoreCase(type));
                match = match && (author == null || c.author.equalsIgnoreCase(author));
                match = match && (name == null || c.name.equalsIgnoreCase(name));
                return match;
            }).collect(Collectors.toSet());
        }

        @Override
        public Collection<Addon> all() {
            return this.all(true);
        }

        @Override
        public Collection<Addon> all(boolean withVariations) {
            return this.content.values().parallelStream().filter((? super T c) -> !c.deleted).filter((? super T c) -> withVariations || !c.isVariation).map(ContentHolder::content).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        @Override
        public Collection<Addon> forName(String name) {
            return this.content.values().parallelStream().map(ContentHolder::content).filter(Objects::nonNull).filter((? super T c) -> c.name.equalsIgnoreCase(name)).collect(Collectors.toSet());
        }

        @Override
        public Addon forHash(String hash) {
            ContentHolder contentHolder;
            List<String> found;
            String key = hash;
            if (key.length() == 8 && (found = this.content.keySet().stream().filter((? super T h) -> h.startsWith(hash)).toList()).size() == 1) {
                key = found.getFirst();
            }
            if ((contentHolder = this.content.get(key)) != null) {
                return contentHolder.content();
            }
            return null;
        }

        @Override
        public <T extends Addon> Collection<T> get(Class<T> type) {
            return this.get(type, true, true);
        }

        @Override
        public <T extends Addon> Collection<T> get(Class<T> type, boolean withDeleted, boolean withVariations) {
            return this.content.values().parallelStream().filter((? super T c) -> type.isAssignableFrom(c.type)).filter((? super T c) -> withDeleted || !c.deleted).filter((? super T c) -> withVariations || !c.isVariation).map(ContentHolder::content).filter(Objects::nonNull).map(c -> c).collect(Collectors.toSet());
        }

        @Override
        public int containingFileCount(String hash) {
            return ((Collection)this.contentFileMap.getOrDefault(hash, Collections.emptySet())).size();
        }

        @Override
        public Collection<Addon> containingFile(String hash) {
            return ((Collection)this.contentFileMap.getOrDefault(hash, Collections.emptySet())).parallelStream().map(ContentHolder::content).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        @Override
        public Collection<Addon> variationsOf(String hash) {
            return ((Collection)this.variationsMap.getOrDefault(hash, Collections.emptySet())).parallelStream().map(ContentHolder::content).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        @Override
        public void put(Addon added) throws IOException {
            ContentHolder replaces = this.content.get(added.hash);
            Path outPath = added.contentPath(this.path);
            Files.createDirectories(outPath, new FileAttribute[0]);
            Path newYml = outPath.resolve(String.format("%s_[%s].yml", Util.slug((String)added.name), added.hash.substring(0, 8)));
            Files.writeString(Util.safeFileName((Path)newYml), (CharSequence)YAML.toString((Object)added), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            if (replaces != null && !replaces.path.equals(newYml)) {
                Files.deleteIfExists(replaces.path);
            }
            this.content.put(added.hash, new ContentHolder(newYml, added));
        }

        @Override
        public int gc() {
            AtomicInteger counter = new AtomicInteger(0);
            this.content.entrySet().removeIf(e -> {
                if (((ContentHolder)e.getValue()).deleted) {
                    try {
                        if (Files.deleteIfExists(((ContentHolder)e.getValue()).path)) {
                            counter.incrementAndGet();
                            return true;
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return false;
            });
            this.content.entrySet().removeIf(e -> {
                try {
                    ContentHolder parent;
                    if (((ContentHolder)e.getValue()).isVariation && ((parent = this.content.get(((ContentHolder)e.getValue()).content().variationOf)) == null || parent.content().deleted()) && Files.deleteIfExists(((ContentHolder)e.getValue()).path)) {
                        counter.incrementAndGet();
                        return true;
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                return false;
            });
            return counter.get();
        }

        private static class ContentHolder {
            private final Path path;
            private final boolean deleted;
            private final boolean isVariation;
            private final int fileSize;
            private final Class<?> type;
            private SoftReference<Addon> content;

            public ContentHolder(Path path, Addon content) {
                this.path = path;
                this.deleted = content.deleted();
                this.isVariation = content.isVariation();
                this.fileSize = content.fileSize;
                this.type = content.getClass();
                this.content = !this.deleted && !this.isVariation ? new SoftReference<Addon>(content) : null;
            }

            public Addon content() {
                Addon has;
                Addon addon = has = this.content == null ? null : this.content.get();
                if (has != null) {
                    return has;
                }
                try {
                    Addon newContent = (Addon)YAML.fromFile((Path)this.path, Addon.class);
                    this.content = new SoftReference<Addon>(newContent);
                    return newContent;
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    return null;
                }
            }
        }
    }
}

