/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.docs;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.unrealarchive.common.Util;
import org.unrealarchive.common.YAML;
import org.unrealarchive.content.docs.Document;

public interface DocumentRepository {
    public int size();

    public Collection<Document> all();

    public ReadableByteChannel document(Document var1) throws IOException;

    public void writeContent(Document var1, Path var2) throws IOException;

    public static class FileRepository
    implements DocumentRepository {
        private final Map<Document, DocumentHolder> documents = new ConcurrentHashMap<Document, DocumentHolder>();

        public FileRepository(Path path) throws IOException {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (Util.extension((Path)file).equalsIgnoreCase("yml")) {
                        Document c = (Document)YAML.fromFile((Path)file, Document.class);
                        documents.put(c, new DocumentHolder(file, c));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        @Override
        public int size() {
            return this.documents.size();
        }

        @Override
        public Collection<Document> all() {
            return Collections.unmodifiableCollection(this.documents.keySet());
        }

        @Override
        public ReadableByteChannel document(Document doc) throws IOException {
            DocumentHolder holder = this.documents.get(doc);
            if (holder == null) {
                return null;
            }
            Path docPath = holder.path.getParent().resolve(doc.name);
            if (!Files.exists(docPath, new LinkOption[0])) {
                return null;
            }
            return Files.newByteChannel(docPath, StandardOpenOption.READ);
        }

        @Override
        public void writeContent(Document doc, Path outPath) throws IOException {
            DocumentHolder holder = this.documents.get(doc);
            if (holder == null) {
                return;
            }
            Util.copyTree((Path)holder.path.getParent(), (Path)outPath);
        }

        private record DocumentHolder(Path path, Document document) {
        }
    }
}

