/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.managed;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.unrealarchive.common.Platform;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.AuthorInfo;
import org.unrealarchive.content.ContentEntity;
import org.unrealarchive.content.Download;
import org.unrealarchive.content.Games;

public class Managed
implements ContentEntity<Managed> {
    private static final DateTimeFormatter RELEASE_DATE_FMT = DateTimeFormatter.ofPattern("yyyy-MM");
    public LocalDate createdDate;
    public LocalDate updatedDate;
    public String game = "Unreal Tournament";
    public String group = "Patches & Updates";
    public String subGroup = "Patches";
    public String document = "readme.md";
    public String title;
    public String author = "Unknown";
    public String homepage = "";
    public String description = "No description";
    public LocalDate releaseDate;
    public String titleImage;
    public List<String> images = new ArrayList<String>();
    public List<ManagedFile> downloads = new ArrayList<ManagedFile>();
    public Map<String, String> links = new HashMap<String, String>();
    public Map<String, String> problemLinks = new HashMap<String, String>();
    public boolean published = true;
    private transient AuthorInfo authorInfo;

    public String fullPath() {
        return String.join((CharSequence)"/", this.game, this.group, this.subGroup);
    }

    @Override
    public String id() {
        return String.format("%s_%s_%s", Util.slug((String)this.game), Util.slug((String)this.group), Util.slug((String)this.title));
    }

    @Override
    public Path contentPath(Path root) {
        return this.slugPath(root.resolve("managed"));
    }

    @Override
    public Path slugPath(Path root) {
        String game = Util.slug((String)this.game);
        String group = Util.slug((String)this.group);
        String subGroup = Util.slug((String)this.subGroup);
        String name = Util.slug((String)this.title);
        return root.resolve(game).resolve(group).resolve(subGroup).resolve(name);
    }

    @Override
    public Path pagePath(Path root) {
        return this.slugPath(root).resolve("index.html");
    }

    @Override
    public String game() {
        return this.game;
    }

    @Override
    public String name() {
        return this.title;
    }

    @Override
    public String author() {
        return this.author;
    }

    @Override
    public AuthorInfo authorInfo() {
        if (this.authorInfo == null) {
            this.authorInfo = new AuthorInfo(this.author);
        }
        return this.authorInfo;
    }

    @Override
    public String releaseDate() {
        return this.releaseDate != null ? this.releaseDate.format(RELEASE_DATE_FMT) : this.createdDate.format(RELEASE_DATE_FMT);
    }

    @Override
    public String autoDescription() {
        return this.description;
    }

    @Override
    public Set<String> autoTags() {
        HashSet<String> tags = new HashSet<String>(Games.byName((String)this.game).tags);
        tags.add(this.group);
        tags.add(this.subGroup);
        return tags;
    }

    @Override
    public LocalDateTime addedDate() {
        return this.createdDate.atStartOfDay();
    }

    @Override
    public String contentType() {
        return Util.slug((String)this.group);
    }

    @Override
    public String friendlyType() {
        return this.group;
    }

    @Override
    public String leadImage() {
        return this.titleImage;
    }

    @Override
    public Map<String, String> links() {
        return this.links;
    }

    @Override
    public Map<String, String> problemLinks() {
        return this.problemLinks;
    }

    @Override
    public boolean deleted() {
        return !this.published;
    }

    @Override
    @JsonIgnore
    public boolean isVariation() {
        return false;
    }

    @Override
    public int compareTo(ContentEntity<?> o) {
        return this.releaseDate().compareToIgnoreCase(o.releaseDate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Managed)) {
            return false;
        }
        Managed managed = (Managed)o;
        return this.published == managed.published && Objects.equals(this.createdDate, managed.createdDate) && Objects.equals(this.updatedDate, managed.updatedDate) && Objects.equals(this.game, managed.game) && Objects.equals(this.document, managed.document) && Objects.equals(this.group, managed.group) && Objects.equals(this.subGroup, managed.subGroup) && Objects.equals(this.title, managed.title) && Objects.equals(this.author, managed.author) && Objects.equals(this.homepage, managed.homepage) && Objects.equals(this.description, managed.description) && Objects.equals(this.titleImage, managed.titleImage) && Objects.equals(this.links, managed.links) && Objects.equals(this.problemLinks, managed.problemLinks) && Objects.equals(this.images, managed.images);
    }

    public int hashCode() {
        return Objects.hash(this.createdDate, this.updatedDate, this.game, this.document, this.group, this.subGroup, this.title, this.author, this.homepage, this.description, this.titleImage, this.images, this.published, this.links, this.problemLinks);
    }

    public static class ManagedFile {
        public String title;
        public String version;
        public String description = "";
        public String localFile;
        public Platform platform = Platform.ANY;
        public List<Download> downloads = new ArrayList<Download>();
        public String originalFilename;
        public String hash;
        public long fileSize = 0L;
        public boolean synced = false;
        public boolean deleted = false;

        public Download directDownload() {
            return this.downloads.stream().filter(d -> d.direct).findAny().orElse(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ManagedFile)) {
                return false;
            }
            ManagedFile that = (ManagedFile)o;
            return this.fileSize == that.fileSize && this.synced == that.synced && this.deleted == that.deleted && Objects.equals(this.title, that.title) && Objects.equals(this.version, that.version) && Objects.equals(this.description, that.description) && Objects.equals(this.localFile, that.localFile) && Objects.equals(this.downloads, that.downloads) && this.platform == that.platform;
        }

        public int hashCode() {
            return Objects.hash(this.title, this.version, this.description, this.localFile, this.downloads, this.fileSize, this.platform, this.synced, this.deleted);
        }
    }
}

