/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content;

import java.util.Objects;
import org.unrealarchive.content.Author;
import org.unrealarchive.content.Authors;
import org.unrealarchive.content.Contributors;

public class AuthorInfo
implements Comparable<AuthorInfo> {
    private final String sourceName;
    private Author author;
    private Contributors contributors;
    private volatile boolean loaded = false;

    public AuthorInfo(String sourceName) {
        this.sourceName = sourceName;
    }

    public String authorName() {
        return this.author().name;
    }

    public synchronized Author author() {
        if (this.author != null) {
            return this.author;
        }
        Contributors contribs = this.contributors();
        if (contribs != null && contribs.originalAuthor != null) {
            this.author = contribs.originalAuthor;
        }
        if (this.author == null) {
            this.author = Authors.byName(this.sourceName);
        }
        if (this.author == null) {
            this.author = new Author(this.sourceName, new String[0]);
        }
        return this.author;
    }

    public synchronized Contributors contributors() {
        if (this.loaded) {
            return this.contributors;
        }
        this.contributors = Authors.contributors(this.sourceName);
        this.loaded = true;
        return this.contributors;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AuthorInfo)) {
            return false;
        }
        AuthorInfo that = (AuthorInfo)o;
        return Objects.equals(this.author(), that.author());
    }

    public int hashCode() {
        return this.author().hashCode();
    }

    @Override
    public int compareTo(AuthorInfo o) {
        return this.authorName().compareToIgnoreCase(o.authorName());
    }
}

