/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.unrealarchive.common.Util;
import org.unrealarchive.common.YAML;
import org.unrealarchive.content.Author;

public interface AuthorRepository {
    public static final Author UNKNOWN = new Author("Unknown", new String[0]);
    public static final Author VARIOUS = new Author("Various", new String[0]);

    public int size();

    public Collection<Author> all();

    public Author byName(String var1);

    public void put(Author var1, boolean var2) throws IOException;

    public void writeContent(Author var1, Path var2) throws IOException;

    default public String summary() {
        StringBuilder result = new StringBuilder();
        result.append("Authors Repository Totals: ").append(System.lineSeparator());
        result.append(" > Total: ").append(this.size()).append(System.lineSeparator());
        result.append(" > Current: ").append(this.all().size()).append(System.lineSeparator());
        result.append(" > Aliases: ").append(this.all().stream().mapToInt(a -> a.aliases.size()).sum()).append(System.lineSeparator());
        return result.toString();
    }

    public static String authorKey(String name) {
        return Util.normalised((String)name).toLowerCase().replaceAll("[\"`()\\[\\]<>{}=*-]", "'").strip();
    }

    public static class FileRepository
    implements AuthorRepository {
        private static final Set<String> DEFAULT_ICONS = Set.of("icon.png", "icon.jpg", "icon.jpeg", "icon.gif");
        private static final Set<String> DEFAULT_PROFILES = Set.of("profile.png", "profile.jpg", "profile.jpeg", "profile.gif");
        private static final Set<String> DEFAULT_COVERS = Set.of("cover.png", "cover.jpg", "cover.jpeg", "cover.gif");
        private static final Set<String> DEFAULT_BACKGROUNDS = Set.of("background.png", "background.jpg", "background.jpeg", "background.gif", "bg.png", "bg.jpg", "bg.jpeg", "bg.gif");
        private final Path path;
        private final Map<Author, AuthorHolder> authors = new ConcurrentHashMap<Author, AuthorHolder>();
        private final Map<String, AuthorHolder> authorsByKey = new ConcurrentHashMap<String, AuthorHolder>();

        public FileRepository(Path path) throws IOException {
            this.path = path;
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (Util.extension((Path)file).equalsIgnoreCase("yml")) {
                        Author author = (Author)YAML.fromFile((Path)file, Author.class);
                        AuthorHolder holder = new AuthorHolder(file, author, false);
                        authors.put(author, holder);
                        authorsByKey.put(AuthorRepository.authorKey(author.name), holder);
                        author.aliases.forEach(alias -> authorsByKey.put(AuthorRepository.authorKey(alias), holder));
                        if (author.iconImage == null || author.iconImage.isBlank()) {
                            author.iconImage = DEFAULT_ICONS.stream().filter(f -> Files.exists(file.getParent().resolve((String)f), new LinkOption[0])).findFirst().orElse(null);
                        }
                        if (author.profileImage == null || author.profileImage.isBlank()) {
                            author.profileImage = DEFAULT_PROFILES.stream().filter(f -> Files.exists(file.getParent().resolve((String)f), new LinkOption[0])).findFirst().orElse(null);
                        }
                        if (author.coverImage == null || author.coverImage.isBlank()) {
                            author.coverImage = DEFAULT_COVERS.stream().filter(f -> Files.exists(file.getParent().resolve((String)f), new LinkOption[0])).findFirst().orElse(null);
                        }
                        if (author.bgImage == null || author.bgImage.isBlank()) {
                            author.bgImage = DEFAULT_BACKGROUNDS.stream().filter(f -> Files.exists(file.getParent().resolve((String)f), new LinkOption[0])).findFirst().orElse(null);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        @Override
        public int size() {
            return this.authors.size();
        }

        @Override
        public Collection<Author> all() {
            return this.authors.keySet().stream().filter(author -> !author.deleted).toList();
        }

        @Override
        public void put(Author author, boolean ephemeral) throws IOException {
            AuthorHolder current = this.authors.get(author);
            Path yml = Util.safeFileName((Path)this.path.resolve(author.slug())).resolve("author.yml");
            if (!ephemeral) {
                if (!Files.isDirectory(yml.getParent(), new LinkOption[0])) {
                    Files.createDirectories(yml.getParent(), new FileAttribute[0]);
                }
                Files.writeString(yml, (CharSequence)YAML.toString((Object)author), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            AuthorHolder holder = new AuthorHolder(yml, author, ephemeral);
            this.authors.put(author, holder);
            this.authorsByKey.put(AuthorRepository.authorKey(author.name), holder);
            author.aliases.forEach(alias -> this.authorsByKey.put(AuthorRepository.authorKey(alias), holder));
            if (!ephemeral && current != null && !yml.equals(current.path)) {
                Files.delete(current.path);
            }
        }

        @Override
        public Author byName(String name) {
            if (name == null || name.isBlank() || name.equalsIgnoreCase(UNKNOWN.slug())) {
                return UNKNOWN;
            }
            if (name.equals(VARIOUS.slug())) {
                return VARIOUS;
            }
            AuthorHolder holder = this.authorsByKey.get(AuthorRepository.authorKey(name));
            if (holder != null) {
                return holder.author;
            }
            return null;
        }

        @Override
        public void writeContent(Author author, Path outPath) throws IOException {
            AuthorHolder holder = this.authors.get(author);
            if (holder == null || holder.path == null || !Files.exists(holder.path, new LinkOption[0])) {
                return;
            }
            Util.copyTree((Path)holder.path.getParent(), (Path)outPath);
        }

        @Override
        public String summary() {
            StringBuilder result = new StringBuilder();
            result.append(AuthorRepository.super.summary());
            result.append(" > Ephemeral Entries: ").append(this.authors.values().stream().filter(a -> a.ephemeral).count()).append(System.lineSeparator());
            result.append(" > Ephemeral aliases: ").append(this.authors.values().stream().filter(a -> a.ephemeral).mapToLong(a -> a.author.aliases.size()).sum()).append(System.lineSeparator());
            return result.toString();
        }

        private record AuthorHolder(Path path, Author author, boolean ephemeral) {
        }
    }
}

