/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unrealarchive.content.Author;
import org.unrealarchive.content.Authors;

public class Contributors {
    public final String authorString;
    public final Author originalAuthor;
    public final Set<Author> contributors = new HashSet<Author>();
    public final Set<Author> modifiedBy = new HashSet<Author>();
    private static final Pattern DATE = Pattern.compile("\\d{1,4}[/-]\\d{1,2}[/-]\\d{1,4}");
    private static final Pattern AUTHOR_SPLIT = Pattern.compile("((\\s+(and|&))\\s+|\\s+\\+\\s+|,\\s?|\\s?/\\s?)", 2);
    private static final Pattern MODIFIED_SPLIT = Pattern.compile("(,?\\s+|/)((-+|[^A-Za-z\\s])\\s+)?((\\S+\\s+)?(edit(ed)?|mod(ified|ifications|ded|s))|((\\S+\\s+)?((conv(er(sion|ted))?)|(version)|(remix(ed)?)))|(rema([kd])e)|(revamp(ed)?))[\\s->:]?\\s+(by:?\\s+)?", 2);
    private static final Pattern MODIFIED_MATCH_1 = Pattern.compile("(.+)\\s+\\(original\\),?\\s+(.+)\\(.+\\)", 2);
    private static final Pattern MODIFIED_MATCH_2 = Pattern.compile("(.+)(\\s+)?\\(origin(al(ly)?)?\\s+(by:?\\s+)?(.+)\\)", 2);
    private static final Pattern MODIFIED_MATCH_3 = Pattern.compile("(.+?),?\\s+?original(ly)?\\s+((.+\\s)?by:?\\s+)(.+)", 2);
    private static final Pattern MODIFIED_MATCH_7 = Pattern.compile("(.+?)(((\\s+[/-]+)\\s+)|(/))?\\*?((im)?port(ed)?).+?by:?\\s+?([^*]+)\\*?", 2);
    private static final Pattern MODIFIED_MATCH_4 = Pattern.compile("(.+)[(\\[*].+by:?\\s+(.+)[)\\]*]", 2);
    private static final Pattern MODIFIED_MATCH_5 = Pattern.compile("^(.+)\\s+made\\s+[^A-Z](.+)\\s(edited|modified)$", 2);
    private static final Pattern MODIFIED_MATCH_6 = Pattern.compile("([^,]+)(,?\\s+)(-+\\s+)?[(|\\[]?.+by:?\\s+([^)]+)[)|\\]]?", 2);

    public Contributors(String authorString) {
        this.authorString = authorString;
        String cleaned = DATE.matcher(authorString).replaceAll("");
        ModBy modBy = this.parseEditors(cleaned);
        if (modBy != null) {
            Set<Author> originals = this.parseAuthors(modBy.original());
            if (originals.size() > 1) {
                this.contributors.addAll(originals);
                this.originalAuthor = null;
            } else {
                this.originalAuthor = originals.stream().findFirst().orElse(null);
            }
            this.modifiedBy.addAll(this.parseAuthors(modBy.editor()));
        } else {
            this.originalAuthor = null;
            Set<Author> authors = this.parseAuthors(cleaned);
            if (authors.size() > 1) {
                this.contributors.addAll(authors);
            }
        }
    }

    public static Set<String> names(String authorString) {
        if (Authors.noAlias(authorString)) {
            return Set.of(authorString);
        }
        HashSet<String> names = new HashSet<String>();
        String[] s = MODIFIED_SPLIT.split(authorString);
        if (s.length > 1) {
            names.addAll(Stream.of(s).filter(n -> !n.isBlank()).collect(Collectors.toSet()));
        } else {
            Matcher m = MODIFIED_MATCH_1.matcher(authorString);
            if (m.find()) {
                names.add(m.group(1));
                names.add(m.group(2));
            } else {
                m = MODIFIED_MATCH_2.matcher(authorString);
                if (m.find()) {
                    names.add(m.group(6));
                    names.add(m.group(1));
                } else {
                    m = MODIFIED_MATCH_3.matcher(authorString);
                    if (m.find()) {
                        names.add(m.group(5));
                        names.add(m.group(1));
                    } else {
                        m = MODIFIED_MATCH_7.matcher(authorString);
                        if (m.find()) {
                            names.add(m.group(1));
                            names.add(m.group(9));
                        } else {
                            m = MODIFIED_MATCH_4.matcher(authorString);
                            if (m.find()) {
                                names.add(m.group(1));
                                names.add(m.group(2));
                            } else {
                                m = MODIFIED_MATCH_5.matcher(authorString);
                                if (m.find()) {
                                    names.add(m.group(1));
                                    names.add(m.group(2));
                                } else {
                                    m = MODIFIED_MATCH_6.matcher(authorString);
                                    if (m.find()) {
                                        names.add(m.group(1));
                                        names.add(m.group(4));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (names.isEmpty()) {
            names.add(authorString);
        }
        HashSet finalNames = new HashSet();
        names.forEach(a -> {
            String[] b = AUTHOR_SPLIT.split((CharSequence)a);
            if (b.length == 1) {
                finalNames.add(a);
            } else {
                finalNames.addAll(Stream.of(b).filter(n -> !n.isBlank()).collect(Collectors.toSet()));
            }
        });
        return finalNames.stream().map(String::strip).map(Contributors::cleanup).filter(n -> !n.isBlank()).collect(Collectors.toSet());
    }

    private Set<Author> parseAuthors(String a) {
        if (Authors.noAlias(a)) {
            return Set.of(this.author(a));
        }
        String[] s = AUTHOR_SPLIT.split(a);
        if (s.length == 1) {
            return Set.of(this.author(a));
        }
        HashSet<Author> authors = new HashSet<Author>();
        for (String string : s) {
            if (string.isBlank()) continue;
            authors.add(this.author(string));
        }
        return authors;
    }

    private ModBy parseEditors(String a) {
        String[] s = MODIFIED_SPLIT.split(a);
        if (s.length > 1) {
            return new ModBy(s[0], s[1]);
        }
        Matcher m = MODIFIED_MATCH_1.matcher(a);
        if (m.find()) {
            return new ModBy(m.group(1), m.group(2));
        }
        Matcher m2 = MODIFIED_MATCH_2.matcher(a);
        if (m2.find()) {
            return new ModBy(m2.group(6), m2.group(1));
        }
        Matcher m3 = MODIFIED_MATCH_3.matcher(a);
        if (m3.find()) {
            return new ModBy(m3.group(5), m3.group(1));
        }
        Matcher m7 = MODIFIED_MATCH_7.matcher(a);
        if (m7.find()) {
            return new ModBy(m7.group(1), m7.group(9));
        }
        Matcher m4 = MODIFIED_MATCH_4.matcher(a);
        if (m4.find()) {
            return new ModBy(m4.group(1), m4.group(2));
        }
        Matcher m5 = MODIFIED_MATCH_5.matcher(a);
        if (m5.find()) {
            return new ModBy(m5.group(1), m5.group(2));
        }
        Matcher m6 = MODIFIED_MATCH_6.matcher(a);
        if (m6.find()) {
            return new ModBy(m6.group(1), m6.group(4));
        }
        return null;
    }

    private static String cleanup(String name) {
        return name.strip().replaceAll("(?i)^(conv(er(sion|ted))?|original(ly)?|made|map|done|port(ed)?|edit(ed)?|remix(ed)?|modified|and|by)(\\s+by)?:?", "").replaceAll("(?i)(conv(er(sion|ted))?|original(ly)?|made|map|done|port(ed)?|edit(ed)?|remix(ed)?|modified|and|by)(\\s+by)?:?$", "").strip();
    }

    private Author author(String name) {
        String s = Contributors.cleanup(name);
        Author author = Authors.byName(s);
        if (author == null) {
            author = new Author(s, new String[0]);
        }
        return author;
    }

    public String toString() {
        return String.format("Contributors [authorString=%s, originalAuthor=%s, contributors=[%s], modifiedBy=[%s]]", this.authorString, this.originalAuthor == null ? null : this.originalAuthor.name, this.contributors.stream().map(a -> a.name).collect(Collectors.joining(" | ")), this.modifiedBy.stream().map(a -> a.name).collect(Collectors.joining(" | ")));
    }

    private record ModBy(String original, String editor) {
    }
}

