/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.unrealarchive.common.Util;

public enum FileType {
    CODE(true, "u"),
    MAP(true, "unr", "ut2", "ut3", "un2", "run"),
    PACKAGE(true, "upk"),
    TEXTURE(true, "utx"),
    MUSIC(true, "umx", "ogg"),
    SOUNDS(true, "uax"),
    ANIMATION(true, "ukx"),
    STATICMESH(true, "usx", "usm"),
    PREFAB(true, "upx"),
    PHYSICS(true, "ka"),
    PLAYER(true, "upl"),
    INT(false, "int"),
    INI(false, "ini"),
    UCL(false, "ucl"),
    UMOD(true, "umod", "ut2mod", "ut4mod", "rmod"),
    TEXT(false, "txt"),
    HTML(false, "html", "htm"),
    IMAGE(false, "jpg", "jpeg", "bmp", "png", "gif");

    public static final FileType[] PACKAGES;
    public static final FileType[] ALL;
    public final boolean important;
    public final Collection<String> ext;
    private static final Set<FileType> packages;

    private FileType(boolean important, String ... ext) {
        this.important = important;
        this.ext = Collections.unmodifiableCollection(Arrays.asList(ext));
    }

    public boolean matches(String path) {
        return this.ext.contains(Util.extension((String)path).toLowerCase());
    }

    public boolean isPackage() {
        return packages.contains((Object)this);
    }

    public static boolean important(Path path) {
        return FileType.important(path.toString());
    }

    public static boolean important(String path) {
        for (FileType type : FileType.values()) {
            if (!type.important || !type.ext.contains(Util.extension((String)path).toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static FileType forFile(String path) {
        for (FileType type : FileType.values()) {
            if (!type.ext.contains(Util.extension((String)path).toLowerCase())) continue;
            return type;
        }
        return null;
    }

    static {
        PACKAGES = new FileType[]{CODE, MAP, TEXTURE, SOUNDS, ANIMATION, STATICMESH, PACKAGE, MUSIC};
        ALL = FileType.values();
        packages = new HashSet<FileType>(Arrays.asList(PACKAGES));
    }
}

