/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Optional;
import java.util.stream.Stream;
import org.unrealarchive.common.ArchiveUtil;
import org.unrealarchive.common.CLI;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.AuthorRepository;
import org.unrealarchive.content.Authors;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.content.docs.DocumentRepository;
import org.unrealarchive.content.managed.ManagedContentRepository;
import org.unrealarchive.content.wiki.WikiRepository;

public class RepositoryManager {
    private static final String CONTENT_DIR = "content";
    private static final String DOCUMENTS_DIR = "documents";
    private static final String GAMETYPES_DIR = "gametypes";
    private static final String MANAGED_DIR = "managed";
    private static final String AUTHORS_DIR = "authors";
    private static final String WIKIS_DIR = "wikis";
    private static final Path TMP = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static final String CONTENT_URL = System.getenv().getOrDefault("UA_CONTENT_URL", "https://github.com/unreal-archive/unreal-archive-data/archive/master.zip");
    private final CLI cli;
    private volatile SimpleAddonRepository simpleAddonRepository;
    private volatile ManagedContentRepository managedContentRepository;
    private volatile DocumentRepository documentRepository;
    private volatile AuthorRepository authorRepository;
    private volatile WikiRepository wikiRepository;
    private volatile GameTypeRepository gameTypeRepository;

    public RepositoryManager(CLI cli) {
        this.cli = cli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleAddonRepository addons() {
        if (this.simpleAddonRepository != null) return this.simpleAddonRepository;
        String string = CONTENT_DIR;
        synchronized (CONTENT_DIR) {
            if (this.simpleAddonRepository != null) return this.simpleAddonRepository;
            this.simpleAddonRepository = this.createContentRepo();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.simpleAddonRepository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GameTypeRepository gameTypes() {
        if (this.gameTypeRepository != null) return this.gameTypeRepository;
        String string = GAMETYPES_DIR;
        synchronized (GAMETYPES_DIR) {
            if (this.gameTypeRepository != null) return this.gameTypeRepository;
            this.gameTypeRepository = this.createGameTypeRepo();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.gameTypeRepository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ManagedContentRepository managed() {
        if (this.managedContentRepository != null) return this.managedContentRepository;
        String string = MANAGED_DIR;
        synchronized (MANAGED_DIR) {
            if (this.managedContentRepository != null) return this.managedContentRepository;
            this.managedContentRepository = this.createManagedRepo();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.managedContentRepository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DocumentRepository docs() {
        if (this.documentRepository != null) return this.documentRepository;
        String string = DOCUMENTS_DIR;
        synchronized (DOCUMENTS_DIR) {
            if (this.documentRepository != null) return this.documentRepository;
            this.documentRepository = this.createDocumentRepo();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.documentRepository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AuthorRepository authors() {
        if (this.authorRepository != null) return this.authorRepository;
        String string = AUTHORS_DIR;
        synchronized (AUTHORS_DIR) {
            if (this.authorRepository != null) return this.authorRepository;
            this.authorRepository = this.createAuthorRepo();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.authorRepository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WikiRepository wikis() {
        if (this.wikiRepository != null) return this.wikiRepository;
        String string = WIKIS_DIR;
        synchronized (WIKIS_DIR) {
            if (this.wikiRepository != null) return this.wikiRepository;
            this.wikiRepository = this.createWikiRepo();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.wikiRepository;
        }
    }

    private SimpleAddonRepository createContentRepo() {
        try {
            Path contentPath = this.getContentPath();
            long start = System.currentTimeMillis();
            SimpleAddonRepository.FileRepository repo = new SimpleAddonRepository.FileRepository(contentPath.resolve(CONTENT_DIR));
            double gigs = (double)repo.fileSize() / 1024.0 / 1024.0 / 1024.0;
            System.err.printf("Loaded content index with %d items (%.2fGB) in %.2fs%n", repo.size(), gigs, Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
            return repo;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize content repository", e);
        }
    }

    private GameTypeRepository createGameTypeRepo() {
        try {
            Path contentPath = this.getContentPath();
            long start = System.currentTimeMillis();
            GameTypeRepository.FileRepository repo = new GameTypeRepository.FileRepository(contentPath.resolve(GAMETYPES_DIR));
            System.err.printf("Loaded gametypes index with %d items in %.2fs%n", repo.size(), Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
            return repo;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize gametype repository", e);
        }
    }

    private DocumentRepository createDocumentRepo() {
        try {
            Path contentPath = this.getContentPath();
            long start = System.currentTimeMillis();
            DocumentRepository.FileRepository repo = new DocumentRepository.FileRepository(contentPath.resolve(DOCUMENTS_DIR));
            System.err.printf("Loaded document index with %d items in %.2fs%n", repo.size(), Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
            return repo;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize document repository", e);
        }
    }

    private ManagedContentRepository createManagedRepo() {
        try {
            Path contentPath = this.getContentPath();
            long start = System.currentTimeMillis();
            ManagedContentRepository.FileRepository managedContentManager = new ManagedContentRepository.FileRepository(contentPath.resolve(MANAGED_DIR));
            System.err.printf("Loaded managed content index with %d items in %.2fs%n", managedContentManager.size(), Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
            return managedContentManager;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize managed content repository", e);
        }
    }

    private AuthorRepository createAuthorRepo() {
        try {
            Path contentPath = this.getContentPath();
            long start = System.currentTimeMillis();
            AuthorRepository.FileRepository authorRepo = new AuthorRepository.FileRepository(contentPath.resolve(AUTHORS_DIR));
            System.err.printf("Loaded authors repository with %d entries in %.2fs%n", authorRepo.size(), Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
            Authors.setRepository(authorRepo, contentPath.resolve(AUTHORS_DIR));
            Authors.autoPopRepository(authorRepo, this.addons(), this.gameTypes(), this.managed());
            System.err.printf("Populated authors repository with %d entries in %.2fs%n", authorRepo.size(), Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
            return authorRepo;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize author repository", e);
        }
    }

    private WikiRepository createWikiRepo() {
        try {
            Path contentPath = this.getContentPath();
            long start = System.currentTimeMillis();
            WikiRepository.FileRepository wikis = new WikiRepository.FileRepository(contentPath.resolve(WIKIS_DIR));
            System.err.printf("Loaded wikis index with %d pages in %.2fs%n", wikis.size(), Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
            return wikis;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize wiki repository", e);
        }
    }

    private Path getContentPath() throws IOException {
        Path contentPath;
        if (this.cli.option("content-path", null) == null && this.cli.flag("content-download")) {
            Path tmpPath = TMP.resolve("ua-tmp");
            if (!Files.exists(tmpPath, new LinkOption[0]) || !Files.isDirectory(tmpPath, new LinkOption[0])) {
                Files.createDirectories(tmpPath, new FileAttribute[0]);
                Path tmpFile = tmpPath.resolve("archive.zip");
                System.out.printf("Downloading archive from %s... ", CONTENT_URL);
                Util.downloadTo((String)Util.toUriString((String)CONTENT_URL), (Path)tmpFile);
                System.out.println("Done");
                try {
                    System.out.printf("Extracting archive from %s to %s... ", tmpFile, tmpPath);
                    ArchiveUtil.extract((Path)tmpFile, (Path)tmpPath, (Duration)Duration.ofMinutes(10L));
                    System.out.println("Done");
                }
                catch (Throwable e) {
                    ArchiveUtil.cleanPath((Path)tmpPath);
                    throw new IOException("Failed to extract downloaded content archive", e);
                }
            }
            try (Stream<Path> pathStream = Files.walk(tmpPath, 3, FileVisitOption.FOLLOW_LINKS);){
                Optional<Path> contentParent = pathStream.filter(p -> Files.isDirectory(p, new LinkOption[0]) && p.getFileName().toString().equals(CONTENT_DIR)).map(Path::getParent).findFirst();
                this.cli.putOption("content-path", contentParent.orElseThrow(IllegalArgumentException::new).toString());
            }
        }
        if (this.cli.option("content-path", null) == null && !this.cli.flag("content-download")) {
            System.err.println("content-path or content-download must be set");
            System.exit(3);
        }
        if (!Files.isDirectory(contentPath = Paths.get(this.cli.option("content-path", null), new String[0]), new LinkOption[0])) {
            System.err.println("content-path must be a directory!");
            System.exit(3);
        }
        return contentPath.toAbsolutePath();
    }
}

