/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.addons;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.AuthorInfo;
import org.unrealarchive.content.ContentEntity;
import org.unrealarchive.content.Download;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Announcer;
import org.unrealarchive.content.addons.Map;
import org.unrealarchive.content.addons.MapPack;
import org.unrealarchive.content.addons.Model;
import org.unrealarchive.content.addons.Mutator;
import org.unrealarchive.content.addons.Skin;
import org.unrealarchive.content.addons.UnknownAddon;
import org.unrealarchive.content.addons.Voice;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, visible=true, property="contentType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Map.class, name="MAP"), @JsonSubTypes.Type(value=MapPack.class, name="MAP_PACK"), @JsonSubTypes.Type(value=Skin.class, name="SKIN"), @JsonSubTypes.Type(value=Model.class, name="MODEL"), @JsonSubTypes.Type(value=Voice.class, name="VOICE"), @JsonSubTypes.Type(value=Mutator.class, name="MUTATOR"), @JsonSubTypes.Type(value=Announcer.class, name="ANNOUNCER"), @JsonSubTypes.Type(value=UnknownAddon.class, name="UNKNOWN")})
public abstract class Addon
implements ContentEntity<Addon> {
    public static final String UNKNOWN = "Unknown";
    public static final DateTimeFormatter RELEASE_DATE_FMT = DateTimeFormatter.ofPattern("yyyy-MM").withZone(ZoneId.systemDefault());
    public String contentType;
    public LocalDateTime firstIndex;
    public String variationOf = null;
    public String game = "Unknown";
    public String name;
    public String author = "Unknown";
    public String description = "None";
    public String releaseDate = "Unknown";
    public List<Attachment> attachments = new ArrayList<Attachment>();
    public String originalFilename;
    public String hash;
    public int fileSize;
    public List<ContentFile> files = new ArrayList<ContentFile>();
    public int otherFiles = 0;
    public java.util.Map<String, List<Dependency>> dependencies = new HashMap<String, List<Dependency>>();
    public List<Download> downloads = new ArrayList<Download>();
    public java.util.Map<String, String> links = new HashMap<String, String>();
    public java.util.Map<String, String> problemLinks = new HashMap<String, String>();
    public boolean deleted = false;
    private transient AuthorInfo authorInfo;

    @Override
    public String id() {
        return this.hash;
    }

    @Override
    public abstract Path contentPath(Path var1);

    protected String hashPath() {
        return String.format("%s/%s/%s", Character.valueOf(this.hash.charAt(0)), Character.valueOf(this.hash.charAt(1)), this.hash.substring(2, 8));
    }

    @Override
    public Path slugPath(Path root) {
        String game = Util.slug((String)this.game);
        String type = Util.slug((String)(this.contentType.toLowerCase().replaceAll("_", "") + "s"));
        String name = Util.slug((String)(this.name + "_" + this.hash.substring(0, 8)));
        return root.resolve(game).resolve(type).resolve(this.subGrouping()).resolve(name);
    }

    @Override
    public Path pagePath(Path root) {
        Path slugPath = this.slugPath(root);
        return slugPath.getParent().resolve(slugPath.getFileName().toString() + ".html");
    }

    @Override
    public String game() {
        return this.game;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String author() {
        if (this.author == null || this.author.isBlank()) {
            return UNKNOWN;
        }
        return this.author;
    }

    @Override
    public AuthorInfo authorInfo() {
        if (this.authorInfo == null) {
            this.authorInfo = new AuthorInfo(this.author);
        }
        return this.authorInfo;
    }

    @Override
    public String autoDescription() {
        return this.description;
    }

    @Override
    public String releaseDate() {
        if (this.releaseDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            return this.releaseDate.substring(0, 7);
        }
        return this.releaseDate;
    }

    @Override
    public LocalDateTime addedDate() {
        return this.firstIndex;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public String friendlyType() {
        return Util.capitalWords((String)this.contentType.toLowerCase().replaceAll("_", " "));
    }

    @Override
    public String leadImage() {
        return this.attachments.stream().filter(e -> e.type == AttachmentType.IMAGE).map(e -> e.url).findFirst().orElse("");
    }

    @Override
    public java.util.Map<String, String> links() {
        return this.links;
    }

    @Override
    public java.util.Map<String, String> problemLinks() {
        return this.problemLinks;
    }

    @Override
    public boolean deleted() {
        return this.deleted;
    }

    @Override
    @JsonIgnore
    public boolean isVariation() {
        return this.variationOf != null && !this.variationOf.isBlank();
    }

    public String subGrouping() {
        int first = this.name.toUpperCase().replaceAll("[^A-Z0-9]", "").charAt(0);
        if (Character.isDigit((char)first)) {
            first = 48;
        }
        return Character.toString((char)first);
    }

    @Override
    public Set<String> autoTags() {
        HashSet<String> tags = new HashSet<String>();
        tags.add(this.contentType.toLowerCase().replaceAll("_", " "));
        tags.addAll(Games.byName((String)this.game).tags);
        return tags;
    }

    public boolean hasDownload(String url) {
        for (Download download : this.downloads) {
            if (!download.url.equals(url)) continue;
            return true;
        }
        return false;
    }

    public Download directDownload() {
        return this.downloads.stream().filter(d -> d.direct).findAny().orElseThrow(() -> new IllegalStateException(String.format("Could not find a direct download for content %s!", this.name())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Addon content = (Addon)o;
        return this.fileSize == content.fileSize && this.otherFiles == content.otherFiles && this.deleted == content.deleted && Objects.equals(this.contentType, content.contentType) && Objects.equals(this.variationOf, content.variationOf) && Objects.equals(this.game, content.game) && Objects.equals(this.name, content.name) && Objects.equals(this.author, content.author) && Objects.equals(this.description, content.description) && Objects.equals(this.releaseDate, content.releaseDate) && Objects.equals(this.attachments, content.attachments) && Objects.equals(this.originalFilename, content.originalFilename) && Objects.equals(this.hash, content.hash) && Objects.equals(this.files, content.files) && Objects.equals(this.downloads, content.downloads) && Objects.equals(this.links, content.links) && Objects.equals(this.problemLinks, content.problemLinks) && Objects.equals(this.dependencies, content.dependencies);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.firstIndex, this.variationOf, this.game, this.name, this.author, this.description, this.releaseDate, this.attachments, this.originalFilename, this.hash, this.fileSize, this.files, this.otherFiles, this.downloads, this.links, this.problemLinks, this.deleted, this.dependencies);
    }

    public static class Attachment {
        public final AttachmentType type;
        public final String name;
        public final String url;

        @ConstructorProperties(value={"type", "name", "url"})
        public Attachment(AttachmentType type, String name, String url) {
            this.type = type;
            this.name = name;
            this.url = url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attachment that = (Attachment)o;
            return this.type == that.type && Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.name, this.url});
        }
    }

    public static enum AttachmentType {
        IMAGE,
        VIDEO,
        MARKDOWN,
        OTHER;

    }

    public static class Dependency {
        public final DependencyStatus status;
        public final String name;
        public final String providedBy;

        @ConstructorProperties(value={"status", "name", "providedBy"})
        public Dependency(DependencyStatus status, String name, String providedBy) {
            this.status = status;
            this.name = name;
            this.providedBy = providedBy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency that = (Dependency)o;
            return this.status == that.status && Objects.equals(this.name, that.name) && Objects.equals(this.providedBy, that.providedBy);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status, this.name, this.providedBy});
        }

        public String toString() {
            return String.format("Dependency [status=%s, name=%s, providedBy=%s]", new Object[]{this.status, this.name, this.providedBy});
        }
    }

    public static enum DependencyStatus {
        OK,
        MISSING,
        PARTIAL;

    }

    public static class ContentFile
    implements Comparable<ContentFile> {
        public String name;
        public int fileSize;
        public String hash;
        private transient String baseName;
        private transient String extension;
        private transient FileType fileType;

        @ConstructorProperties(value={"name", "fileSize", "hash"})
        public ContentFile(String name, int fileSize, String hash) {
            this.name = name;
            this.fileSize = fileSize;
            this.hash = hash;
        }

        @Override
        public int compareTo(ContentFile o) {
            return this.name.compareToIgnoreCase(o.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContentFile that = (ContentFile)o;
            return Objects.equals(this.hash, that.hash);
        }

        public int hashCode() {
            return Objects.hash(this.name.toLowerCase(), this.hash);
        }

        public String baseName() {
            if (this.baseName == null) {
                this.baseName = Util.plainName((String)this.name);
            }
            return this.baseName;
        }

        public String extension() {
            if (this.extension == null) {
                this.extension = Util.extension((String)this.name);
            }
            return this.extension;
        }

        public FileType fileType() {
            if (this.fileType == null) {
                this.fileType = FileType.forFile(this.name);
            }
            return this.fileType;
        }
    }
}

