/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.addons;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.NameDescription;
import org.unrealarchive.content.addons.Addon;

public class Announcer
extends Addon {
    private static final String PATH_STRING = "%s/%s/%s/%s/";
    public List<NameDescription> announcers = new ArrayList<NameDescription>();

    @Override
    public Path contentPath(Path root) {
        String namePrefix = this.subGrouping();
        return root.resolve(String.format(PATH_STRING, this.game, "Announcers", namePrefix, this.hashPath()));
    }

    @Override
    public String autoDescription() {
        return String.format("%s, an announcer pack for %s with %s%s", this.name, Games.byName((String)this.game).bigName, this.announcers.isEmpty() ? "no announcers" : (this.announcers.size() > 1 ? this.announcers.size() + " announcers" : this.announcers.size() + " announcer"), this.authorName().equalsIgnoreCase("unknown") ? "" : ", created by " + this.authorName());
    }

    @Override
    public Set<String> autoTags() {
        HashSet<String> tags = new HashSet<String>(super.autoTags());
        tags.add(this.name.toLowerCase());
        tags.addAll(this.announcers.stream().map(m -> m.name.toLowerCase()).toList());
        return tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Announcer)) {
            return false;
        }
        Announcer other = (Announcer)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.announcers, other.announcers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.announcers);
    }
}

