/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.addons;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;

public class Model
extends Addon {
    private static final String PATH_STRING = "%s/%s/%s/%s/";
    public List<String> models = new ArrayList<String>();
    public List<String> skins = new ArrayList<String>();

    @Override
    public Path contentPath(Path root) {
        String namePrefix = this.subGrouping();
        return root.resolve(String.format(PATH_STRING, this.game, "Models", namePrefix, this.hashPath()));
    }

    @Override
    public String autoDescription() {
        Object[] objectArray = new Object[5];
        objectArray[0] = this.name;
        objectArray[1] = Games.byName((String)this.game).bigName;
        Object object = this.models.isEmpty() ? "no characters" : (objectArray[2] = this.models.size() > 1 ? this.models.size() + " characters" : this.models.size() + " character");
        objectArray[3] = this.skins.isEmpty() ? "" : String.format(" and %s", this.skins.size() > 1 ? this.skins.size() + " skins" : this.skins.size() + " skin");
        objectArray[4] = this.authorName().equalsIgnoreCase("unknown") ? "" : ", created by " + this.authorName();
        return String.format("%s, a player model for %s with %s%s%s", objectArray);
    }

    @Override
    public Set<String> autoTags() {
        HashSet<String> tags = new HashSet<String>(super.autoTags());
        tags.add(this.name.toLowerCase());
        tags.addAll(this.models.stream().map(String::toLowerCase).toList());
        tags.addAll(this.skins.stream().map(String::toLowerCase).toList());
        return tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Model)) {
            return false;
        }
        Model other = (Model)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.models, other.models) && Objects.equals(this.skins, other.skins);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.models, this.skins);
    }
}

