/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.addons;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.NameDescription;
import org.unrealarchive.content.addons.Addon;

public class Mutator
extends Addon {
    private static final String PATH_STRING = "%s/%s/%s/%s/";
    public List<NameDescription> mutators = new ArrayList<NameDescription>();
    public List<NameDescription> weapons = new ArrayList<NameDescription>();
    public List<NameDescription> vehicles = new ArrayList<NameDescription>();
    public boolean hasConfigMenu = false;
    public boolean hasKeybinds = false;

    @Override
    public Path contentPath(Path root) {
        String namePrefix = this.subGrouping();
        return root.resolve(String.format(PATH_STRING, this.game, "Mutators", namePrefix, this.hashPath()));
    }

    @Override
    public String autoDescription() {
        return String.format("%s, a %s mutator for %s%s", this.name, this.vehicles.isEmpty() && this.weapons.isEmpty() ? "" : (!this.weapons.isEmpty() && !this.vehicles.isEmpty() ? "weapon and vehicle" : (!this.weapons.isEmpty() ? "weapon" : "vehicle")), Games.byName((String)this.game).bigName, this.authorName().equalsIgnoreCase("unknown") ? "" : ", created by " + this.authorName());
    }

    @Override
    public Set<String> autoTags() {
        HashSet<String> tags = new HashSet<String>(super.autoTags());
        tags.add(this.name.toLowerCase());
        if (!this.weapons.isEmpty()) {
            tags.add("weapons");
        }
        if (!this.vehicles.isEmpty()) {
            tags.add("vehicles");
        }
        tags.addAll(this.mutators.stream().map(m -> m.name.toLowerCase()).toList());
        return tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mutator)) {
            return false;
        }
        Mutator other = (Mutator)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.hasConfigMenu == other.hasConfigMenu && this.hasKeybinds == other.hasKeybinds && Objects.equals(this.mutators, other.mutators) && Objects.equals(this.weapons, other.weapons) && Objects.equals(this.vehicles, other.vehicles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mutators, this.weapons, this.vehicles, this.hasConfigMenu, this.hasKeybinds);
    }
}

