/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.addons;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;

public class Skin
extends Addon {
    private static final String PATH_STRING = "%s/%s/%s/%s/";
    public List<String> skins = new ArrayList<String>();
    public List<String> faces = new ArrayList<String>();
    public String model = "Unknown";
    public boolean teamSkins = false;

    @Override
    public Path contentPath(Path root) {
        String namePrefix = this.subGrouping();
        return root.resolve(String.format(PATH_STRING, this.game, "Skins", namePrefix, this.hashPath()));
    }

    @Override
    public String autoDescription() {
        Object[] objectArray = new Object[5];
        objectArray[0] = this.name;
        objectArray[1] = Games.byName((String)this.game).bigName;
        Object object = this.skins.isEmpty() ? "no skins" : (objectArray[2] = this.skins.size() > 1 ? this.skins.size() + " skins" : this.skins.size() + " skin");
        objectArray[3] = this.faces.isEmpty() ? "" : String.format(" and %s", this.faces.size() > 1 ? this.faces.size() + " faces" : this.faces.size() + " face");
        objectArray[4] = this.authorName().equalsIgnoreCase("unknown") ? "" : ", created by " + this.authorName();
        return String.format("%s, a player skin for %s with %s%s%s", objectArray);
    }

    @Override
    public Set<String> autoTags() {
        HashSet<String> tags = new HashSet<String>(super.autoTags());
        tags.add(this.name.toLowerCase());
        tags.addAll(this.skins.stream().map(String::toLowerCase).toList());
        tags.addAll(this.faces.stream().map(String::toLowerCase).toList());
        return tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Skin)) {
            return false;
        }
        Skin other = (Skin)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.teamSkins == other.teamSkins && Objects.equals(this.skins, other.skins) && Objects.equals(this.faces, other.faces) && Objects.equals(this.model, other.model);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.skins, this.faces, this.model, this.teamSkins);
    }
}

