/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.addons;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;

public class Voice
extends Addon {
    private static final String PATH_STRING = "%s/%s/%s/%s/";
    public List<String> voices = new ArrayList<String>();

    @Override
    public Path contentPath(Path root) {
        String namePrefix = this.subGrouping();
        return root.resolve(String.format(PATH_STRING, this.game, "Voices", namePrefix, this.hashPath()));
    }

    @Override
    public String autoDescription() {
        return String.format("%s, a voice pack for %s with %s%s", this.name, Games.byName((String)this.game).bigName, this.voices.isEmpty() ? "no voices" : (this.voices.size() > 1 ? this.voices.size() + " voices" : this.voices.size() + " voice"), this.authorName().equalsIgnoreCase("unknown") ? "" : ", created by " + this.authorName());
    }

    @Override
    public Set<String> autoTags() {
        HashSet<String> tags = new HashSet<String>(super.autoTags());
        tags.add(this.name.toLowerCase());
        tags.addAll(this.voices.stream().map(String::toLowerCase).toList());
        return tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Voice)) {
            return false;
        }
        Voice other = (Voice)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.voices, other.voices);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.voices);
    }
}

