/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.docs;

import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Objects;
import org.unrealarchive.common.Util;

public class Document
implements Comparable<Document> {
    public LocalDate createdDate;
    public LocalDate updatedDate;
    public String game = "Unreal";
    public String group = "Reference";
    public String subGroup = "UnrealEd";
    public String name = "document.md";
    public String title;
    public String titleImage;
    public String author = "Unknown";
    public String description = "None";
    public boolean published = true;

    public Path slugPath(Path root) {
        String game = Util.slug((String)this.game);
        String group = Util.slug((String)this.group);
        String subGroup = Util.slug((String)this.subGroup);
        String name = Util.slug((String)this.title);
        return root.resolve(game).resolve("documents").resolve(group).resolve(subGroup).resolve(name);
    }

    public Path pagePath(Path root) {
        return this.slugPath(root).resolve("index.html");
    }

    @Override
    public int compareTo(Document document) {
        return this.createdDate.compareTo(document.createdDate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document that = (Document)o;
        return Objects.equals(this.game, that.game) && Objects.equals(this.group, that.group) && Objects.equals(this.subGroup, that.subGroup) && Objects.equals(this.title, that.title) && Objects.equals(this.titleImage, that.titleImage) && Objects.equals(this.author, that.author) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.game, this.group, this.subGroup, this.title, this.titleImage, this.author, this.description);
    }
}

