/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.managed;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.unrealarchive.common.Util;
import org.unrealarchive.common.YAML;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.managed.Managed;

public interface ManagedContentRepository {
    public int size();

    public Collection<Managed> all();

    public void put(Managed var1) throws IOException;

    public void create(Games var1, String var2, String var3, String var4, Consumer<Managed> var5) throws IOException;

    public ReadableByteChannel document(Managed var1) throws IOException;

    public void writeContent(Managed var1, Path var2) throws IOException;

    public Managed findManaged(Games var1, String var2, String var3, String var4);

    public static class FileRepository
    implements ManagedContentRepository {
        private static final String DOCUMENT_FILE = "readme.md";
        private static final String DOCUMENT_TEMPLATE_FILE = "template.md";
        private final Path root;
        private final Map<Managed, ManagedContentHolder> content;

        public FileRepository(Path root) throws IOException {
            this.root = root;
            this.content = new ConcurrentHashMap<Managed, ManagedContentHolder>();
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (Util.extension((Path)file).equalsIgnoreCase("yml")) {
                        Managed c = (Managed)YAML.fromFile((Path)file, Managed.class);
                        content.put(c, new ManagedContentHolder(file, c));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        @Override
        public int size() {
            return this.content.size();
        }

        @Override
        public Collection<Managed> all() {
            return Collections.unmodifiableCollection(this.content.keySet());
        }

        @Override
        public ReadableByteChannel document(Managed managed) throws IOException {
            ManagedContentHolder holder = this.content.get(managed);
            if (holder == null) {
                return null;
            }
            Path docPath = holder.path.getParent().resolve(managed.document);
            if (!Files.exists(docPath, new LinkOption[0])) {
                return null;
            }
            return Files.newByteChannel(docPath, StandardOpenOption.READ);
        }

        @Override
        public void writeContent(Managed managed, Path outPath) throws IOException {
            ManagedContentHolder holder = this.content.get(managed);
            if (holder == null) {
                return;
            }
            Util.copyTree((Path)holder.path.getParent(), (Path)outPath);
        }

        @Override
        public void put(Managed managed) throws IOException {
            Path outPath = Files.createDirectories(managed.contentPath(this.root), new FileAttribute[0]);
            Path yml = Util.safeFileName((Path)outPath.resolve("managed.yml"));
            Files.writeString(yml, (CharSequence)YAML.toString((Object)managed), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.content.put(managed, new ManagedContentHolder(yml, managed));
        }

        @Override
        public void create(Games game, String group, String subGroup, String title, Consumer<Managed> completed) throws IOException {
            String neatName = Util.capitalWords((String)title);
            Managed man = new Managed();
            man.createdDate = LocalDate.now();
            man.updatedDate = LocalDate.now();
            man.game = game.name;
            man.group = group;
            man.subGroup = subGroup;
            man.title = neatName;
            man.author = "Unknown";
            man.document = DOCUMENT_FILE;
            man.titleImage = "title.png";
            Managed.ManagedFile sampleFile = new Managed.ManagedFile();
            sampleFile.title = neatName + " Download";
            sampleFile.version = "1.0";
            sampleFile.localFile = "/path/to/file.zip";
            man.downloads.add(sampleFile);
            completed.accept(man);
            this.put(man);
            Path docPath = Files.createDirectories(man.contentPath(this.root), new FileAttribute[0]);
            Path md = Util.safeFileName((Path)docPath.resolve(DOCUMENT_FILE));
            if (!Files.exists(md, new LinkOption[0])) {
                try (InputStream is = this.getClass().getResourceAsStream(DOCUMENT_TEMPLATE_FILE);){
                    assert (is != null);
                    Files.copy(is, md, new CopyOption[0]);
                }
            }
        }

        @Override
        public Managed findManaged(Games game, String group, String path, String title) {
            return this.content.values().stream().filter(m -> !m.managed.deleted()).filter(m -> m.managed.game().equalsIgnoreCase(game.name)).filter(m -> m.managed.group.equalsIgnoreCase(group)).filter(m -> m.managed.subGroup.equalsIgnoreCase(path)).filter(m -> m.managed.title.equalsIgnoreCase(title)).map(m -> m.managed).findFirst().orElse(null);
        }

        private record ManagedContentHolder(Path path, Managed managed) {
        }
    }
}

