/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.content.wiki;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unrealarchive.common.JSON;
import org.unrealarchive.common.Util;
import org.unrealarchive.common.YAML;
import org.unrealarchive.content.wiki.InterWikiList;
import org.unrealarchive.content.wiki.WikiPage;

public interface WikiRepository {
    public Wiki wiki(String var1);

    public Set<Wiki> all();

    public int size();

    public static final class Wiki {
        private static final Pattern REDIRECT = Pattern.compile("#REDIRECT ?\\[\\[([^]]+)]].*", 32);
        public transient Path path;
        public String name;
        public String owner;
        public String url;
        public WikiLicence licence;
        public String title;
        public String homepage;
        public String imagesPath;
        public Set<String> skipCategories;
        public Set<String> skipTemplates;
        public Set<String> deleteElements;
        public boolean publish;
        public transient InterWikiList interWiki = new InterWikiList(Set.of());
        public final transient Map<String, String> redirects = new ConcurrentHashMap<String, String>();
        private final transient Map<String, WikiPageHolder> pages = new ConcurrentHashMap<String, WikiPageHolder>();

        public void addPage(Path path, WikiPage page) {
            WikiPageHolder pageHolder = new WikiPageHolder(path);
            this.pages.put(page.name, pageHolder);
            Matcher matcher = REDIRECT.matcher(page.parse.wikitext.text);
            if (matcher.matches()) {
                this.redirects.put(page.name, matcher.group(1));
                this.redirects.put(page.name.replaceAll(" ", "_"), matcher.group(1));
                page.isRedirect = true;
                pageHolder.isRedirect = true;
            }
        }

        public WikiPage page(String name) {
            return this.pages.get(name).get();
        }

        public Set<WikiPage> all() {
            return this.pages.values().stream().filter(p -> !p.isRedirect).map(WikiPageHolder::get).collect(Collectors.toSet());
        }

        private static class WikiPageHolder {
            private final Path path;
            private SoftReference<WikiPage> page;
            private boolean isRedirect;

            public WikiPageHolder(Path path) {
                this.path = path;
                this.page = null;
            }

            public WikiPage get() {
                WikiPage maybePage;
                WikiPage wikiPage = maybePage = this.page != null ? this.page.get() : null;
                if (maybePage == null) {
                    try {
                        maybePage = (WikiPage)YAML.fromFile((Path)this.path, WikiPage.class);
                        this.page = new SoftReference<WikiPage>(maybePage);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to load page from file", e);
                    }
                }
                return maybePage;
            }
        }

        public static class WikiLicence {
            public String name;
            public String url;
        }
    }

    public static class FileRepository
    implements WikiRepository {
        private final Map<String, Wiki> wikis = new HashMap<String, Wiki>();

        public static void main(String[] args) throws IOException {
        }

        public static void convert(Path wikiRoot) throws IOException {
            try (Stream<Path> files = Files.walk(wikiRoot.resolve("content"), FileVisitOption.FOLLOW_LINKS);){
                files.filter(f -> Files.isRegularFile(f, new LinkOption[0]) && Util.extension((Path)f).equalsIgnoreCase("json")).forEach(f -> {
                    try {
                        WikiPage pg = (WikiPage)JSON.fromFile((Path)f, WikiPage.class);
                        Files.write(f.resolveSibling(String.format("%s.yml", Util.plainName((Path)f))), YAML.toBytes((Object)pg), new OpenOption[0]);
                        System.out.println("rewrite " + String.valueOf(f));
                        Files.deleteIfExists(f);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }

        public static void clean(Path wikiRoot) throws IOException {
            Wiki wiki = (Wiki)YAML.fromFile((Path)wikiRoot.resolve("wiki.yml"), Wiki.class);
            try (Stream<Path> files = Files.walk(wikiRoot.resolve("content"), FileVisitOption.FOLLOW_LINKS);){
                files.filter(f -> Files.isRegularFile(f, new LinkOption[0]) && Util.extension((Path)f).equalsIgnoreCase("yml")).forEach(f -> {
                    try {
                        boolean delete;
                        WikiPage pg = (WikiPage)YAML.fromFile((Path)f, WikiPage.class);
                        boolean bl = delete = pg.parse.categories.stream().anyMatch(c -> wiki.skipCategories.stream().anyMatch(c.name::contains)) || pg.parse.templates.stream().anyMatch(c -> wiki.skipTemplates.stream().anyMatch(c.name::contains));
                        if (delete) {
                            System.out.println("Deleting " + String.valueOf(f));
                            Files.deleteIfExists(f);
                            Files.deleteIfExists(f.getParent().resolve("Talk:" + Util.fileName((Path)f)));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }

        public FileRepository(Path wikiRoot) throws IOException {
            if (!Files.exists(wikiRoot, new LinkOption[0])) {
                return;
            }
            try (Stream<Path> list = Files.list(wikiRoot);){
                list.forEach(d -> {
                    block9: {
                        try {
                            if (!Files.exists(d.resolve("wiki.yml"), new LinkOption[0])) break block9;
                            Wiki wiki = (Wiki)YAML.fromFile((Path)d.resolve("wiki.yml"), Wiki.class);
                            wiki.path = d;
                            if (Files.exists(d.resolve("interwiki.yml"), new LinkOption[0])) {
                                wiki.interWiki = (InterWikiList)YAML.fromFile((Path)d.resolve("interwiki.yml"), InterWikiList.class);
                            }
                            wiki.redirects.put("Main_Page", "index");
                            wiki.redirects.put("Main Page", "index");
                            this.wikis.put(wiki.name, wiki);
                            try (Stream<Path> files = Files.walk(d.resolve("content"), new FileVisitOption[0]);){
                                ((Stream)files.parallel()).filter(f -> Files.isRegularFile(f, new LinkOption[0]) && Util.extension((Path)f).equalsIgnoreCase("yml")).forEach(f -> {
                                    try {
                                        WikiPage pg = (WikiPage)YAML.fromFile((Path)f, WikiPage.class);
                                        wiki.addPage((Path)f, pg);
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                });
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        }

        @Override
        public Wiki wiki(String name) {
            return this.wikis.get(name);
        }

        @Override
        public Set<Wiki> all() {
            return this.wikis.values().stream().filter(w -> w.publish).collect(Collectors.toSet());
        }

        @Override
        public int size() {
            return this.wikis.values().stream().mapToInt(w -> w.pages.size()).sum();
        }
    }
}

