/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.announcers;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.shrimpworks.unreal.packages.IntFile;
import org.unrealarchive.content.FileType;
import org.unrealarchive.indexing.Classifier;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexUtils;

public class AnnouncerClassifier
implements Classifier {
    @Override
    public boolean classify(Incoming incoming) {
        Set<Incoming.IncomingFile> uclFiles = incoming.files(FileType.UCL);
        Set<Incoming.IncomingFile> soundFiles = incoming.files(FileType.CODE, FileType.SOUNDS);
        Set<Incoming.IncomingFile> miscFiles = incoming.files(FileType.MAP, FileType.MUSIC, FileType.STATICMESH, FileType.ANIMATION, FileType.PLAYER);
        if (!miscFiles.isEmpty()) {
            return false;
        }
        if (uclFiles.isEmpty() || soundFiles.isEmpty()) {
            return false;
        }
        return this.checkUT2Announcer(incoming, uclFiles);
    }

    private boolean checkUT2Announcer(Incoming incoming, Set<Incoming.IncomingFile> uclFiles) {
        AtomicBoolean seemsToBeAnnouncer = new AtomicBoolean(false);
        AtomicBoolean probablyNotAnnouncer = new AtomicBoolean(false);
        IndexUtils.readIntFiles(incoming, uclFiles, true).filter(Objects::nonNull).forEach(uclFile -> {
            if (probablyNotAnnouncer.get()) {
                return;
            }
            IntFile.Section section = uclFile.section("root");
            if (section == null) {
                return;
            }
            if (section.keys().contains("Map") || section.keys().contains("Game") || section.keys().contains("Mutator")) {
                probablyNotAnnouncer.set(true);
                return;
            }
            if (section.keys().contains("Announcer")) {
                seemsToBeAnnouncer.set(true);
            }
        });
        return !probablyNotAnnouncer.get() && seemsToBeAnnouncer.get();
    }
}

