/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.shrimpworks.unreal.packages.IntFile;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.Import;
import net.shrimpworks.unreal.packages.entities.Named;
import net.shrimpworks.unreal.packages.entities.objects.Polys;
import org.unrealarchive.Main;
import org.unrealarchive.common.ArchiveUtil;
import org.unrealarchive.common.CLI;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.Download;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.GameType;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.MapGameTypes;
import org.unrealarchive.content.addons.MapPack;
import org.unrealarchive.content.addons.Model;
import org.unrealarchive.content.addons.Mutator;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.content.addons.Skin;
import org.unrealarchive.content.addons.Voice;
import org.unrealarchive.content.managed.Managed;
import org.unrealarchive.content.managed.ManagedContentRepository;
import org.unrealarchive.indexing.ContentManager;
import org.unrealarchive.indexing.GameTypeManager;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexLog;
import org.unrealarchive.indexing.IndexResult;
import org.unrealarchive.indexing.IndexUtils;
import org.unrealarchive.indexing.Indexer;
import org.unrealarchive.indexing.ManagedContentManager;
import org.unrealarchive.indexing.Submission;
import org.unrealarchive.indexing.maps.MapIndexHandler;
import org.unrealarchive.mirror.LocalMirrorClient;
import org.unrealarchive.storage.DataStore;

public class IndexHelper {
    private static final String ROOT = "./unreal-archive-data";

    public static void main(String[] args) throws IOException, InterruptedException {
        IndexHelper.fixMonsterHuntSnipersParadise();
    }

    private static void gc() throws IOException {
        System.out.println(IndexHelper.repo().gc());
    }

    private static SimpleAddonRepository repo() throws IOException {
        return new SimpleAddonRepository.FileRepository(Paths.get(ROOT, new String[0]).resolve("content"));
    }

    private static GameTypeRepository gametypeRepo() throws IOException {
        return new GameTypeRepository.FileRepository(Paths.get(ROOT, new String[0]).resolve("gametypes"));
    }

    private static ManagedContentRepository managedRepo() throws IOException {
        return new ManagedContentRepository.FileRepository(Paths.get(ROOT, new String[0]).resolve("managed"));
    }

    private static ContentManager manager() throws IOException {
        return new ContentManager(IndexHelper.repo(), DataStore.NOP, DataStore.NOP);
    }

    private static GameTypeManager gametypes() throws IOException {
        return new GameTypeManager(IndexHelper.gametypeRepo(), DataStore.NOP, DataStore.NOP);
    }

    private static ManagedContentManager managed() throws IOException {
        return new ManagedContentManager(IndexHelper.managedRepo(), DataStore.NOP);
    }

    private static void maybeCheckin(ContentManager cm, Addon co, boolean changed) throws IOException {
        if (changed) {
            IndexHelper.checkinChange(cm, co);
        }
    }

    private static void checkinChange(ContentManager cm, Addon co) throws IOException {
        if (cm.checkin(new IndexResult<Addon>(co, Collections.emptySet()), null)) {
            System.out.println("Stored changes for " + String.join((CharSequence)" / ", co.game, co.contentType(), co.name));
        } else {
            System.out.println("Failed to apply for " + String.join((CharSequence)" / ", co.game, co.contentType(), co.name, co.hash));
        }
    }

    public static void reassignUT2003() throws IOException {
        ContentManager cm = IndexHelper.manager();
        String dateFrom = "2002-09-30";
        String dateTo = "2004-02-28";
        Collection search = cm.repo().search("Unreal Tournament 2004", null, null, null).stream().filter(c -> c.originalFilename.toLowerCase().contains("ut2k3") || c.originalFilename.toLowerCase().contains("ut2003") || c.releaseDate.compareTo("2002-09-30") > 0 && c.releaseDate.compareTo("2004-02-28") < 0).collect(Collectors.toSet());
        for (Addon c2 : search) {
            Addon co = cm.checkout(c2.hash);
            co.game = "Unreal Tournament 2003";
            IndexHelper.checkinChange(cm, co);
        }
    }

    public static void fixVariations() throws IOException {
        ContentManager cm = IndexHelper.manager();
        List<Addon> search = cm.repo().search("Unreal Tournament 2003", null, null, null).stream().sorted(Comparator.comparing(Addon::addedDate)).toList();
        for (Addon c : search) {
            Addon variation;
            Addon cur = cm.repo().forHash(c.hash);
            Addon existing = cm.repo().search(c.game, c.contentType, c.name, c.author).stream().filter(m -> !Objects.equals(m.hash, c.hash)).filter(m -> !Objects.equals(m.hash, cur.variationOf)).filter(m -> !Objects.equals(m.variationOf, c.hash)).max(Comparator.comparing(a -> a.releaseDate)).orElse(null);
            if (existing == null) continue;
            if (existing.variationOf == null && existing.releaseDate.compareTo(c.releaseDate) < 0) {
                variation = cm.checkout(existing.hash);
                variation.variationOf = c.hash;
                IndexHelper.checkinChange(cm, variation);
                System.out.printf("Flagging original content %s as variation of %s%n", existing.name(), c.name());
                continue;
            }
            if (cur.variationOf == null && existing.releaseDate.compareTo(c.releaseDate) > 0) {
                variation = cm.checkout(c.hash);
                variation.variationOf = existing.hash;
                IndexHelper.checkinChange(cm, variation);
                System.out.printf("Flagging %s as variation of %s%n", c.name(), existing.name());
                continue;
            }
            if (existing.variationOf != null || !existing.firstIndex.isBefore(c.firstIndex)) continue;
            variation = cm.checkout(existing.hash);
            variation.variationOf = c.hash;
            IndexHelper.checkinChange(cm, variation);
            System.out.printf("Flagging content %s as variation of %s%n", existing.name(), c.name());
        }
    }

    public static void attachmentGametypeMove() throws IOException {
        CLI cli = CLI.parse((String[])new String[0]);
        try (DataStore imageStore = Main.store(DataStore.StoreContent.IMAGES, cli);){
            GameTypeManager gm = IndexHelper.gametypes();
            Collection search = gm.repo().all().stream().filter(g -> !g.maps.isEmpty()).filter(g -> g.maps.stream().anyMatch(m -> m.screenshot != null && m.screenshot.url.contains("f002.backblazeb2.com"))).collect(Collectors.toSet());
            System.out.println("Found " + search.size());
            AtomicInteger counter = new AtomicInteger(0);
            search.parallelStream().forEach(orig -> {
                if (counter.incrementAndGet() % 100 == 0) {
                    System.out.printf("%d/%d%n", counter.get(), search.size());
                }
                GameType co = gm.checkout((GameType)orig);
                boolean[] changed = new boolean[]{false};
                co.maps.parallelStream().filter(m -> m.screenshot != null).filter(m -> m.screenshot.url.contains("f002.backblazeb2.com")).forEach(m -> {
                    try {
                        Util.urlRequest((String)m.screenshot.url, imgCon -> {
                            try {
                                Path base = Paths.get("", new String[0]);
                                Path uploadPath = co.contentPath(base);
                                String uploadName = base.relativize(uploadPath.resolve(m.screenshot.name)).toString();
                                long length = imgCon.getContentLength();
                                if (length <= 0L) {
                                    throw new RuntimeException("Dunno size");
                                }
                                imageStore.store(imgCon.getInputStream(), length, uploadName, (newUrl, ex) -> {
                                    if (ex != null) {
                                        System.err.printf("Failed[3]: %s - %s: %s%n", m.name, uploadName, ex);
                                    }
                                    if (newUrl != null) {
                                        changed[0] = true;
                                    }
                                });
                            }
                            catch (IOException e) {
                                System.err.printf("Failed[2]: %s - %s: %s%n", m.name, m.screenshot.url, e);
                            }
                        });
                    }
                    catch (IOException e) {
                        System.err.printf("Failed[1]: %s - %s: %s%n", m.name, m.screenshot.url, e);
                    }
                });
                try {
                    if (changed[0]) {
                        gm.checkin(co);
                    }
                }
                catch (Exception e) {
                    System.out.println("Checkin failed " + orig.name + ": " + e.getMessage());
                }
            });
        }
    }

    public static void attachmentMove() throws IOException {
        CLI cli = CLI.parse((String[])new String[0]);
        try (DataStore imageStore = Main.store(DataStore.StoreContent.IMAGES, cli);){
            ContentManager cm = IndexHelper.manager();
            Collection search = cm.repo().all().stream().filter(c -> !c.attachments.isEmpty()).filter(c -> c.attachments.stream().anyMatch(a -> a.url.contains("f002.backblazeb2.com"))).collect(Collectors.toSet());
            System.out.println("Found " + search.size());
            AtomicInteger counter = new AtomicInteger(0);
            search.parallelStream().forEach(orig -> {
                if (counter.incrementAndGet() % 100 == 0) {
                    System.out.printf("%d/%d%n", counter.get(), search.size());
                }
                Addon co = cm.checkout(orig.hash);
                boolean[] changed = new boolean[]{false};
                orig.attachments.parallelStream().filter(a -> a.url.contains("f002.backblazeb2.com")).filter(a -> orig.attachments.stream().noneMatch(o -> a.name.equals(o.name) && !o.url.equals(a.url))).forEach(a -> {
                    try {
                        Util.urlRequest((String)a.url, imgCon -> {
                            try {
                                Path base = Paths.get("", new String[0]);
                                Path uploadPath = co.contentPath(base);
                                String uploadName = base.relativize(uploadPath.resolve(a.name)).toString();
                                long length = imgCon.getContentLength();
                                if (length <= 0L) {
                                    throw new RuntimeException("Dunno size");
                                }
                                imageStore.store(imgCon.getInputStream(), length, uploadName, (newUrl, ex) -> {
                                    if (ex != null) {
                                        System.err.printf("Failed[3]: %s - %s: %s%n", a.name, uploadName, ex);
                                    }
                                    if (newUrl != null && orig.attachments.stream().noneMatch(o -> o.url.equalsIgnoreCase((String)newUrl))) {
                                        co.attachments.add(new Addon.Attachment(Addon.AttachmentType.IMAGE, a.name, newUrl));
                                        changed[0] = true;
                                    }
                                });
                            }
                            catch (IOException e) {
                                System.err.printf("Failed[2]: %s - %s: %s%n", a.name, a.url, e);
                            }
                        });
                    }
                    catch (IOException e) {
                        System.err.printf("Failed[1]: %s - %s: %s%n", a.name, a.url, e);
                    }
                });
                try {
                    IndexHelper.maybeCheckin(cm, co, changed[0]);
                }
                catch (Exception e) {
                    System.out.println("Checkin failed " + orig.name + ": " + e.getMessage());
                }
            });
        }
    }

    public static void removeB2Attachments() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().all().stream().filter(c -> !c.attachments.isEmpty()).filter(c -> c.attachments.stream().anyMatch(a -> a.url.contains("f002.backblazeb2.com"))).filter(c -> c.attachments.stream().anyMatch(a -> a.url.contains("s3.us-west-002.backblazeb2.com"))).collect(Collectors.toSet());
        System.out.println("Found " + search.size());
        AtomicInteger counter = new AtomicInteger(0);
        search.parallelStream().forEach(orig -> {
            if (counter.incrementAndGet() % 100 == 0) {
                System.out.printf("%d/%d%n", counter.get(), search.size());
            }
            Addon co = cm.checkout(orig.hash);
            try {
                IndexHelper.maybeCheckin(cm, co, co.attachments.removeIf(a -> a.url.contains("f002.backblazeb2.com")));
            }
            catch (Exception e) {
                System.out.println("Checkin failed " + orig.name + ": " + e.getMessage());
            }
        });
    }

    public static void removeB2Links() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().all();
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            boolean keep = co.downloads.stream().noneMatch(d -> d.url.contains("unreal-archive-files-s3.s3.us-west-002.backblazeb2.com"));
            if (keep) continue;
            IndexHelper.maybeCheckin(cm, co, co.downloads.removeIf(d -> d.url.contains("f002.backblazeb2.com")));
        }
        GameTypeManager gm = IndexHelper.gametypes();
        Set gtSearch = gm.repo().all();
        for (GameType g : gtSearch) {
            GameType co = gm.checkout(g);
            boolean changed = false;
            boolean keep = false;
            for (GameType.Release r : co.releases) {
                if (r.deleted) continue;
                for (GameType.ReleaseFile f2 : r.files) {
                    if (f2.deleted) continue;
                    keep = f2.downloads.stream().noneMatch(d -> d.url.contains("unreal-archive-files-s3.s3.us-west-002.backblazeb2.com"));
                    if (keep) {
                        System.out.println("Gametype has not been mirrored: " + co.name);
                        break;
                    }
                    changed = f2.downloads.removeIf(d -> d.url.contains("f002.backblazeb2.com"));
                }
                if (!keep) continue;
                break;
            }
            if (keep || !changed) continue;
            gm.checkin(co);
        }
        ManagedContentManager mm = IndexHelper.managed();
        Collection mSearch = mm.repo().all();
        for (Managed m : mSearch) {
            Managed co = mm.checkout(m);
            boolean changed = false;
            boolean keep = false;
            for (Managed.ManagedFile d2 : co.downloads) {
                if (d2.deleted) continue;
                keep = d2.downloads.stream().noneMatch(f -> f.url.contains("unreal-archive-files-s3.s3.us-west-002.backblazeb2.com"));
                if (keep) {
                    System.out.println("Managed has not been mirrored: " + co.title);
                    break;
                }
                changed = d2.downloads.removeIf(f -> f.url.contains("f002.backblazeb2.com"));
            }
            if (keep || !changed) continue;
            mm.checkin(co);
        }
    }

    private static boolean isDirect(String url) {
        return url.contains("backblaze") || url.contains("linodeobjects") || url.contains("vohzd") || url.contains("blob.core.windows.net");
    }

    public static void fixDirectDownloads() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().all();
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            co.downloads.forEach(d -> {
                d.direct = IndexHelper.isDirect(d.url);
            });
            IndexHelper.maybeCheckin(cm, co, true);
        }
        GameTypeManager gm = IndexHelper.gametypes();
        Set gtSearch = gm.repo().all().stream().filter(GameType::isVariation).collect(Collectors.toSet());
        for (GameType g : gtSearch) {
            GameType co = gm.checkout(g);
            for (GameType.Release r : co.releases) {
                for (GameType.ReleaseFile f : r.files) {
                    f.downloads.forEach(d -> {
                        d.direct = IndexHelper.isDirect(d.url);
                    });
                }
            }
            gm.checkin(co);
        }
        ManagedContentManager mm = IndexHelper.managed();
        Collection mSearch = mm.repo().all();
        for (Managed m : mSearch) {
            Managed co = mm.checkout(m);
            for (GameType.ReleaseFile f : co.downloads) {
                f.downloads.forEach(d -> {
                    d.direct = IndexHelper.isDirect(d.url);
                });
            }
            mm.checkin(co);
        }
    }

    public static void fixDownloadEncoding() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().all();
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            boolean changed = false;
            for (Download dl : co.downloads) {
                String from = "Single%2520Player";
                String to = "Single%2520Player".replaceAll("%2520", "%20");
                if (!dl.url.contains("Single%2520Player")) continue;
                System.out.println(dl.url);
                dl.url = dl.url.replaceAll("Single%2520Player", to);
                System.out.println(dl.url);
                changed = true;
            }
            IndexHelper.maybeCheckin(cm, co, changed);
        }
    }

    public static void relinkMedor() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().all();
        Pattern file = Pattern.compile(".*file=(.*)");
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            boolean changed = false;
            for (Download dl : co.downloads) {
                Matcher m;
                if (!dl.url.contains("http://medor.no-ip.org/") || !(m = file.matcher(dl.url)).find()) continue;
                dl.url = "http://medor.no-ip.org/index.php?dir=&search_mode=f&search=" + m.group(1);
                changed = true;
            }
            IndexHelper.maybeCheckin(cm, co, changed);
        }
    }

    public static void fixDoubleSlashLinks() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().all();
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            boolean changed = false;
            for (Download dl : co.downloads) {
                if (!dl.url.matches(".*[A-Za-z]//.*")) continue;
                dl.url = dl.url.replaceAll("([A-Za-z])//", "$1/");
                System.out.println(dl.url);
                changed = true;
            }
            IndexHelper.maybeCheckin(cm, co, changed);
        }
    }

    private static void trimNames() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().search(null, null, null, null);
        for (Addon c : search) {
            if (c.author.trim().equalsIgnoreCase(c.author)) continue;
            Addon fix = cm.checkout(c.hash);
            fix.author = fix.author.trim();
            if (cm.checkin(new IndexResult<Addon>(fix, Collections.emptySet()), null)) {
                System.out.println("Stored changes for " + String.join((CharSequence)" / ", fix.game, fix.name));
                continue;
            }
            System.out.println("Failed to apply");
        }
    }

    public static void findDupeFiles() throws IOException {
        final HashMap all = new HashMap();
        Files.walkFileTree(Paths.get("unreal-archive-data/content/", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                all.put(String.format("%s/%s", file.getParent().toString().toLowerCase(), file.getFileName()), file);
                return super.visitFile(file, attrs);
            }
        });
        for (String s : all.keySet()) {
            if (s.toLowerCase().equals(s) || !all.containsKey(s.toLowerCase())) continue;
            System.out.println(all.get(s));
            Files.deleteIfExists((Path)all.get(s));
        }
    }

    public static void dedupeExtraFiles() throws IOException {
        ContentManager cm = IndexHelper.manager();
        List<Addon> search = cm.repo().all().stream().filter(m -> m.files.size() > 1).toList();
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            co.files = new ArrayList(new HashSet(co.files));
            if (co.files.size() >= c.files.size()) continue;
            IndexHelper.checkinChange(cm, co);
        }
    }

    public static void dedupeModelsSkinsNames(String game) throws IOException {
        ContentManager cm = IndexHelper.manager();
        List<Model> search = cm.repo().search(game, "MODEL", null, null).stream().filter(m -> m instanceof Model).map(m -> (Model)m).filter(m -> m.skins.size() > 1 || m.models.size() > 1).toList();
        for (Model c : search) {
            Model co = (Model)cm.checkout(c.hash);
            co.models = new ArrayList(new HashSet(co.models));
            co.skins = new ArrayList(new HashSet(co.skins));
            if (co.models.size() >= c.models.size() && co.skins.size() >= c.skins.size()) continue;
            IndexHelper.checkinChange(cm, (Addon)co);
        }
    }

    private static void fixMapGametypes(String gameTypeName) throws IOException {
        MapGameTypes.MapGameType gameType = MapGameTypes.byName((String)gameTypeName);
        assert (gameType != null);
        ContentManager cm = IndexHelper.manager();
        for (String mapPrefix : gameType.mapPrefixes()) {
            Collection search = cm.repo().search(null, "MAP", mapPrefix, null);
            for (Addon c : search) {
                if (!(c instanceof org.unrealarchive.content.addons.Map) || ((org.unrealarchive.content.addons.Map)c).gametype.equalsIgnoreCase(gameType.name()) || !c.name.toLowerCase().startsWith(mapPrefix.toLowerCase())) continue;
                org.unrealarchive.content.addons.Map map = (org.unrealarchive.content.addons.Map)cm.checkout(c.hash);
                map.gametype = gameType.name();
                if (cm.checkin(new IndexResult<org.unrealarchive.content.addons.Map>(map, Collections.emptySet()), null)) {
                    System.out.println("Stored changes for " + String.join((CharSequence)" / ", map.game, map.gametype, map.name));
                    continue;
                }
                System.out.println("Failed to apply");
            }
        }
    }

    private static void fixUt3PlayerCounts() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Pattern playerCount = Pattern.compile("(\\d+(\\s?((up )?to|-)\\s?\\d+)?).*");
        Pattern author = Pattern.compile(".+?(by:\\s?|:\\s+?|by\\s)(.+)");
        Collection search = cm.repo().search("Unreal Tournament 3", "MAP", null, null);
        for (Addon c : search) {
            Matcher am;
            if (!(c instanceof org.unrealarchive.content.addons.Map)) continue;
            org.unrealarchive.content.addons.Map map = (org.unrealarchive.content.addons.Map)cm.checkout(c.hash);
            String orig = map.playerCount;
            Matcher pc = playerCount.matcher(orig);
            boolean changed = false;
            if (pc.matches()) {
                map.playerCount = pc.group(1);
                changed = true;
            }
            if (map.author.equals("Unknown") && (am = author.matcher(orig)).matches()) {
                map.author = am.group(2);
                changed = true;
            }
            if (changed && cm.checkin(new IndexResult<org.unrealarchive.content.addons.Map>(map, Collections.emptySet()), null)) {
                System.out.println("Stored changes for " + String.join((CharSequence)" / ", map.game, map.gametype, map.name));
                continue;
            }
            System.out.println("Failed to apply");
        }
    }

    private static void fixCCMaps() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().search("Unreal", "MAP", "CC-", null);
        for (Addon c : search) {
            if (!(c instanceof org.unrealarchive.content.addons.Map) || !c.name.startsWith("CC") || ((org.unrealarchive.content.addons.Map)c).gametype.equalsIgnoreCase("Crystal Castles")) continue;
            org.unrealarchive.content.addons.Map map = (org.unrealarchive.content.addons.Map)cm.checkout(c.hash);
            map.gametype = "Crystal Castles";
            if (cm.checkin(new IndexResult<org.unrealarchive.content.addons.Map>(map, Collections.emptySet()), null)) {
                System.out.println("Stored changes for " + String.join((CharSequence)" / ", map.game, map.gametype, map.name));
                continue;
            }
            System.out.println("Failed to apply");
        }
    }

    private static void fixDDOMMaps() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection maps = cm.repo().search("Unreal Tournament 2004", "MAP", "DOM-", null);
        for (Addon c : maps) {
            if (!(c instanceof org.unrealarchive.content.addons.Map) || !c.name.startsWith("DOM") || ((org.unrealarchive.content.addons.Map)c).gametype.equalsIgnoreCase("Double Domination")) continue;
            org.unrealarchive.content.addons.Map map = (org.unrealarchive.content.addons.Map)cm.checkout(c.hash);
            map.gametype = "Double Domination";
            if (cm.checkin(new IndexResult<org.unrealarchive.content.addons.Map>(map, Collections.emptySet()), null)) {
                System.out.println("Stored changes for " + String.join((CharSequence)" / ", map.game, map.gametype, map.name));
                continue;
            }
            System.out.println("Failed to apply");
        }
        Collection packs = cm.repo().search("Unreal Tournament 2004", "MAP_PACK", null, null);
        for (Addon c : packs) {
            if (!(c instanceof MapPack) || !((MapPack)c).gametype.equalsIgnoreCase("Domination")) continue;
            MapPack map = (MapPack)cm.checkout(c.hash);
            map.gametype = "Double Domination";
            if (cm.checkin(new IndexResult<MapPack>(map, Collections.emptySet()), null)) {
                System.out.println("Stored changes for " + String.join((CharSequence)" / ", map.game, map.gametype, map.name));
                continue;
            }
            System.out.println("Failed to apply");
        }
    }

    private static void fixMonsterHuntSnipersParadise() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().search("Unreal", "MAP", "MH-", null);
        for (Addon c : search) {
            if (!(c instanceof org.unrealarchive.content.addons.Map) || !c.name.toLowerCase().startsWith("mh-".toLowerCase())) continue;
            org.unrealarchive.content.addons.Map map = (org.unrealarchive.content.addons.Map)cm.checkout(c.hash);
            map.gametype = "Sniper's Paradise Monster Hunt";
            if (cm.checkin(new IndexResult<org.unrealarchive.content.addons.Map>(map, Collections.emptySet()), null)) {
                System.out.println("Stored changes for " + String.join((CharSequence)" / ", map.game, map.gametype, map.name));
                continue;
            }
            System.out.println("Failed to apply");
        }
    }

    private static void setMapPackGametypes() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().get(MapPack.class);
        for (MapPack mp : search) {
            if (!mp.gametype.equalsIgnoreCase("Unknown")) continue;
            MapPack mapPack = (MapPack)cm.checkout(mp.hash);
            mapPack.gametype = "Unknown";
            for (MapPack.PackMap map : mapPack.maps) {
                MapGameTypes.MapGameType gt = MapGameTypes.forMap((Games)Games.byName((String)mapPack.game()), (String)map.name);
                if (gt == null) continue;
                if (mapPack.gametype.equalsIgnoreCase("Unknown")) {
                    mapPack.gametype = gt.name();
                    continue;
                }
                if (mapPack.gametype.equalsIgnoreCase(gt.name())) continue;
                mapPack.gametype = "Mixed";
                break;
            }
            if (mapPack.gametype.equalsIgnoreCase("Unknown")) continue;
            if (cm.checkin(new IndexResult<MapPack>(mapPack, Collections.emptySet()), null)) {
                System.out.printf("Set gametype for %s to %s%n", mapPack.name, mapPack.gametype);
                continue;
            }
            System.out.println("Failed to apply");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixUnknownAuthors(String game, String type, String localFiles) throws IOException {
        Path root = Paths.get(localFiles, new String[0]);
        ContentManager cm = IndexHelper.manager();
        final HashMap fileHashes = new HashMap();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (ArchiveUtil.isArchive((Path)file)) {
                    fileHashes.put(Util.hash((Path)file), file);
                }
                return super.visitFile(file, attrs);
            }
        });
        System.out.printf("Cached %d file hashes%n", fileHashes.size());
        Collection search = cm.repo().search(game, type.toUpperCase(), null, null);
        Path tmpDir = Files.createTempDirectory("ua-authors", new FileAttribute[0]);
        List<Addon> contents = search.stream().filter(c -> !c.deleted).filter(c -> c.author.equalsIgnoreCase("unknown")).filter(c -> c.otherFiles > 0).sorted(Comparator.comparingInt(a -> a.fileSize)).toList();
        System.out.printf("Processing %d contents%n", contents.size());
        for (int i = 0; i < contents.size(); ++i) {
            if (i % 100 == 0) {
                System.out.printf("%d/%d%n", i, contents.size());
            }
            Addon co = cm.checkout(contents.get((int)i).hash);
            Path[] downloaded = new Path[]{null};
            try {
                Path existing = (Path)fileHashes.get(co.hash);
                if (existing == null) {
                    System.out.printf("Downloading %s (%dKB)%n", co.originalFilename, co.fileSize / 1024);
                    new LocalMirrorClient.Downloader(co, tmpDir, d -> {
                        System.out.printf("Downloaded %s%n", d.destination);
                        downloaded[0] = d.destination;
                    }).run();
                }
                Path file = downloaded[0] != null ? downloaded[0] : existing;
                Submission sub = new Submission(file, new String[0]);
                IndexLog log = new IndexLog();
                try (Incoming incoming = new Incoming(sub, log).prepare();){
                    co.author = IndexUtils.findAuthor(incoming);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (co.author.equalsIgnoreCase("unknown")) continue;
                IndexHelper.checkinChange(cm, co);
                continue;
            }
            catch (Throwable throwable) {
                continue;
            }
            finally {
                if (downloaded[0] != null) {
                    Files.deleteIfExists(downloaded[0]);
                }
            }
        }
    }

    private static void contentDependencies(String game, String type, String localFiles) throws IOException {
        Path root = Paths.get(localFiles, new String[0]);
        ContentManager cm = IndexHelper.manager();
        final HashMap fileHashes = new HashMap();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (ArchiveUtil.isArchive((Path)file)) {
                    fileHashes.put(Util.hash((Path)file), file);
                }
                return super.visitFile(file, attrs);
            }
        });
        System.out.printf("Cached %d file hashes%n", fileHashes.size());
        Collection search = cm.repo().search(game, type.toUpperCase(), null, null);
        Path tmpDir = Files.createTempDirectory("ua-deps", new FileAttribute[0]);
        List<Addon> contents = search.stream().filter(c -> !c.deleted).filter(c -> c.dependencies.isEmpty() || c.dependencies.values().stream().flatMap(Collection::stream).anyMatch(d -> d.status == Addon.DependencyStatus.MISSING)).sorted(Comparator.comparingInt(a -> a.fileSize)).toList();
        System.out.printf("Processing %d contents%n", contents.size());
        AtomicInteger counter = new AtomicInteger(0);
        contents.parallelStream().forEach(content -> {
            if (counter.incrementAndGet() % 100 == 0) {
                System.out.printf("%d/%d%n", counter.get(), contents.size());
            }
            Addon co = cm.checkout(content.hash);
            Path[] downloaded = new Path[]{null};
            try {
                Path existing = (Path)fileHashes.get(co.hash);
                if (existing == null) {
                    System.out.printf("Downloading %s (%dKB)%n", co.originalFilename, co.fileSize / 1024);
                    new LocalMirrorClient.Downloader(co, tmpDir, d -> {
                        System.out.printf("Downloaded %s%n", d.destination);
                        downloaded[0] = d.destination;
                    }).run();
                }
                Path file = downloaded[0] != null ? downloaded[0] : existing;
                Submission sub = new Submission(file, new String[0]);
                IndexLog log = new IndexLog();
                try (Incoming incoming = new Incoming(sub, log).prepare();){
                    co.dependencies = IndexUtils.dependencies(Games.byName((String)co.game), incoming);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!co.dependencies.isEmpty()) {
                    IndexHelper.checkinChange(cm, co);
                }
            }
            catch (Throwable ex) {
            }
            finally {
                if (downloaded[0] != null) {
                    try {
                        Files.deleteIfExists(downloaded[0]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    private static void umodDependencies(String game) throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().search(game, null, null, null);
        Path tmpDir = Files.createTempDirectory("ua-deps", new FileAttribute[0]);
        Set<String> umods = Set.of("umod", "ut2mod", "ut4mod");
        List<Addon> contents = search.stream().filter(c -> !c.deleted).filter(c -> c.files.stream().anyMatch(d -> umods.contains(Util.extension((String)d.name).toLowerCase()))).sorted(Comparator.comparingInt(a -> a.fileSize)).toList();
        System.out.printf("Processing %d contents%n", contents.size());
        for (int i = 0; i < contents.size(); ++i) {
            if (i % 10 == 0) {
                System.out.printf("%d/%d%n", i, contents.size());
            }
            Addon co = cm.checkout(contents.get((int)i).hash);
            new LocalMirrorClient.Downloader(co, tmpDir, d -> {
                System.out.printf("Downloaded %s%n", d.destination);
                try {
                    Submission sub = new Submission(d.destination, new String[0]);
                    IndexLog log = new IndexLog();
                    try (Incoming incoming = new Incoming(sub, log).prepare();){
                        co.dependencies = IndexUtils.dependencies(Games.byName((String)co.game), incoming);
                        co.files = new ArrayList();
                        for (Incoming.IncomingFile f : incoming.files(FileType.ALL)) {
                            if (!FileType.important((String)f.file)) continue;
                            co.files.add(new Addon.ContentFile(f.fileName(), f.fileSize(), f.hash()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    IndexHelper.checkinChange(cm, co);
                }
                catch (Throwable e) {
                }
                finally {
                    try {
                        Files.deleteIfExists(d.destination);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).run();
        }
    }

    private static void ukxDependencies() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().search(null, null, null, null);
        Path tmpDir = Files.createTempDirectory("ua-deps", new FileAttribute[0]);
        List<Addon> contents = search.stream().filter(c -> !c.deleted).filter(c -> c.files.stream().anyMatch(d -> Util.extension((String)d.name).equalsIgnoreCase("ukx"))).sorted(Comparator.comparingInt(a -> a.fileSize)).toList();
        System.out.printf("Processing %d contents%n", contents.size());
        for (int i = 0; i < contents.size(); ++i) {
            if (i % 10 == 0) {
                System.out.printf("%d/%d%n", i, contents.size());
            }
            Addon co = cm.checkout(contents.get((int)i).hash);
            new LocalMirrorClient.Downloader(co, tmpDir, d -> {
                System.out.printf("Downloaded %s%n", d.destination);
                try {
                    Submission sub = new Submission(d.destination, new String[0]);
                    IndexLog log = new IndexLog();
                    try (Incoming incoming = new Incoming(sub, log).prepare();){
                        co.dependencies = IndexUtils.dependencies(Games.byName((String)co.game), incoming);
                        co.files = new ArrayList();
                        for (Incoming.IncomingFile f : incoming.files(FileType.ALL)) {
                            if (!FileType.important((String)f.file)) continue;
                            co.files.add(new Addon.ContentFile(f.fileName(), f.fileSize(), f.hash()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    IndexHelper.checkinChange(cm, co);
                }
                catch (Throwable e) {
                }
                finally {
                    try {
                        Files.deleteIfExists(d.destination);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).run();
        }
    }

    private static void fixMissingModels(String game) throws IOException {
        ContentManager cm = IndexHelper.manager();
        Indexer indexer = new Indexer(cm.repo(), cm, new Indexer.IndexerEvents(){

            @Override
            public void starting(int foundFiles) {
            }

            @Override
            public void progress(int indexed, int total, Path currentFile) {
            }

            @Override
            public void indexed(Submission submission, Optional<IndexResult<? extends Addon>> indexed, IndexLog log) {
            }

            @Override
            public void completed(int indexedFiles, int errorCount) {
            }
        }, new Indexer.IndexerPostProcessor(){

            @Override
            public void indexed(Submission sub, Addon before, IndexResult<? extends Addon> result) {
                if (before != null) {
                    ((Addon)result.content).game = before.game;
                    if (!before.author.equals("Unknown")) {
                        ((Addon)result.content).author = before.author;
                    }
                    ((Addon)result.content).variationOf = before.variationOf;
                    ((Addon)result.content).attachments = before.attachments;
                }
                for (IndexResult.NewAttachment file : result.files) {
                    try {
                        Files.deleteIfExists(file.path());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                result.files.clear();
            }
        });
        Collection search = cm.repo().search(game, "MODEL", null, null);
        Path tmpDir = Files.createTempDirectory("ua-fix", new FileAttribute[0]);
        List<Addon> contents = search.stream().filter(c -> !c.deleted).sorted(Comparator.comparingInt(a -> a.fileSize)).toList();
        for (Addon c2 : contents) {
            try {
                new LocalMirrorClient.Downloader(c2, tmpDir, d -> {
                    System.out.printf("Downloaded %s%n", d.destination);
                    try {
                        indexer.index(true, false, 2, null, null, d.destination);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            Files.deleteIfExists(d.destination);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void fixModelNames(String game) throws IOException {
        ContentManager cm = IndexHelper.manager();
        Indexer indexer = new Indexer(cm.repo(), cm, new Indexer.IndexerEvents(){

            @Override
            public void starting(int foundFiles) {
            }

            @Override
            public void progress(int indexed, int total, Path currentFile) {
            }

            @Override
            public void indexed(Submission submission, Optional<IndexResult<? extends Addon>> indexed, IndexLog log) {
            }

            @Override
            public void completed(int indexedFiles, int errorCount) {
            }
        }, new Indexer.IndexerPostProcessor(){

            @Override
            public void indexed(Submission sub, Addon before, IndexResult<? extends Addon> result) {
                if (before != null) {
                    ((Addon)result.content).game = before.game;
                    ((Addon)result.content).author = before.author;
                    ((Addon)result.content).variationOf = before.variationOf;
                    ((Addon)result.content).attachments = before.attachments;
                    System.out.println("Model named " + before.name + " is now " + ((Addon)result.content).name);
                }
                for (IndexResult.NewAttachment file : result.files) {
                    try {
                        Files.deleteIfExists(file.path());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                result.files.clear();
            }
        });
        Collection search = cm.repo().search(game, "MODEL", null, null);
        Path tmpDir = Files.createTempDirectory("ua-models", new FileAttribute[0]);
        List<Addon> contents = search.stream().filter(c -> !c.deleted).filter(c -> c instanceof Model && ((Model)c).models.isEmpty()).sorted(Comparator.comparingInt(a -> a.fileSize)).toList();
        for (Addon c2 : contents) {
            try {
                new LocalMirrorClient.Downloader(c2, tmpDir, d -> {
                    System.out.printf("Downloaded %s%n", d.destination);
                    try {
                        indexer.index(true, false, 2, null, null, d.destination);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            Files.deleteIfExists(d.destination);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void fixDuplicateMapPics(String game, String type) throws IOException {
        CLI cli = CLI.parse((String[])new String[0]);
        DataStore imageStore = Main.store(DataStore.StoreContent.IMAGES, cli);
        DataStore contentStore = Main.store(DataStore.StoreContent.CONTENT, cli);
        ContentManager cm = new ContentManager(IndexHelper.repo(), contentStore, imageStore);
        Indexer indexer = new Indexer(cm.repo(), cm, new Indexer.IndexerEvents(){

            @Override
            public void starting(int foundFiles) {
            }

            @Override
            public void progress(int indexed, int total, Path currentFile) {
            }

            @Override
            public void indexed(Submission submission, Optional<IndexResult<? extends Addon>> indexed, IndexLog log) {
            }

            @Override
            public void completed(int indexedFiles, int errorCount) {
            }
        }, new Indexer.IndexerPostProcessor(){

            @Override
            public void indexed(Submission sub, Addon before, IndexResult<? extends Addon> result) {
                if (before != null) {
                    ((Addon)result.content).game = before.game;
                    ((Addon)result.content).author = before.author;
                    ((Addon)result.content).variationOf = before.variationOf;
                }
            }
        });
        Collection search = cm.repo().search(game, type.toUpperCase(), null, null);
        Path tmpDir = Files.createTempDirectory("ua-dupe-maps", new FileAttribute[0]);
        Map contents = search.stream().filter(c -> !c.deleted).filter(c -> !c.attachments.isEmpty()).collect(Collectors.groupingBy(c -> c.name.toLowerCase())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), (List)e.getValue()), HashMap::putAll);
        for (Addon c2 : contents.values().stream().flatMap(Collection::stream).sorted(Comparator.comparingInt(c -> c.fileSize)).toList()) {
            try {
                new LocalMirrorClient.Downloader(c2, tmpDir, d -> {
                    System.out.printf("Downloaded %s%n", d.destination);
                    try {
                        indexer.index(true, false, 2, null, null, d.destination);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            Files.deleteIfExists(d.destination);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).run();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private static void checkPathing(String game, String localFiles) throws IOException {
        Path root = Paths.get(localFiles, new String[0]);
        ContentManager cm = IndexHelper.manager();
        final HashMap fileHashes = new HashMap();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (ArchiveUtil.isArchive((Path)file)) {
                    fileHashes.put(Util.hash((Path)file), file);
                }
                return super.visitFile(file, attrs);
            }
        });
        System.out.printf("Cached %d file hashes%n", fileHashes.size());
        Collection search = cm.repo().search(game, "MAP", null, null);
        Path tmpDir = Files.createTempDirectory("ua-bots", new FileAttribute[0]);
        List<org.unrealarchive.content.addons.Map> maps = search.stream().filter(c -> !c.deleted && c instanceof org.unrealarchive.content.addons.Map).map(c -> (org.unrealarchive.content.addons.Map)c).filter(c -> !c.bots).toList();
        System.out.printf("Processing %d maps%n", maps.size());
        AtomicInteger counter = new AtomicInteger(0);
        maps.parallelStream().forEach(c -> {
            if (counter.incrementAndGet() % 100 == 0) {
                System.out.printf("%d/%d%n", counter.get(), maps.size());
            }
            Path[] downloaded = new Path[]{null};
            try {
                boolean was;
                Addon co;
                block31: {
                    co = cm.checkout(c.hash);
                    was = ((org.unrealarchive.content.addons.Map)co).bots;
                    Path existing = (Path)fileHashes.get(c.hash);
                    if (existing == null) {
                        new LocalMirrorClient.Downloader((Addon)c, tmpDir, d -> {
                            System.out.printf("Downloaded %s%n", d.destination);
                            downloaded[0] = d.destination;
                        }).run();
                    }
                    Path file = downloaded[0] != null ? downloaded[0] : existing;
                    Submission sub = new Submission(file, new String[0]);
                    IndexLog log = new IndexLog();
                    try (Incoming incoming = new Incoming(sub, log).prepare();){
                        if (incoming.files(FileType.MAP).isEmpty()) break block31;
                        try (Package pkg = new Package(new PackageReader(((Incoming.IncomingFile)incoming.files(FileType.MAP).stream().findFirst().get()).asChannel()));){
                            ((org.unrealarchive.content.addons.Map)co).bots = MapIndexHandler.botSupport(pkg);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (((org.unrealarchive.content.addons.Map)co).bots != was) {
                    IndexHelper.checkinChange(cm, co);
                } else {
                    System.out.println("No change for " + String.join((CharSequence)" / ", co.game, co.name));
                }
            }
            catch (Throwable e) {
            }
            finally {
                if (downloaded[0] != null) {
                    try {
                        Files.deleteIfExists(downloaded[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static void findGametypes(String searchPath) throws IOException {
        Path root = Paths.get(searchPath, new String[0]);
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!ArchiveUtil.isArchive((Path)file)) {
                    return super.visitFile(file, attrs);
                }
                Submission sub = new Submission(file, new String[0]);
                IndexLog log = new IndexLog();
                ArrayList gametypes = new ArrayList();
                try (Incoming incoming = new Incoming(sub, log).prepare();){
                    IndexUtils.readIntFiles(incoming, incoming.files(FileType.INT)).filter(Objects::nonNull).forEach(intFile -> {
                        IntFile.Section section = intFile.section("public");
                        if (section == null) {
                            return;
                        }
                        IntFile.ListValue objects = section.asList("Object");
                        for (IntFile.Value value : objects.values()) {
                            IntFile.MapValue mapVal;
                            if (!(value instanceof IntFile.MapValue) || !(mapVal = (IntFile.MapValue)value).containsKey("MetaClass") || !mapVal.get("MetaClass").toLowerCase().contains("tournamentgameinfo")) continue;
                            gametypes.add(mapVal.getOrDefault("Name", "Dunno"));
                        }
                    });
                    if (!gametypes.isEmpty()) {
                        System.out.printf("%n%s: %s%n", file, String.join((CharSequence)", ", gametypes));
                    } else {
                        System.out.print(".");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return super.visitFile(file, attrs);
            }
        });
    }

    public static void findUnrealPlayground() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().search("Unreal Tournament", "MAP_PACK", null, null);
        search.stream().map(c -> (MapPack)c).sorted().forEach(c -> {
            for (Download dl : c.downloads) {
                if (!dl.url.contains("unrealplayground")) continue;
                System.out.printf("[url=https://unrealarchive.org/%s.html]%s[/url] - %d maps, by %s%n", c.slugPath(Paths.get("", new String[0])), c.name, c.maps.size(), c.author);
                break;
            }
        });
    }

    public static void removeGamefrontOnlineLinks() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().all();
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            boolean changed = false;
            for (Download dl : co.downloads) {
                if (!dl.url.contains("gamefront.online")) continue;
                dl.state = Download.DownloadState.MISSING;
                changed = true;
            }
            IndexHelper.maybeCheckin(cm, co, changed);
        }
    }

    public static void removeUnrealPlaygroundLinks() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().all();
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            boolean changed = false;
            for (Download dl : co.downloads) {
                if (!dl.url.contains("unrealplayground") || dl.state != Download.DownloadState.OK) continue;
                dl.state = Download.DownloadState.MISSING;
                changed = true;
            }
            IndexHelper.maybeCheckin(cm, co, changed);
        }
    }

    public static void removeVohzdUnrealLinks() throws IOException, InterruptedException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().all();
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            boolean[] changed = new boolean[]{false};
            for (Download dl : co.downloads) {
                Thread.sleep((long)(250.0 * Math.random()));
                if (!dl.url.contains("files.vohzd.com") || !co.game().equalsIgnoreCase("unreal") && !co.game().equalsIgnoreCase("unreal 2") || dl.state != Download.DownloadState.OK) continue;
                Util.urlRequest((String)dl.url, (String)"HEAD", ok -> System.out.printf("OK: %s%n", co.name()), failed -> {
                    dl.state = Download.DownloadState.MISSING;
                    changed[0] = true;
                });
            }
            IndexHelper.maybeCheckin(cm, co, changed[0]);
        }
    }

    public static void removeDeadLinks() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().all();
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            boolean changed = co.downloads.removeIf(d -> d.state == Download.DownloadState.MISSING);
            IndexHelper.maybeCheckin(cm, co, changed);
        }
    }

    public static void removeWasabiLinks() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().all();
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            boolean changed = co.downloads.removeIf(d -> d.url.contains("eu-central-1.wasabisys.com"));
            IndexHelper.maybeCheckin(cm, co, changed);
        }
    }

    public static void moveAll() throws IOException {
        ContentManager cm = IndexHelper.manager();
        ContentManager cm2 = new ContentManager((SimpleAddonRepository)new SimpleAddonRepository.FileRepository(Paths.get("/home/shrimp/tmp/unreal-archive-data", new String[0])), DataStore.NOP, DataStore.NOP);
        Collection search = cm.repo().all();
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            IndexHelper.checkinChange(cm2, co);
        }
    }

    public static void reindexMapsWithThemes(String game, String type, String localFiles) throws IOException {
        ContentManager cm = IndexHelper.manager();
        Path root = Paths.get(localFiles, new String[0]);
        final HashMap fileHashes = new HashMap();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                fileHashes.put(Util.hash((Path)file), file);
                return super.visitFile(file, attrs);
            }
        });
        System.out.printf("Cached %d file hashes", fileHashes.size());
        Indexer indexer = new Indexer(cm.repo(), cm, new Indexer.IndexerEvents(){

            @Override
            public void starting(int foundFiles) {
            }

            @Override
            public void progress(int indexed, int total, Path currentFile) {
            }

            @Override
            public void indexed(Submission submission, Optional<IndexResult<? extends Addon>> indexed, IndexLog log) {
            }

            @Override
            public void completed(int indexedFiles, int errorCount) {
            }
        }, new Indexer.IndexerPostProcessor(){

            @Override
            public void indexed(Submission sub, Addon before, IndexResult<? extends Addon> result) {
                if (before != null) {
                    ((Addon)result.content).game = before.game;
                    ((Addon)result.content).author = before.author;
                    ((Addon)result.content).variationOf = before.variationOf;
                    ((Addon)result.content).attachments = before.attachments;
                }
                for (IndexResult.NewAttachment file : result.files) {
                    try {
                        Files.deleteIfExists(file.path());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                result.files.clear();
                if (before instanceof org.unrealarchive.content.addons.Map && result.content instanceof org.unrealarchive.content.addons.Map) {
                    ((org.unrealarchive.content.addons.Map)result.content).gametype = ((org.unrealarchive.content.addons.Map)before).gametype;
                }
                if (before instanceof MapPack && result.content instanceof MapPack) {
                    ((MapPack)result.content).gametype = ((MapPack)before).gametype;
                }
            }
        });
        Collection search = cm.repo().search(game, type, null, null);
        Path tmpDir = Files.createTempDirectory("ua-themes", new FileAttribute[0]);
        for (Addon c : search) {
            if (c instanceof org.unrealarchive.content.addons.Map && !((org.unrealarchive.content.addons.Map)c).themes.isEmpty() || c instanceof MapPack && !((MapPack)c).themes.isEmpty()) continue;
            Path existing = (Path)fileHashes.get(c.hash);
            try {
                if (existing != null) {
                    System.out.printf("Indexing %s%n", existing);
                    try {
                        indexer.index(true, false, 2, null, null, existing);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                new LocalMirrorClient.Downloader(c, tmpDir, d -> {
                    System.out.printf("Downloaded %s%n", d.destination);
                    try {
                        indexer.index(true, false, 2, null, null, d.destination);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            Files.deleteIfExists(d.destination);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void findPopularTextures(String game, String type, String localFiles) throws IOException {
        ContentManager cm = IndexHelper.manager();
        Path root = Paths.get(localFiles, new String[0]);
        final HashMap fileHashes = new HashMap();
        System.out.println("Finding existing files...");
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                fileHashes.put(Util.hash((Path)file), file);
                return super.visitFile(file, attrs);
            }
        });
        System.out.printf("Cached %d file hashes%n", fileHashes.size());
        Collection search = cm.repo().search(game, type, null, null);
        Path tmpDir = Files.createTempDirectory("ua-themes", new FileAttribute[0]);
        HashMap textures = new HashMap();
        for (Addon c : search) {
            try {
                Path existing = (Path)fileHashes.get(c.hash);
                if (existing == null) continue;
                System.out.print(".");
                Submission sub = new Submission(existing, new String[0]);
                IndexLog log = new IndexLog();
                try {
                    Incoming incoming = new Incoming(sub, log).prepare();
                    try (Package pkg = new Package(new PackageReader(((Incoming.IncomingFile)incoming.files(FileType.MAP).stream().findFirst().get()).asChannel()));){
                        IndexHelper.themes(pkg).forEach(t -> textures.compute(t, (k, count) -> count == null ? 1 : count + 1));
                    }
                    finally {
                        if (incoming == null) continue;
                        incoming.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        textures.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).forEach(e -> System.out.printf("%d\t:\t%s%n", e.getValue(), e.getKey()));
    }

    public static Set<String> themes(Package pkg) {
        HashMap foundThemes = new HashMap();
        pkg.objectsByClassName("Polys").forEach(o -> {
            Polys polys = (Polys)o.object();
            polys.polys.stream().map(p -> p.texture.get()).filter(n -> n instanceof Import).map(n -> (Import)n).forEach(i -> {
                Import current = i;
                Named parent = i.packageIndex.get();
                while (parent instanceof Import) {
                    current = (Import)parent;
                    parent = current.packageIndex.get();
                }
                foundThemes.compute(current.name.name, (k, v) -> {
                    int n;
                    if (v == null) {
                        n = 1;
                    } else {
                        v = v + 1;
                        n = v;
                    }
                    return n;
                });
            });
        });
        double totalScore = foundThemes.values().stream().mapToInt(e -> e).sum();
        return foundThemes.entrySet().stream().filter(e -> (double)((Integer)e.getValue()).intValue() / totalScore > 0.05).collect(Collectors.toMap(Map.Entry::getKey, v -> BigDecimal.valueOf((double)((Integer)v.getValue()).intValue() / totalScore).setScale(1, RoundingMode.HALF_UP).doubleValue())).keySet();
    }

    private static void fixMissingScreenshots() throws IOException {
        LocalDate dateFrom = LocalDate.parse("2025-03-12");
        LocalDate dateTo = LocalDate.parse("2025-03-15");
        CLI cli = CLI.parse((String[])new String[0]);
        DataStore imageStore = Main.store(DataStore.StoreContent.IMAGES, cli);
        DataStore contentStore = Main.store(DataStore.StoreContent.CONTENT, cli);
        ContentManager cm = new ContentManager(IndexHelper.repo(), contentStore, imageStore);
        Indexer indexer = new Indexer(cm.repo(), cm, new Indexer.IndexerEvents(){

            @Override
            public void starting(int foundFiles) {
            }

            @Override
            public void progress(int indexed, int total, Path currentFile) {
            }

            @Override
            public void indexed(Submission submission, Optional<IndexResult<? extends Addon>> indexed, IndexLog log) {
            }

            @Override
            public void completed(int indexedFiles, int errorCount) {
            }
        }, new Indexer.IndexerPostProcessor(){

            @Override
            public void indexed(Submission sub, Addon before, IndexResult<? extends Addon> result) {
                if (before != null) {
                    ((Addon)result.content).name = before.name;
                    ((Addon)result.content).description = before.description;
                    ((Addon)result.content).game = before.game;
                    ((Addon)result.content).author = before.author;
                    ((Addon)result.content).variationOf = before.variationOf;
                    Object t = result.content;
                    if (t instanceof org.unrealarchive.content.addons.Map) {
                        org.unrealarchive.content.addons.Map m = (org.unrealarchive.content.addons.Map)t;
                        m.gametype = ((org.unrealarchive.content.addons.Map)before).gametype;
                    }
                    if ((t = result.content) instanceof MapPack) {
                        MapPack p = (MapPack)t;
                        p.gametype = ((MapPack)before).gametype;
                    }
                }
            }
        });
        Collection search = cm.repo().all(true);
        Path tmpDir = Files.createTempDirectory("ua-pics", new FileAttribute[0]);
        List<Addon> contents = search.stream().filter(c -> !c.deleted).filter(c -> c.attachments.isEmpty() && c.firstIndex.toLocalDate().isAfter(dateFrom) && c.firstIndex.toLocalDate().isBefore(dateTo)).sorted(Comparator.comparingInt(c -> c.fileSize)).toList();
        System.out.println(contents.size());
        for (Addon c2 : contents) {
            try {
                System.out.printf("Downloading %s%n", c2.name);
                new LocalMirrorClient.Downloader(c2, tmpDir, d -> {
                    System.out.printf("Downloaded %s%n", d.destination);
                    try {
                        indexer.index(true, false, 1, null, null, d.destination);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            Files.deleteIfExists(d.destination);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void removeDuplicateEntries() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().search(null, null, null, null);
        for (Addon c : search) {
            int was;
            Addon co = cm.checkout(c.hash);
            if (co instanceof Voice) {
                Voice thing = (Voice)co;
                was = thing.voices.hashCode();
                thing.voices = thing.voices.stream().distinct().map(s -> {
                    if (s.startsWith("\"")) {
                        s = s.substring(1);
                    }
                    if (s.endsWith("\"")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    return s;
                }).toList();
                IndexHelper.maybeCheckin(cm, (Addon)thing, was != thing.voices.hashCode());
                continue;
            }
            if (co instanceof Skin) {
                Skin thing = (Skin)co;
                was = thing.faces.hashCode() + thing.skins.hashCode();
                thing.faces = thing.faces.stream().distinct().map(s -> {
                    if (s.startsWith("\"")) {
                        s = s.substring(1);
                    }
                    if (s.endsWith("\"")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    return s;
                }).toList();
                thing.skins = thing.skins.stream().distinct().map(s -> {
                    if (s.startsWith("\"")) {
                        s = s.substring(1);
                    }
                    if (s.endsWith("\"")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    return s;
                }).toList();
                IndexHelper.maybeCheckin(cm, (Addon)thing, was != thing.faces.hashCode() + thing.skins.hashCode());
                continue;
            }
            if (co instanceof Model) {
                Model thing = (Model)co;
                was = thing.models.hashCode() + thing.skins.hashCode();
                thing.models = thing.models.stream().distinct().map(s -> {
                    if (s.startsWith("\"")) {
                        s = s.substring(1);
                    }
                    if (s.endsWith("\"")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    return s;
                }).toList();
                thing.skins = thing.skins.stream().distinct().map(s -> {
                    if (s.startsWith("\"")) {
                        s = s.substring(1);
                    }
                    if (s.endsWith("\"")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    return s;
                }).toList();
                IndexHelper.maybeCheckin(cm, (Addon)thing, was != thing.models.hashCode() + thing.skins.hashCode());
                continue;
            }
            if (!(co instanceof Mutator)) continue;
            Mutator thing = (Mutator)co;
            was = thing.mutators.hashCode() + thing.weapons.hashCode() + thing.vehicles.hashCode();
            thing.mutators = thing.mutators.stream().distinct().toList();
            thing.weapons = thing.weapons.stream().distinct().toList();
            thing.vehicles = thing.vehicles.stream().distinct().toList();
            IndexHelper.maybeCheckin(cm, (Addon)thing, was != thing.mutators.hashCode() + thing.weapons.hashCode() + thing.vehicles.hashCode());
        }
    }

    private static void removeDuplicateFiles() throws IOException {
        ContentManager cm = IndexHelper.manager();
        Collection search = cm.repo().search(null, null, null, null);
        for (Addon c : search) {
            Addon co = cm.checkout(c.hash);
            int was = co.files.hashCode();
            co.files = co.files.stream().distinct().toList();
            IndexHelper.maybeCheckin(cm, co, was != co.files.hashCode());
        }
    }
}

