/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing;

import java.util.ArrayList;
import java.util.List;

public class IndexLog {
    public static final IndexLog NOP = new IndexLog(){

        @Override
        public void log(EntryType type, String message) {
        }

        @Override
        public void log(EntryType type, String message, Throwable e) {
        }
    };
    public final List<LogEntry> log = new ArrayList<LogEntry>();

    public void log(EntryType type, String message) {
        this.log(type, message, null);
    }

    public void log(EntryType type, String message, Throwable e) {
        this.log.add(new LogEntry(System.currentTimeMillis(), type, message, e));
    }

    public boolean ok() {
        return this.log.isEmpty() || this.log.stream().noneMatch(l -> l.type == EntryType.FATAL);
    }

    public String toString() {
        return String.format("IndexLog [log=%s]", this.log);
    }

    public static enum EntryType {
        INFO,
        CONTINUE,
        FATAL;

    }

    public static class LogEntry {
        public final long timestamp;
        public final EntryType type;
        public final String message;
        public final Throwable exception;

        public LogEntry(long timestamp, EntryType type, String message, Throwable exception) {
            this.timestamp = timestamp;
            this.type = type;
            this.message = message;
            this.exception = exception;
        }

        public String toString() {
            return String.format("LogEntry [timestamp=%s, type=%s, message=%s, exception=%s]", new Object[]{this.timestamp, this.type, this.message, this.exception});
        }
    }
}

