/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.shrimpworks.unreal.dependencies.DependencyResolver;
import net.shrimpworks.unreal.dependencies.NativePackages;
import net.shrimpworks.unreal.dependencies.Resolved;
import net.shrimpworks.unreal.dependencies.ShippedPackages;
import net.shrimpworks.unreal.packages.IntFile;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.ExportedObject;
import net.shrimpworks.unreal.packages.entities.Import;
import net.shrimpworks.unreal.packages.entities.Name;
import net.shrimpworks.unreal.packages.entities.Named;
import net.shrimpworks.unreal.packages.entities.ObjectReference;
import net.shrimpworks.unreal.packages.entities.objects.Object;
import net.shrimpworks.unreal.packages.entities.objects.Texture;
import net.shrimpworks.unreal.packages.entities.objects.Texture2D;
import net.shrimpworks.unreal.packages.entities.properties.ArrayProperty;
import net.shrimpworks.unreal.packages.entities.properties.ObjectProperty;
import net.shrimpworks.unreal.packages.entities.properties.Property;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexLog;
import org.unrealarchive.indexing.IndexResult;

public class IndexUtils {
    public static final String RELEASE_UT99 = "1999-11";
    public static final Pattern AUTHOR_MATCH = Pattern.compile("(.+)?(author|by)(\\(s\\))?([\\s:]+)?(.{4,35})(\\s+)?", 2);
    public static final Pattern PLAYER_MATCH = Pattern.compile("(.+)?(player)(s| count)?([\\s:]+)?([A-Za-z0-9 \\-]{1,16})(\\s+)?", 2);
    public static final Pattern UT3_SCREENSHOT_MATCH = Pattern.compile("<Images:([^.]*)\\.(.*\\.)?([^>]+)>", 2);
    public static final String SHOT_NAME = "%s_shot_%s_%d.png";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Games game(Incoming incoming) {
        if (incoming.submission.override.get("game", null) != null) {
            return Games.byName((String)incoming.submission.override.get("game", Games.UNREAL_TOURNAMENT.name));
        }
        Set<Incoming.IncomingFile> files = incoming.files(FileType.PACKAGES);
        if (files.isEmpty()) {
            return Games.UNKNOWN;
        }
        if (incoming.submission.filePath.getFileName().toString().contains("227")) {
            return Games.UNREAL;
        }
        if (incoming.submission.filePath.getFileName().toString().contains("ut2003")) {
            return Games.UNREAL_TOURNAMENT_2003;
        }
        if (incoming.submission.filePath.getFileName().toString().contains("ut2k3")) {
            return Games.UNREAL_TOURNAMENT_2003;
        }
        if (!incoming.files(FileType.PLAYER).isEmpty()) {
            return Games.UNREAL_TOURNAMENT_2004;
        }
        if (!incoming.files(FileType.PACKAGE).isEmpty()) {
            return Games.UNREAL_TOURNAMENT_3;
        }
        if (files.stream().anyMatch(f -> Util.extension((String)f.file).equalsIgnoreCase("usx"))) {
            return Games.UNREAL_TOURNAMENT_2004;
        }
        if (files.stream().anyMatch(f -> Util.extension((String)f.file).equalsIgnoreCase("ut2"))) {
            return Games.UNREAL_TOURNAMENT_2004;
        }
        if (files.stream().anyMatch(f -> Util.extension((String)f.file).equalsIgnoreCase("ut3"))) {
            return Games.UNREAL_TOURNAMENT_3;
        }
        if (files.stream().anyMatch(f -> Util.extension((String)f.file).equalsIgnoreCase("run"))) {
            return Games.RUNE;
        }
        if (files.stream().anyMatch(f -> Util.extension((String)f.file).equalsIgnoreCase("un2"))) {
            return Games.UNREAL_2;
        }
        Iterator<Incoming.IncomingFile> iterator = files.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                incoming.log.log(IndexLog.EntryType.CONTINUE, "Could not determine game for content");
                return Games.UNKNOWN;
            }
            Incoming.IncomingFile file = iterator.next();
            try (Package pkg = new Package(new PackageReader(file.asChannel()));){
                if (pkg.version < 68) {
                    Games games = Games.UNREAL;
                    return games;
                }
                if (pkg.version < 117) {
                    Games games = Games.UNREAL_TOURNAMENT;
                    return games;
                }
                if (pkg.version < 200) {
                    Games games = Games.UNREAL_TOURNAMENT_2004;
                    return games;
                }
                Games games = Games.UNREAL_TOURNAMENT_3;
                return games;
            }
            catch (Exception e) {
                incoming.log.log(IndexLog.EntryType.CONTINUE, "Could not determine game from file " + file.fileName(), e);
                continue;
            }
            break;
        }
    }

    public static List<BufferedImage> screenshots(Incoming incoming, Package map, Property screenshot) {
        return IndexUtils.screenshots(incoming, map, screenshot, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<BufferedImage> screenshots(Incoming incoming, Package map, Property screenshot, boolean scrapeFallback) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        if (screenshot != null) {
            ObjectReference shotRef = ((ObjectProperty)screenshot).value;
            Named shotResolved = shotRef.get();
            Package shotPackage = map;
            try {
                BufferedImage image;
                Object object = null;
                if (shotResolved instanceof Import) {
                    Named pkg = ((Import)shotResolved).packageIndex.get();
                    try {
                        String parentPkg = pkg instanceof Import ? ((Import)pkg).packageIndex.get().name().name : "None";
                        shotPackage = IndexUtils.findPackage(incoming, parentPkg.equals("None") ? pkg.name().name : parentPkg);
                        ExportedObject exp = shotPackage.objectByName(((Import)shotResolved).name);
                        object = exp.object();
                    }
                    catch (Exception exception) {}
                } else {
                    ExportedObject exp = map.objectByRef(shotRef);
                    object = exp.object();
                }
                if (object == null || (image = IndexUtils.screenshotFromObject(shotPackage, object)) == null) return images;
                images.add(image);
                return images;
            }
            catch (Exception e) {
                incoming.log.log(IndexLog.EntryType.CONTINUE, "Failed to read screenshot from packages", e);
                return images;
            }
            finally {
                if (shotPackage != map) {
                    try {
                        shotPackage.close();
                    }
                    catch (IOException e) {
                        incoming.log.log(IndexLog.EntryType.INFO, "Screenshot cleanup failed", e);
                    }
                }
            }
        }
        if (!scrapeFallback) return images;
        images.addAll(IndexUtils.scrapeScreenshots(incoming, map));
        return images;
    }

    private static List<BufferedImage> scrapeScreenshots(Incoming incoming, Package map) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        if (map.version > 200) {
            IndexUtils.readIntFiles(incoming, incoming.files(FileType.INI)).findFirst().ifPresent(ini -> ini.sections().forEach(s -> {
                Matcher matcher;
                IntFile.Value shot = ini.section(s).value("PreviewImageMarkup");
                if (shot instanceof IntFile.SimpleValue && (matcher = UT3_SCREENSHOT_MATCH.matcher(((IntFile.SimpleValue)shot).value())).find()) {
                    ExportedObject export = map.objectByName(new Name(matcher.group(3)));
                    if (export == null) {
                        return;
                    }
                    Object object = export.object();
                    if (object instanceof Texture2D) {
                        images.add(IndexUtils.screenshotFromObject(map, object));
                    }
                    if (object.className().equals("Material") && object.property("ReferencedTextures") instanceof ArrayProperty) {
                        ((ArrayProperty)object.property((String)"ReferencedTextures")).values.forEach(t -> {
                            Object tex;
                            if (t instanceof ObjectProperty && (tex = map.objectByRef(((ObjectProperty)t).value).object()) instanceof Texture2D) {
                                images.add(IndexUtils.screenshotFromObject(map, tex));
                            }
                        });
                    }
                }
            }));
        }
        if (!images.isEmpty()) {
            return images;
        }
        Stream.concat(map.exportsByClassName("Texture").stream(), map.exportsByClassName("Texture2D").stream()).filter(t -> t.name.name.toLowerCase().startsWith("screen") || t.name.name.toLowerCase().contains("shot")).map(t -> map.objectByName(t.name)).filter(Objects::nonNull).map(ExportedObject::object).filter(Objects::nonNull).map(o -> IndexUtils.screenshotFromObject(map, o)).filter(Objects::nonNull).forEach(images::add);
        return images;
    }

    public static BufferedImage screenshotFromObject(Package shotPackage, Object object) {
        block5: {
            block6: {
                if (!object.className().equals("MaterialSequence")) break block5;
                Property fallbackMaterial = object.property("FallbackMaterial");
                if (fallbackMaterial == null) break block6;
                ExportedObject fallback = shotPackage.objectByRef(((ObjectProperty)fallbackMaterial).value);
                Object fallbackObj = fallback.object();
                if (!(fallbackObj instanceof Texture)) break block5;
                object = fallbackObj;
                break block5;
            }
            Collection textures = shotPackage.objectsByClassName("Texture");
            for (ExportedObject texture : textures) {
                if (!texture.name.name.toLowerCase().contains("shot") && !texture.name.name.toLowerCase().contains("screen") && !texture.name.name.toLowerCase().contains("preview")) continue;
                object = texture.object();
                break;
            }
            if (!(object instanceof Texture)) {
                for (ExportedObject texture : textures) {
                    Texture tex = (Texture)texture.object();
                    Texture.MipMap mip = tex.mipMaps()[0];
                    if (mip.width != 512 || mip.height != 256) continue;
                    object = texture.object();
                    break;
                }
            }
        }
        if (object instanceof Texture) {
            return ((Texture)object).mipMaps()[0].get();
        }
        if (object instanceof Texture2D) {
            return ((Texture2D)object).mipMaps()[0].get();
        }
        return null;
    }

    public static void saveImages(String shotTemplate, Addon content, List<BufferedImage> screenshots, Set<IndexResult.NewAttachment> attachments) throws IOException {
        for (BufferedImage screenshot : screenshots) {
            String shotName = String.format(shotTemplate, Util.slug((String)content.name), content.hash.substring(0, 8), attachments.size() + 1);
            Path out = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(shotName);
            ImageIO.write((RenderedImage)screenshot, "png", out.toFile());
            attachments.add(new IndexResult.NewAttachment(Addon.AttachmentType.IMAGE, shotName, out));
        }
    }

    public static Package findPackage(Incoming incoming, String pkg) {
        Set<Incoming.IncomingFile> files = incoming.files(FileType.PACKAGES);
        for (Incoming.IncomingFile f : files) {
            String name = f.fileName();
            if (!(name = name.substring(0, name.lastIndexOf("."))).equalsIgnoreCase(pkg)) continue;
            return new Package(new PackageReader(f.asChannel()));
        }
        throw new IllegalStateException("Failed to find package " + pkg);
    }

    public static List<BufferedImage> findImageFiles(Incoming incoming) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        Set<Incoming.IncomingFile> files = incoming.files(FileType.IMAGE);
        for (Incoming.IncomingFile img : files) {
            try {
                BufferedImage image = ImageIO.read(Channels.newInputStream(Objects.requireNonNull(img.asChannel())));
                if (image == null) continue;
                images.add(image);
            }
            catch (Exception e) {
                incoming.log.log(IndexLog.EntryType.CONTINUE, "Failed to load image from archive", e);
            }
        }
        return images;
    }

    public static List<String> textContent(Incoming incoming, FileType ... fileTypes) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        for (Incoming.IncomingFile f : incoming.files(fileTypes)) {
            lines.addAll(IndexUtils.textContent(incoming, f, new ArrayList<Charset>(List.of(StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1, Charset.forName("Cp1252"), StandardCharsets.US_ASCII))));
        }
        return lines;
    }

    private static List<String> textContent(Incoming incoming, Incoming.IncomingFile file, List<Charset> encodings) throws IOException {
        while (!encodings.isEmpty()) {
            List<String> list;
            Charset encoding = encodings.removeFirst();
            BufferedReader br = new BufferedReader(Channels.newReader((ReadableByteChannel)file.asChannel(), encoding));
            try {
                list = br.lines().toList();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (UncheckedIOException | MalformedInputException ex) {
                    if (encodings.isEmpty()) {
                        incoming.log.log(IndexLog.EntryType.CONTINUE, "Could not read file file as " + encoding.name() + ", giving up");
                        break;
                    }
                    incoming.log.log(IndexLog.EntryType.CONTINUE, "Could not read file file as " + encoding.name() + ", trying " + encodings.getFirst().name());
                }
            }
            br.close();
            return list;
        }
        return List.of();
    }

    public static String findAuthor(Incoming incoming) {
        return IndexUtils.findAuthor(incoming, false);
    }

    public static String findAuthor(Incoming incoming, boolean searchIntFiles) {
        FileType[] fileTypeArray;
        if (searchIntFiles) {
            FileType[] fileTypeArray2 = new FileType[3];
            fileTypeArray2[0] = FileType.TEXT;
            fileTypeArray2[1] = FileType.HTML;
            fileTypeArray = fileTypeArray2;
            fileTypeArray2[2] = FileType.INT;
        } else {
            FileType[] fileTypeArray3 = new FileType[2];
            fileTypeArray3[0] = FileType.TEXT;
            fileTypeArray = fileTypeArray3;
            fileTypeArray3[1] = FileType.HTML;
        }
        FileType[] types = fileTypeArray;
        try {
            List<String> lines = IndexUtils.textContent(incoming, types);
            String maybeAuthor = IndexUtils.findAuthor(lines);
            if (maybeAuthor != null) {
                return maybeAuthor;
            }
        }
        catch (IOException e) {
            incoming.log.log(IndexLog.EntryType.CONTINUE, "Failed attempt to read author", e);
        }
        return "Unknown";
    }

    public static String findAuthor(List<String> lines) {
        for (String s : lines) {
            Matcher m = AUTHOR_MATCH.matcher(s);
            if (!m.matches() || m.group(5).trim().isEmpty()) continue;
            return m.group(5).trim();
        }
        return null;
    }

    public static String findPlayerCount(Incoming incoming) throws IOException {
        FileType[] types = new FileType[]{FileType.TEXT, FileType.HTML};
        List<String> lines = IndexUtils.textContent(incoming, types);
        for (String s : lines) {
            Matcher m = PLAYER_MATCH.matcher(s);
            if (!m.matches() || m.group(5).trim().isEmpty()) continue;
            return m.group(5).trim();
        }
        return "Unknown";
    }

    public static Stream<IntFile> readIntFiles(Incoming incoming, Set<Incoming.IncomingFile> intFiles) {
        return IndexUtils.readIntFiles(incoming, intFiles, false);
    }

    public static Stream<IntFile> readIntFiles(Incoming incoming, Set<Incoming.IncomingFile> intFiles, boolean syntheticRoots) {
        return intFiles.stream().map(f -> {
            try {
                return IndexUtils.readIntFile(incoming, f, syntheticRoots, new ArrayList<Charset>(List.of(StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1, Charset.forName("Cp1252"), StandardCharsets.US_ASCII)));
            }
            catch (IOException e) {
                incoming.log.log(IndexLog.EntryType.CONTINUE, "Couldn't load INT file " + f.fileName(), e);
                return null;
            }
        });
    }

    private static IntFile readIntFile(Incoming incoming, Incoming.IncomingFile intFile, boolean syntheticRoots, List<Charset> encodings) throws IOException {
        while (!encodings.isEmpty()) {
            Charset encoding = encodings.removeFirst();
            try {
                return new IntFile(intFile.asChannel(), syntheticRoots, encoding);
            }
            catch (MalformedInputException ex) {
                if (encodings.isEmpty()) {
                    throw ex;
                }
                incoming.log.log(IndexLog.EntryType.CONTINUE, "Could not read int file as " + encoding.name() + ", trying " + encodings.getFirst().name());
            }
        }
        throw new IOException("Failed to load int file");
    }

    public static String friendlyName(String name) {
        String[] words = name.replaceAll("([-_.])", " ").trim().split("\\s");
        CharSequence[] res = new String[words.length];
        for (int i = 0; i < words.length; ++i) {
            res[i] = words[i].length() <= 1 ? words[i] : Character.toUpperCase(words[i].charAt(0)) + words[i].substring(1);
        }
        return String.join((CharSequence)" ", res);
    }

    public static Map<String, List<Addon.Dependency>> dependencies(Addon content, Incoming incoming) {
        return IndexUtils.dependencies(Games.byName((String)content.game), incoming);
    }

    public static Map<String, List<Addon.Dependency>> dependencies(Games game, Incoming incoming) {
        ShippedPackages shippedPackages = switch (game) {
            case Games.UNREAL -> ShippedPackages.UNREAL_GOLD;
            case Games.UNREAL_TOURNAMENT_2004 -> ShippedPackages.UNREAL_TOURNAMENT_2004;
            case Games.UNREAL_TOURNAMENT_3 -> ShippedPackages.UNREAL_TOURNAMENT_3;
            case Games.RUNE -> ShippedPackages.RUNE;
            default -> ShippedPackages.UNREAL_TOURNAMENT;
        };
        HashMap<String, List<Addon.Dependency>> dependencies = new HashMap<String, List<Addon.Dependency>>();
        try {
            DependencyResolver resolver = new DependencyResolver(incoming.contentRoot, NativePackages.DEFAULT, e -> incoming.log.log(IndexLog.EntryType.CONTINUE, "Dependency resolution error for " + e.file.toString(), (Throwable)e));
            for (Incoming.IncomingFile file : incoming.files(FileType.CODE, FileType.MAP, FileType.TEXTURE, FileType.STATICMESH, FileType.ANIMATION)) {
                ArrayList depList = new ArrayList();
                try {
                    Map resolved = resolver.resolve(Util.plainName((String)file.fileName()));
                    resolved.forEach((k, v) -> {
                        if (!shippedPackages.contains(k)) {
                            depList.add(new Addon.Dependency(IndexUtils.resolveDependency(v), k, null));
                        }
                    });
                }
                catch (Throwable e2) {
                    incoming.log.log(IndexLog.EntryType.CONTINUE, "Dependency resolution error for " + file.fileName(), e2);
                }
                if (depList.isEmpty()) continue;
                dependencies.put(file.fileName(), depList);
            }
        }
        catch (IOException e3) {
            incoming.log.log(IndexLog.EntryType.CONTINUE, "Dependency resolution failed for " + String.valueOf(incoming.submission.filePath), e3);
        }
        return dependencies;
    }

    private static Addon.DependencyStatus resolveDependency(Set<Resolved> resolved) {
        Addon.DependencyStatus result = null;
        for (Resolved r : resolved) {
            if (!r.children.isEmpty()) {
                Addon.DependencyStatus childResult = IndexUtils.resolveDependency(r.children);
                if (result == null) {
                    result = childResult;
                } else if (result == Addon.DependencyStatus.OK && childResult == Addon.DependencyStatus.MISSING) {
                    result = Addon.DependencyStatus.PARTIAL;
                }
            }
            if (r.resolved == null && result == null) {
                result = Addon.DependencyStatus.MISSING;
                continue;
            }
            if (r.resolved != null && result == null) {
                result = Addon.DependencyStatus.OK;
                continue;
            }
            if (r.resolved == null && result == Addon.DependencyStatus.OK) {
                result = Addon.DependencyStatus.PARTIAL;
                continue;
            }
            if (r.resolved != null && result == Addon.DependencyStatus.MISSING) {
                result = Addon.DependencyStatus.PARTIAL;
                continue;
            }
            if (r.resolved == null) continue;
            result = Addon.DependencyStatus.OK;
        }
        return result == null ? Addon.DependencyStatus.MISSING : result;
    }
}

