/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.unrealarchive.common.CLI;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.content.addons.SimpleAddonType;
import org.unrealarchive.indexing.AddonClassifier;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexLog;
import org.unrealarchive.indexing.Indexer;
import org.unrealarchive.indexing.Submission;

public class Scanner {
    private final SimpleAddonRepository repository;
    private final boolean newOnly;
    private final Pattern nameInclude;
    private final Pattern nameExclude;
    private final long maxFileSize;
    private final int concurrency;

    public Scanner(SimpleAddonRepository repository, CLI cli) {
        this.repository = repository;
        this.newOnly = cli.option("new-only", "").equalsIgnoreCase("true") || cli.option("new-only", "").equalsIgnoreCase("1");
        this.maxFileSize = Long.parseLong(cli.option("max-size", "0"));
        this.concurrency = Integer.parseInt(cli.option("concurrency", "1"));
        this.nameInclude = cli.option("include", "").isBlank() ? null : Pattern.compile(cli.option("include", ""));
        this.nameExclude = cli.option("exclude", "").isBlank() ? null : Pattern.compile(cli.option("exclude", ""));
    }

    public void scan(ScannerEvents events, Path ... inputPath) throws IOException {
        ArrayList<Path> all = new ArrayList<Path>();
        for (Path p : inputPath) {
            all.addAll(this.findFiles(p));
        }
        events.starting(all.size(), this.nameInclude, this.nameExclude);
        AtomicInteger done = new AtomicInteger();
        try (ForkJoinPool fjPool = new ForkJoinPool(this.concurrency);){
            ((ForkJoinTask)fjPool.submit(() -> all.parallelStream().sorted().forEachOrdered(path -> {
                events.progress(done.incrementAndGet(), all.size(), (Path)path);
                Submission sub = new Submission((Path)path, new String[0]);
                IndexLog log = new IndexLog();
                this.scanFile(sub, log, events::scanned);
            }))).join();
        }
        events.completed(done.get());
    }

    private List<Path> findFiles(Path inputPath) throws IOException {
        final ArrayList<Path> all = new ArrayList<Path>();
        if (Files.isDirectory(inputPath, new LinkOption[0])) {
            Files.walkFileTree(inputPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (Indexer.INCLUDE_TYPES.contains(Util.extension((Path)file).toLowerCase())) {
                        try {
                            if (Scanner.this.maxFileSize > 0L && Files.size(file) > Scanner.this.maxFileSize) {
                                return FileVisitResult.CONTINUE;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (Scanner.this.nameInclude != null && !Scanner.this.nameInclude.matcher(file.getFileName().toString()).matches()) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (Scanner.this.nameExclude != null && Scanner.this.nameExclude.matcher(file.getFileName().toString()).matches()) {
                            return FileVisitResult.CONTINUE;
                        }
                        all.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        } else if (Files.exists(inputPath, new LinkOption[0]) && Files.isRegularFile(inputPath, new LinkOption[0])) {
            all.add(inputPath);
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void scanFile(Submission sub, IndexLog log, Consumer<ScanResult> done) {
        block17: {
            SimpleAddonType classifiedType;
            Addon content;
            Throwable failed;
            block18: {
                Incoming incoming;
                block13: {
                    block14: {
                        block15: {
                            failed = null;
                            content = null;
                            classifiedType = SimpleAddonType.UNKNOWN;
                            incoming = new Incoming(sub, log);
                            content = this.repository.forHash(incoming.hash);
                            if (!this.newOnly || content == null) break block13;
                            incoming.close();
                            if (this.newOnly && content != null) break block14;
                            if (failed != null) break block15;
                            failed = log.log.stream().filter(l -> l.type == IndexLog.EntryType.FATAL && l.exception != null).map(l -> l.exception).findFirst().orElse(null);
                        }
                        done.accept(new ScanResult(sub.filePath, content != null, content != null ? SimpleAddonType.valueOf((String)content.contentType) : null, classifiedType, failed));
                    }
                    return;
                }
                try {
                    block16: {
                        incoming.prepare();
                        classifiedType = AddonClassifier.classify(incoming).contentType();
                        break block16;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        finally {
                            incoming.close();
                        }
                    }
                    if (this.newOnly && content != null) break block17;
                    if (failed != null) break block18;
                }
                catch (Throwable e) {
                    block19: {
                        try {
                            failed = e;
                            if (this.newOnly && content != null) break block17;
                            if (failed != null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (!this.newOnly || content == null) {
                                if (failed == null) {
                                    failed = log.log.stream().filter(l -> l.type == IndexLog.EntryType.FATAL && l.exception != null).map(l -> l.exception).findFirst().orElse(null);
                                }
                                done.accept(new ScanResult(sub.filePath, content != null, content != null ? SimpleAddonType.valueOf((String)content.contentType) : null, classifiedType, failed));
                            }
                            throw throwable;
                        }
                        failed = log.log.stream().filter(l -> l.type == IndexLog.EntryType.FATAL && l.exception != null).map(l -> l.exception).findFirst().orElse(null);
                    }
                    done.accept(new ScanResult(sub.filePath, content != null, content != null ? SimpleAddonType.valueOf((String)content.contentType) : null, classifiedType, failed));
                }
                failed = log.log.stream().filter(l -> l.type == IndexLog.EntryType.FATAL && l.exception != null).map(l -> l.exception).findFirst().orElse(null);
            }
            done.accept(new ScanResult(sub.filePath, content != null, content != null ? SimpleAddonType.valueOf((String)content.contentType) : null, classifiedType, failed));
        }
    }

    public static interface ScannerEvents {
        public void starting(int var1, Pattern var2, Pattern var3);

        public void progress(int var1, int var2, Path var3);

        public void scanned(ScanResult var1);

        public void completed(int var1);
    }

    public record ScanResult(Path filePath, boolean known, SimpleAddonType oldType, SimpleAddonType newType, Throwable failed) {
        @Override
        public String toString() {
            return String.format("ScanResult [filePath=%s, known=%s, oldType=%s, newType=%s, failed=%s]", this.filePath, this.known, this.oldType, this.newType, this.failed);
        }
    }

    public static class CLIEventPrinter
    implements ScannerEvents {
        @Override
        public void starting(int foundFiles, Pattern included, Pattern excluded) {
            System.err.printf("Found %d file(s) to scan %s %s%n", foundFiles, included != null ? "matching " + included.pattern() : "", excluded != null ? "excluding " + excluded.pattern() : "");
            System.err.printf("%s;%s;%s;%s;%s%n", "File", "Known", "Current Type", "Scanned Type", "Failure");
        }

        @Override
        public void progress(int scanned, int total, Path currentFile) {
            System.err.printf("[%d/%d] : %s \r", scanned, total, Util.fileName((Path)currentFile));
        }

        @Override
        public void scanned(ScanResult scanned) {
            System.out.printf("%s;%s;%s;%s;%s%n", scanned.filePath, scanned.known ? "KNOWN" : "NEW", scanned.oldType != null ? scanned.oldType.name() : "-", scanned.newType.name(), scanned.failed != null ? String.format("%s(%s)", scanned.failed.getClass().getSimpleName(), scanned.failed.getMessage()) : "-");
        }

        @Override
        public void completed(int scannedFiles) {
            System.err.printf("%nCompleted scanning %d files%n", scannedFiles);
        }
    }
}

