/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.announcers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.shrimpworks.unreal.packages.IntFile;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.NameDescription;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.Announcer;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexHandler;
import org.unrealarchive.indexing.IndexLog;
import org.unrealarchive.indexing.IndexResult;
import org.unrealarchive.indexing.IndexUtils;

public class AnnouncerIndexHandler
implements IndexHandler<Announcer> {
    @Override
    public void index(Incoming incoming, Addon current, Consumer<IndexResult<Announcer>> completed) {
        Announcer a = (Announcer)current;
        IndexLog log = incoming.log;
        HashSet<IndexResult.NewAttachment> attachments = new HashSet<IndexResult.NewAttachment>();
        a.name = IndexUtils.friendlyName(a.name);
        Set<Incoming.IncomingFile> uclFiles = incoming.files(FileType.UCL);
        if (!uclFiles.isEmpty()) {
            this.readUclFiles(incoming, a, uclFiles);
        }
        if (a.announcers.size() == 1) {
            a.name = ((NameDescription)a.announcers.getFirst()).name;
            a.description = ((NameDescription)a.announcers.getFirst()).description;
        }
        a.announcers = a.announcers.stream().distinct().toList();
        a.game = IndexUtils.game((Incoming)incoming).name;
        a.author = IndexUtils.findAuthor(incoming, true);
        try {
            List<BufferedImage> images = IndexUtils.findImageFiles(incoming);
            IndexUtils.saveImages("%s_shot_%s_%d.png", (Addon)a, images, attachments);
        }
        catch (IOException e) {
            log.log(IndexLog.EntryType.CONTINUE, "Failed to save images", e);
        }
        completed.accept(new IndexResult<Announcer>(a, attachments));
    }

    private void readUclFiles(Incoming incoming, Announcer announcer, Set<Incoming.IncomingFile> uclFiles) {
        IndexUtils.readIntFiles(incoming, uclFiles, true).filter(Objects::nonNull).forEach(intFile -> {
            IntFile.Section section = intFile.section("root");
            if (section == null) {
                return;
            }
            IntFile.ListValue mutators = section.asList("Announcer");
            for (IntFile.Value value : mutators.values()) {
                IntFile.MapValue mapVal;
                if (!(value instanceof IntFile.MapValue) || !(mapVal = (IntFile.MapValue)value).containsKey("FallbackName")) continue;
                announcer.announcers.add(new NameDescription(mapVal.get("FallbackName"), mapVal.getOrDefault("FallbackDesc", "")));
            }
        });
    }

    public static class AnnouncerIndexHandlerFactory
    implements IndexHandler.IndexHandlerFactory<Announcer> {
        @Override
        public IndexHandler<Announcer> get() {
            return new AnnouncerIndexHandler();
        }
    }
}

